/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.container;

import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.ClickableLabelElement;
import net.minecraft.client.gui.DrawableSurfaceElement;
import net.minecraft.client.gui.TexturedButtonElement;
import net.minecraft.client.gui.container.AbstractContainerScreen;
import net.minecraft.client.gui.drawing.DrawableEditor;
import net.minecraft.client.gui.drawing.IDrawableSurface;
import net.minecraft.client.util.helper.Colors;
import net.minecraft.core.block.entity.FlagBlockEntity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.net.packet.CustomPayloadPacket;
import net.minecraft.core.player.inventory.menu.FlagMenu;
import net.minecraft.core.util.helper.MathHelper;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class FlagEditorScreen
extends AbstractContainerScreen
implements IDrawableSurface<Byte> {
    private final FlagBlockEntity flagEntity;
    private final int CANVAS_SCALE = 4;
    private final int CANVAS_WIDTH = 24;
    private final int CANVAS_HEIGHT = 16;
    private int xLast = 0;
    private int yLast = 0;
    private int mouseButton;
    private boolean isDrawing = false;
    private int canvasX = 0;
    private int canvasY = 0;
    private int selectedColor = 0;
    private ClickableLabelElement[] colorLabels;
    private final DrawableEditor<Byte> flagSurfaceEditor;
    private final DrawableEditor<Byte> drawOverlaySurfaceEditor;
    private TexturedButtonElement[] toolBtns;
    private int activeTool = 0;
    DrawableSurfaceElement flagSurface;
    DrawableSurfaceElement drawOverlaySurface;

    public FlagEditorScreen(Player player, FlagBlockEntity flagTileEntity) {
        super(new FlagMenu(player.inventory, flagTileEntity));
        this.flagEntity = flagTileEntity;
        this.xSize = 176;
        this.ySize = 195;
        flagTileEntity.owner = player.uuid;
        this.flagSurface = new DrawableSurfaceElement(24, 16, 4, flagTileEntity.flagColors);
        this.flagSurfaceEditor = new DrawableEditor<Byte>(this.flagSurface);
        this.drawOverlaySurface = new DrawableSurfaceElement(24, 16, 4);
        this.drawOverlaySurfaceEditor = new DrawableEditor<Byte>(this.drawOverlaySurface);
    }

    @Override
    public void init() {
        int i;
        super.init();
        this.buttons.clear();
        this.canvasX = (this.width - this.xSize) / 2 + 27;
        this.canvasY = (this.height - this.ySize) / 2 + 8;
        this.toolBtns = new TexturedButtonElement[7];
        for (i = 0; i < 7; ++i) {
            this.toolBtns[i] = new TexturedButtonElement(i, "/assets/minecraft/textures/gui/container/flag_editor.png", (this.width - this.xSize) / 2 + 12 + 22 * i, (this.height - this.ySize) / 2 + 76, 20 * i, 195, 20, 20);
            if (i == this.activeTool) {
                this.toolBtns[i].enabled = false;
            }
            this.buttons.add(this.toolBtns[i]);
        }
        this.colorLabels = new ClickableLabelElement[3];
        for (i = 0; i < 3; ++i) {
            this.colorLabels[i] = new ClickableLabelElement(100 + i, (this.width - this.xSize) / 2 + 150, (this.height - this.ySize) / 2 + 12 + i * 22, String.valueOf(i + 1), -1, 0);
            if (i != this.selectedColor) {
                this.colorLabels[i].setTextColor(-12632257);
                this.colorLabels[i].setShadow(false);
            }
            this.buttons.add(this.colorLabels[i]);
        }
        this.buttons.add(new ButtonElement(50, (this.width - this.xSize) / 2 + 12, (this.height - this.ySize) / 2 + 61, 12, 12, "").setTextures("minecraft:gui/misc/button_flag_flip", "minecraft:gui/misc/button_flag_flip_highlighted", "minecraft:gui/misc/button_flag_flip_disabled.png"));
    }

    private void renderCanvas() {
        this.canvasX = (this.width - this.xSize) / 2 + 27;
        this.canvasY = (this.height - this.ySize) / 2 + 8;
        int[] colors = new int[5];
        for (int i = 1; i < 4; ++i) {
            ItemStack stack = this.flagEntity.getItem(35 + i);
            if (stack == null || stack.getItem() != Items.DYE) continue;
            colors[i] = Colors.allFlagColors[TextFormatting.get((int)(15 - stack.getMetadata())).id].getARGB();
        }
        colors[4] = -1;
        this.flagSurface.colors = colors;
        this.drawOverlaySurface.colors = colors;
        GL11.glEnable(3042);
        GL11.glBlendFunc(769, 768);
        this.flagSurface.render(this.canvasX, this.canvasY);
        GL11.glDisable(3042);
        this.drawOverlaySurface.render(this.canvasX, this.canvasY);
    }

    @Override
    public void mouseClicked(int mx, int my, int buttonNum) {
        super.mouseClicked(mx, my, buttonNum);
        if (this.flagEntity.getItem(36 + this.selectedColor) == null) {
            return;
        }
        if (this.activeTool >= 0 && this.activeTool < 3) {
            if (!this.isDrawing) {
                int xInCanvas = (mx - this.canvasX) / 4;
                int yInCanvas = (my - this.canvasY) / 4;
                if (xInCanvas >= 0 && xInCanvas < 24 && yInCanvas >= 0 && yInCanvas < 16) {
                    this.isDrawing = true;
                    this.xLast = xInCanvas;
                    this.yLast = yInCanvas;
                    this.mouseButton = buttonNum;
                    byte color = 0;
                    if (this.mouseButton == 0) {
                        color = (byte)(this.selectedColor + 1);
                    }
                    this.flagSurfaceEditor.drawLine(xInCanvas, yInCanvas, xInCanvas, yInCanvas, color, this.activeTool + 1);
                    this.flagEntity.isDirty = true;
                }
            }
        } else if (this.activeTool == 3) {
            if (!this.isDrawing) {
                int xInCanvas = (mx - this.canvasX) / 4;
                int yInCanvas = (my - this.canvasY) / 4;
                if (xInCanvas >= 0 && xInCanvas < 24 && yInCanvas >= 0 && yInCanvas < 16) {
                    this.isDrawing = true;
                    this.mouseButton = buttonNum;
                    byte color = 0;
                    if (this.mouseButton == 0) {
                        color = (byte)(this.selectedColor + 1);
                    }
                    this.flagSurfaceEditor.floodFill(xInCanvas, yInCanvas, color);
                    this.flagEntity.isDirty = true;
                }
            }
        } else if (!(this.activeTool != 4 && this.activeTool != 5 && this.activeTool != 6 || this.isDrawing)) {
            int xInCanvas = (mx - this.canvasX) / 4;
            int yInCanvas = (my - this.canvasY) / 4;
            if (xInCanvas >= 0 && xInCanvas < 24 && yInCanvas >= 0 && yInCanvas < 16) {
                this.isDrawing = true;
                this.mouseButton = buttonNum;
                this.xLast = xInCanvas;
                this.yLast = yInCanvas;
            }
        }
    }

    @Override
    protected void buttonClicked(ButtonElement button) {
        super.buttonClicked(button);
        if (button.id >= 0 && button.id < 7) {
            this.toolBtns[this.activeTool].enabled = true;
            this.activeTool = button.id;
            button.enabled = false;
        }
        if (button.id == 50) {
            this.flagEntity.setFlipped(!this.flagEntity.getFlipped());
        }
        if (button.id >= 100 && button.id < 103) {
            this.colorLabels[this.selectedColor].setTextColor(-12566464);
            this.colorLabels[this.selectedColor].setShadow(false);
            this.selectedColor = button.id - 100;
            this.colorLabels[this.selectedColor].setTextColor(0xFFFFFFF);
            this.colorLabels[this.selectedColor].setShadow(true);
        }
    }

    @Override
    public void mouseReleased(int mx, int my, int buttonNum) {
        super.mouseReleased(mx, my, buttonNum);
        if (this.activeTool >= 0 && this.activeTool < 3) {
            if (this.isDrawing && buttonNum != -1) {
                this.isDrawing = false;
                this.mouseButton = -1;
            } else if (this.isDrawing) {
                int xInCanvas = (mx - this.canvasX) / 4;
                int yInCanvas = (my - this.canvasY) / 4;
                byte color = 0;
                if (this.mouseButton == 0) {
                    color = (byte)(this.selectedColor + 1);
                }
                if (MathHelper.abs(this.xLast - xInCanvas) <= 1.0f && MathHelper.abs(this.yLast - yInCanvas) <= 1.0f) {
                    this.flagSurfaceEditor.drawLine(xInCanvas, yInCanvas, xInCanvas, yInCanvas, color, this.activeTool + 1);
                    this.flagEntity.isDirty = true;
                } else {
                    this.flagSurfaceEditor.drawLine(this.xLast, this.yLast, xInCanvas, yInCanvas, color, this.activeTool + 1);
                    this.flagEntity.isDirty = true;
                }
                this.xLast = xInCanvas;
                this.yLast = yInCanvas;
            }
        } else if (this.activeTool == 3) {
            if (this.isDrawing && buttonNum != -1) {
                this.isDrawing = false;
                this.mouseButton = -1;
            }
        } else if (this.activeTool == 4) {
            if (this.isDrawing && buttonNum != -1) {
                this.isDrawing = false;
                int xInCanvas = (mx - this.canvasX) / 4;
                int yInCanvas = (my - this.canvasY) / 4;
                byte color = 0;
                if (this.mouseButton == 0) {
                    color = (byte)(this.selectedColor + 1);
                }
                this.flagSurfaceEditor.drawRectangle(this.xLast, this.yLast, xInCanvas, yInCanvas, color);
                this.flagEntity.isDirty = true;
                this.mouseButton = -1;
            }
        } else if (this.activeTool == 5) {
            if (this.isDrawing && buttonNum != -1) {
                this.isDrawing = false;
                int xInCanvas = (mx - this.canvasX) / 4;
                int yInCanvas = (my - this.canvasY) / 4;
                byte color = 0;
                if (this.mouseButton == 0) {
                    color = (byte)(this.selectedColor + 1);
                }
                this.flagSurfaceEditor.drawEllipse(this.xLast, this.yLast, xInCanvas, yInCanvas, color);
                this.flagEntity.isDirty = true;
                this.mouseButton = -1;
            }
        } else if (this.activeTool == 6 && this.isDrawing && buttonNum != -1) {
            this.isDrawing = false;
            int xInCanvas = (mx - this.canvasX) / 4;
            int yInCanvas = (my - this.canvasY) / 4;
            byte color = 0;
            if (this.mouseButton == 0) {
                color = (byte)(this.selectedColor + 1);
            }
            this.flagSurfaceEditor.drawLine(this.xLast, this.yLast, xInCanvas, yInCanvas, color, 1);
            this.flagEntity.isDirty = true;
            this.mouseButton = -1;
        }
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float f) {
        GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        this.mc.textureManager.loadTexture("/assets/minecraft/textures/gui/container/flag_editor.png").bind();
        int j = (this.width - this.xSize) / 2;
        int k = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(j, k, 0, 0, this.xSize, this.ySize);
        this.drawTexturedModalRect(j + 127, k + 8 + this.selectedColor * 22, 176, 0, 20, 20);
    }

    @Override
    public void render(int xm, int ym, float partialTick) {
        super.render(xm, ym, partialTick);
        this.drawOverlaySurface.clear();
        int xInCanvas = (xm - this.canvasX) / 4;
        int yInCanvas = (ym - this.canvasY) / 4;
        byte color = (byte)(this.selectedColor + 1);
        if (this.mouseButton == 1) {
            color = 4;
        }
        if (this.activeTool >= 0 && this.activeTool < 3) {
            this.drawOverlaySurfaceEditor.drawLine(xInCanvas, yInCanvas, xInCanvas, yInCanvas, color, this.activeTool + 1);
        } else if (this.activeTool == 3) {
            this.drawOverlaySurfaceEditor.drawLine(xInCanvas, yInCanvas, xInCanvas, yInCanvas, color, 1);
        } else if (this.activeTool == 4) {
            if (this.isDrawing) {
                this.drawOverlaySurfaceEditor.drawRectangle(this.xLast, this.yLast, xInCanvas, yInCanvas, color);
            } else {
                this.drawOverlaySurfaceEditor.drawLine(xInCanvas, yInCanvas, xInCanvas, yInCanvas, color, 1);
            }
        } else if (this.activeTool == 5) {
            if (this.isDrawing) {
                this.drawOverlaySurfaceEditor.drawEllipse(this.xLast, this.yLast, xInCanvas, yInCanvas, color);
            } else {
                this.drawOverlaySurfaceEditor.drawLine(xInCanvas, yInCanvas, xInCanvas, yInCanvas, color, 1);
            }
        } else if (this.activeTool == 6) {
            if (this.isDrawing) {
                this.drawOverlaySurfaceEditor.drawLine(this.xLast, this.yLast, xInCanvas, yInCanvas, color, 1);
            } else {
                this.drawOverlaySurfaceEditor.drawLine(xInCanvas, yInCanvas, xInCanvas, yInCanvas, color, 1);
            }
        }
        this.renderCanvas();
    }

    @Override
    protected void drawGuiContainerForegroundLayer() {
        this.font.drawString(I18n.getInstance().translateKey("gui.edit_flag.label.inventory"), 8, this.ySize - 96 + 2, -12566464);
    }

    @Override
    public void keyPressed(char eventCharacter, int eventKey, int mx, int my) {
        if (eventKey == Keyboard.KEY_ESCAPE || this.mc.gameSettings.keyInventory.isKeyboardKey(eventKey) || eventKey == Keyboard.KEY_BACK) {
            if (this.mc.theWorld.isClientSide) {
                this.mc.getSendQueue().addToSendQueue(new CustomPayloadPacket("BTA|Flag", this.flagEntity.flagColors));
            }
            this.mc.thePlayer.closeScreen();
        }
        if (eventKey == Keyboard.KEY_1 || eventKey == Keyboard.KEY_2 || eventKey == Keyboard.KEY_3) {
            this.colorLabels[this.selectedColor].setTextColor(-12566464);
            this.colorLabels[this.selectedColor].setShadow(false);
            this.selectedColor = eventKey - Keyboard.KEY_1;
            this.colorLabels[this.selectedColor].setTextColor(-1);
            this.colorLabels[this.selectedColor].setShadow(true);
        }
        super.keyPressed(eventCharacter, eventKey, mx, my);
    }

    @Override
    public int getWidth() {
        return 24;
    }

    @Override
    public int getHeight() {
        return 16;
    }

    @Override
    public Byte getPixelValue(int x, int y) {
        if (x < 0 || x >= 24) {
            return (byte)0;
        }
        if (y < 0 || y >= 16) {
            return (byte)0;
        }
        return this.flagEntity.flagColors[x + 24 * y];
    }

    @Override
    public boolean setPixelValue(int x, int y, Byte value) {
        if (x < 0 || x >= 24) {
            return false;
        }
        if (y < 0 || y >= 16) {
            return false;
        }
        this.flagEntity.flagColors[x + 24 * y] = value;
        this.flagEntity.isDirty = true;
        return true;
    }
}

