/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.guidebook.crafting.displays;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.gui.guidebook.GuidebookSlot;
import net.minecraft.client.gui.guidebook.crafting.displays.LabelDisplayAdapter;
import net.minecraft.client.gui.guidebook.crafting.displays.RecipeDisplayAdapter;
import net.minecraft.core.data.registry.recipe.RecipeEntryBase;
import net.minecraft.core.data.registry.recipe.RecipeSymbol;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryLabelDye;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;

public class LabelDyeDisplayAdapter
implements RecipeDisplayAdapter<RecipeEntryLabelDye> {
    @Override
    public List<GuidebookSlot> getSlots(RecipeEntryLabelDye recipe, int recipeAmount, int xOffset, int yOffset) {
        ArrayList<GuidebookSlot> recipeSlots = new ArrayList<GuidebookSlot>();
        ItemStack[] sharedBuffer = new ItemStack[2];
        RecipeSymbol[] symbols = new RecipeSymbol[]{new RecipeSymbol(Items.LABEL.getDefaultStack()), new RecipeSymbol(Items.DYE.getDefaultStack()), null, null, new RecipeSymbol(Items.LABEL.getDefaultStack())};
        for (int i = 0; i < 4; ++i) {
            int x = 13 + 18 * (i % 2) + xOffset;
            int y = 10 + 18 * (i / 2 + recipeAmount * 3) + yOffset;
            GuidebookSlot slot = i == 0 ? new LabelGuidebookSlot(i, x, y, symbols[i], false, recipe, sharedBuffer) : (i == 1 ? new DyeGuidebookSlot(i, x, y, symbols[i], false, recipe, sharedBuffer) : new GuidebookSlot(i, x, y, symbols[i], false, recipe));
            recipeSlots.add(slot);
        }
        int centerY = (((GuidebookSlot)recipeSlots.get((int)(recipeSlots.size() - 1))).y + ((GuidebookSlot)recipeSlots.get((int)(recipeSlots.size() - 3))).y) / 2;
        recipeSlots.add(new NamedOutputGuidebookSlot(symbols.length - 1, 81 + xOffset, centerY, symbols[4], false, recipe, sharedBuffer).setAsOutput());
        return recipeSlots;
    }

    public static class LabelGuidebookSlot
    extends GuidebookSlot {
        private final ItemStack[] itemBuffer;

        public LabelGuidebookSlot(int id, int x, int y, RecipeSymbol symbol, boolean discovered, RecipeEntryBase<?, ?, ?> recipe, ItemStack[] itemBuffer) {
            super(id, x, y, symbol, discovered, recipe);
            this.itemBuffer = itemBuffer;
        }

        @Override
        public void showRandomItem() {
            Random r = new Random();
            this.itemBuffer[0] = this.item = new ItemStack(Items.LABEL);
            this.item.setCustomName(LabelDisplayAdapter.randomNames[r.nextInt(LabelDisplayAdapter.randomNames.length)]);
        }
    }

    public static class DyeGuidebookSlot
    extends GuidebookSlot {
        private final ItemStack[] itemBuffer;

        public DyeGuidebookSlot(int id, int x, int y, RecipeSymbol symbol, boolean discovered, RecipeEntryBase<?, ?, ?> recipe, ItemStack[] itemBuffer) {
            super(id, x, y, symbol, discovered, recipe);
            this.itemBuffer = itemBuffer;
        }

        @Override
        public void showRandomItem() {
            Random r = new Random();
            this.itemBuffer[1] = this.item = new ItemStack(Items.DYE, 1, r.nextInt(16));
        }
    }

    public static class NamedOutputGuidebookSlot
    extends GuidebookSlot {
        private final ItemStack[] itemBuffer;

        public NamedOutputGuidebookSlot(int id, int x, int y, RecipeSymbol symbol, boolean discovered, RecipeEntryBase<?, ?, ?> recipe, ItemStack[] itemBuffer) {
            super(id, x, y, symbol, discovered, recipe);
            this.itemBuffer = itemBuffer;
        }

        @Override
        public void showRandomItem() {
            this.item = new ItemStack(this.itemBuffer[0]);
            this.item.setCustomName(this.itemBuffer[0].getCustomName());
            this.item.setCustomColor((byte)(15 - this.itemBuffer[1].getMetadata()));
        }
    }
}

