/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.guidebook.search;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.TextFieldElement;
import net.minecraft.client.gui.guidebook.GuidebookPage;
import net.minecraft.client.gui.guidebook.GuidebookScreen;
import net.minecraft.client.gui.guidebook.GuidebookSection;
import net.minecraft.client.gui.guidebook.PageManager;
import net.minecraft.client.gui.guidebook.RecipePage;
import net.minecraft.client.render.Font;
import net.minecraft.client.render.TextureManager;
import net.minecraft.core.data.registry.recipe.SearchQuery;
import net.minecraft.core.lang.I18n;

public class SearchPage
extends GuidebookPage {
    public static final TextFieldElement searchField = new TextFieldElement(null, Minecraft.getMinecraft(SearchPage.class).font, 0, 0, 120, 20, "", "Search...");
    public final ButtonElement searchClearButton = new ButtonElement(0, 0, 0, 20, 20, "X");
    private final Minecraft mc = Minecraft.getMinecraft(SearchPage.class);

    public SearchPage(GuidebookSection section) {
        super(section);
    }

    @Override
    protected void renderForeground(TextureManager re, Font fr, int x, int y, int mouseX, int mouseY, float partialTicks) {
        SearchPage.searchField.xPosition = x + 79 - SearchPage.searchField.width / 2 - 10;
        SearchPage.searchField.yPosition = y + 110 - SearchPage.searchField.height / 2 - 70;
        this.searchClearButton.xPosition = SearchPage.searchField.xPosition + SearchPage.searchField.width + 5;
        this.searchClearButton.yPosition = SearchPage.searchField.yPosition;
        searchField.drawTextBox();
        this.searchClearButton.drawButton(this.mc, mouseX, mouseY);
        int results = 0;
        for (GuidebookPage page : GuidebookScreen.getPageManager().getPages()) {
            if (!(page instanceof RecipePage)) continue;
            results += ((RecipePage)page).recipes.size();
        }
        I18n tr = I18n.getInstance();
        this.drawStringCenteredNoShadow(fr, tr.translateKeyAndFormat("guidebook.section.search.result.found", results), x + 79, y + 10, -12566464);
        int offset = y + 70;
        this.drawStringCenteredNoShadow(fr, tr.translateKey("guidebook.section.search.info.modifiers.title"), x + 79, offset, -12566464);
        this.drawStringNoShadow(fr, tr.translateKey("guidebook.section.search.info.modifiers.1"), x + 10, offset += 15, -12566464);
        this.drawStringNoShadow(fr, tr.translateKey("guidebook.section.search.info.modifiers.2"), x + 10, offset += 10, -12566464);
        this.drawStringNoShadow(fr, tr.translateKey("guidebook.section.search.info.modifiers.3"), x + 10, offset += 10, -12566464);
        this.drawStringNoShadow(fr, tr.translateKey("guidebook.section.search.info.modifiers.4"), x + 10, offset += 10, -12566464);
        this.drawStringNoShadow(fr, tr.translateKey("guidebook.section.search.info.modifiers.5"), x + 10, offset += 10, -12566464);
        this.drawStringNoShadow(fr, tr.translateKey("guidebook.section.search.info.modifiers.6"), x + 10, offset += 10, -12566464);
        this.drawStringNoShadow(fr, tr.translateKey("guidebook.section.search.info.modifiers.7"), x + 10, offset += 10, -12566464);
        this.drawStringNoShadow(fr, tr.translateKey("guidebook.section.search.info.modifiers.8"), x + 10, offset += 10, -12566464);
        this.drawStringNoShadow(fr, tr.translateKey("guidebook.section.search.info.modifiers.9"), x + 10, offset += 15, -12566464);
    }

    @Override
    public void onTick() {
        super.onTick();
        if (SearchPage.searchField.isFocused) {
            searchField.updateCursorCounter();
        }
    }

    @Override
    public void onStopBeingVisible() {
        super.onStopBeingVisible();
        searchField.setFocused(false);
    }

    @Override
    public void onMouseDown(int x, int y, int mouseX, int mouseY, int button) {
        super.onMouseDown(x, y, mouseX, mouseY, button);
        searchField.mouseClicked(mouseX, mouseY, button);
        if (SearchPage.searchField.isFocused) {
            PageManager.searchQuery = SearchQuery.resolve(searchField.getText());
            GuidebookScreen.getPageManager().updatePages();
        }
        if (this.searchClearButton.mouseClicked(this.mc, mouseX, mouseY)) {
            searchField.setText("");
            PageManager.searchQuery = SearchQuery.resolve(searchField.getText());
            GuidebookScreen.getPageManager().updatePages();
        }
    }

    @Override
    public boolean keyTyped(char c, int key, int x, int y, int mouseX, int mouseY) {
        if (SearchPage.searchField.isFocused) {
            searchField.textboxKeyTyped(c, key);
            PageManager.searchQuery = SearchQuery.resolve(searchField.getText());
            GuidebookScreen.getPageManager().updatePages();
            return true;
        }
        return false;
    }
}

