/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.hud.component;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.hud.IngameHud;
import net.minecraft.client.gui.hud.component.MovableHudComponent;
import net.minecraft.client.gui.hud.component.layout.Layout;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import org.lwjgl.opengl.GL11;

public class ArmorBarComponent
extends MovableHudComponent {
    private final IconCoordinate armor_empty = TextureRegistry.getTexture("minecraft:gui/hud/armor_empty");
    private final IconCoordinate armor_half = TextureRegistry.getTexture("minecraft:gui/hud/armor_half");
    private final IconCoordinate armor_full = TextureRegistry.getTexture("minecraft:gui/hud/armor_full");

    public ArmorBarComponent(String key, Layout layout) {
        super(key, 81, 10, layout);
    }

    @Override
    public boolean isVisible(Minecraft mc) {
        return mc.playerController.canHurtPlayer() && mc.gameSettings.immersiveMode.drawHotbar() && mc.thePlayer.getPlayerProtectionAmount() > 0;
    }

    @Override
    public void render(Minecraft mc, IngameHud hud, int xSizeScreen, int ySizeScreen, float partialTick) {
        int x = this.getLayout().getComponentX(mc, this, xSizeScreen);
        int y = this.getLayout().getComponentY(mc, this, ySizeScreen);
        GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        GL11.glDisable(3042);
        int armorValue = mc.thePlayer.getPlayerProtectionAmount();
        for (int i = 0; i < 10; ++i) {
            if (armorValue <= 0) continue;
            int xArmor = x + this.getXSize(mc) - i * 8 - 9;
            if (i * 2 + 1 < armorValue) {
                hud.drawGuiIcon(xArmor, y, 9, 9, this.armor_full);
            }
            if (i * 2 + 1 == armorValue) {
                hud.drawGuiIcon(xArmor, y, 9, 9, this.armor_half);
            }
            if (i * 2 + 1 <= armorValue) continue;
            hud.drawGuiIcon(xArmor, y, 9, 9, this.armor_empty);
        }
    }

    @Override
    public void renderPreview(Minecraft mc, Gui gui, Layout layout, int xSizeScreen, int ySizeScreen) {
        int x = layout.getComponentX(mc, this, xSizeScreen);
        int y = layout.getComponentY(mc, this, ySizeScreen);
        GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        GL11.glDisable(3042);
        int armorValue = 11;
        for (int i = 0; i < 10; ++i) {
            int xArmor = x + this.getXSize(mc) - i * 8 - 9;
            if (i * 2 + 1 < armorValue) {
                gui.drawGuiIcon(xArmor, y, 9, 9, this.armor_full);
            }
            if (i * 2 + 1 == armorValue) {
                gui.drawGuiIcon(xArmor, y, 9, 9, this.armor_half);
            }
            if (i * 2 + 1 <= armorValue) continue;
            gui.drawGuiIcon(xArmor, y, 9, 9, this.armor_empty);
        }
    }
}

