/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.popup;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.popup.PopupComponent;
import net.minecraft.core.sound.SoundCategory;

public class ButtonGroupComponent
extends PopupComponent {
    private static final int BUTTON_GAP = 2;
    private final Minecraft minecraft = Minecraft.getMinecraft(this);
    private final ButtonElement[] buttons;

    public ButtonGroupComponent(int width, String[] buttonLabels, int[] buttonStatusCodes, boolean[] enabled) {
        super(width);
        this.buttons = new ButtonElement[buttonLabels.length];
        int numButtons = this.buttons.length;
        int buttonWidth = (width - 2 * (numButtons - 1)) / numButtons;
        if (numButtons == 1) {
            buttonWidth = width;
        }
        buttonWidth = Math.min(buttonWidth, 256);
        for (int i = 0; i < numButtons; ++i) {
            this.buttons[i] = new ButtonElement(buttonStatusCodes[i], 0, 0, buttonWidth, this.getHeight(), buttonLabels[i]);
            this.buttons[i].enabled = enabled[i];
        }
    }

    @Override
    public int getHeight() {
        return 20;
    }

    @Override
    public void render(int x, int y, int mouseX, int mouseY) {
        for (int i = 0; i < this.buttons.length; ++i) {
            ButtonElement button = this.buttons[i];
            button.xPosition = x + (button.width + 2) * i;
            button.yPosition = y;
            button.drawButton(this.minecraft, mouseX, mouseY);
        }
    }

    @Override
    public void onClick(int x, int y, int button) {
        for (ButtonElement b : this.buttons) {
            if (!b.mouseClicked(this.minecraft, x, y)) continue;
            this.getParent().close(b.id);
            this.minecraft.sndManager.playSound("random.click", SoundCategory.GUI_SOUNDS, 1.0f, 1.0f);
            return;
        }
    }
}

