/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.text;

import com.mojang.logging.LogUtils;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import net.minecraft.client.gui.text.ITextField;
import net.minecraft.core.util.helper.MathHelper;
import org.lwjgl.input.Keyboard;
import org.slf4j.Logger;

public class TextFieldEditor {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final ITextField textField;
    private int cursor;

    public static String substring(String s, int start, int end) {
        if (start < 0) {
            start = 0;
        }
        if (end > s.length()) {
            end = s.length();
        }
        if (start > end) {
            return "";
        }
        return s.substring(start, end);
    }

    public static String substring(String s, int start) {
        return TextFieldEditor.substring(s, start, s.length());
    }

    public TextFieldEditor(ITextField textField) {
        this.textField = textField;
        this.cursor = textField.getText().length();
    }

    public int getCursor() {
        if (this.cursor < 0) {
            this.setCursor(0);
        }
        if (this.cursor > this.textField.getText().length()) {
            this.setCursor(this.textField.getText().length());
        }
        return this.cursor;
    }

    public String getText() {
        return this.textField.getText();
    }

    public void setText(String s) {
        if (s.length() > this.textField.maxLength()) {
            s = TextFieldEditor.substring(s, 0, this.textField.maxLength());
        }
        this.textField.setText(s);
    }

    public boolean handleInput(int key, char c) {
        if (Keyboard.isKeyDown(Keyboard.KEY_LCONTROL) || Keyboard.isKeyDown(Keyboard.KEY_RCONTROL)) {
            if (key == Keyboard.KEY_C) {
                this.stringToClipboard(this.getText());
                return false;
            }
            if (key == Keyboard.KEY_V) {
                String pasteString = this.clipboardToString();
                if (pasteString != null) {
                    this.addStringAtCursor(pasteString);
                }
                return true;
            }
            if (key == Keyboard.KEY_LEFT) {
                this.setCursor(this.findNextAnchor(-1));
                return false;
            }
            if (key == Keyboard.KEY_RIGHT) {
                this.setCursor(this.findNextAnchor(1));
                return false;
            }
            if (key == Keyboard.KEY_BACK) {
                int next = this.findNextAnchor(-1);
                int d = this.cursor - next;
                this.deleteCharsBeforeCursor(d);
                return true;
            }
            if (key == Keyboard.KEY_DELETE) {
                int next = this.findNextAnchor(1);
                int d = next - this.cursor;
                this.deleteCharsAfterCursor(d);
                return true;
            }
        }
        if (key == Keyboard.KEY_HOME) {
            this.setCursor(0);
            return false;
        }
        if (key == Keyboard.KEY_END) {
            this.setCursor(this.getText().length());
            return false;
        }
        if (key == Keyboard.KEY_LEFT) {
            this.moveCursor(-1);
            return false;
        }
        if (key == Keyboard.KEY_RIGHT) {
            this.moveCursor(1);
            return false;
        }
        if (key == Keyboard.KEY_BACK) {
            this.deleteCharsBeforeCursor(1);
            return true;
        }
        if (key == Keyboard.KEY_DELETE) {
            this.deleteCharsAfterCursor(1);
            return true;
        }
        this.addCharAtCursor(c);
        return true;
    }

    public void moveCursor(int i) {
        this.setCursor(this.cursor + i);
    }

    public void setCursor(int i) {
        if (i <= 0) {
            i = 0;
        }
        if (i > this.getText().length()) {
            i = this.getText().length();
        }
        this.cursor = i;
    }

    public void addCharAtCursor(char c) {
        String currentText = this.getText();
        int remaining = this.textField.maxLength() - currentText.length();
        if (remaining == 0) {
            return;
        }
        if (!this.textField.isCharacterAllowed(c)) {
            return;
        }
        if (this.cursor > currentText.length()) {
            this.setCursor(currentText.length());
        }
        if (this.cursor < 0) {
            this.setCursor(0);
        }
        if (currentText.isEmpty()) {
            this.setText(String.valueOf(c));
        } else if (this.cursor == currentText.length()) {
            this.setText(currentText + c);
        } else {
            String before = TextFieldEditor.substring(currentText, 0, this.cursor);
            String after = TextFieldEditor.substring(currentText, this.cursor);
            this.setText(before + c + after);
        }
        ++this.cursor;
    }

    public void addStringAtCursor(String s) {
        for (char c : s.toCharArray()) {
            this.addCharAtCursor(c);
        }
    }

    public void deleteCharsBeforeCursor(int i) {
        if (this.cursor < 0) {
            this.cursor = 0;
        }
        String before = i > this.cursor ? "" : TextFieldEditor.substring(this.getText(), 0, this.cursor - i);
        String after = TextFieldEditor.substring(this.getText(), this.cursor);
        this.setText(before + after);
        if (!after.isEmpty()) {
            this.setCursor(before.length());
        }
    }

    public void deleteCharsAfterCursor(int i) {
        if (this.cursor == this.getText().length()) {
            return;
        }
        String after = this.cursor + i > this.getText().length() ? "" : TextFieldEditor.substring(this.getText(), this.cursor + i);
        String before = TextFieldEditor.substring(this.getText(), 0, this.cursor);
        this.setText(before + after);
    }

    public int findNextAnchor(int direction) {
        if ((direction = MathHelper.clamp(direction, -1, 1)) == 0) {
            return this.cursor;
        }
        String text = this.getText();
        for (int i = this.cursor + direction; i > 0 && i < text.length(); i += direction) {
            if (text.charAt(i) == ' ' || !Character.isWhitespace(text.charAt(i - 1))) continue;
            return i;
        }
        return direction > 0 ? text.length() : 0;
    }

    private void stringToClipboard(String string) {
        try {
            StringSelection selection = new StringSelection(string);
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(selection, selection);
        }
        catch (Exception e) {
            LOGGER.error("Exception while trying to copy text field to clipboard!", e);
        }
    }

    private String clipboardToString() {
        try {
            Transferable trans = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
            if (trans != null && trans.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                return (String)trans.getTransferData(DataFlavor.stringFlavor);
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception while trying to read clipboard!", e);
        }
        return null;
    }
}

