/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.toasts;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.toasts.IToastable;
import net.minecraft.client.render.Lighting;
import net.minecraft.client.render.Scissor;
import net.minecraft.client.render.item.model.ItemModelDispatcher;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.Global;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.lang.I18n;
import org.lwjgl.opengl.GL11;

public class HudToastsElement
extends Gui {
    private static final int TOAST_WIDTH = 160;
    private static final int TOAST_HEIGHT = 32;
    private static final int MAX_SHOWN_ENTRIES = 5;
    private final List<IToastable> overflowEntries = new ArrayList<IToastable>();
    private final List<ToastEntry> activeEntries = new ArrayList<ToastEntry>();
    private final Minecraft mc;

    public HudToastsElement(Minecraft minecraft) {
        this.mc = minecraft;
    }

    public boolean isDisplayingToast(IToastable toast) {
        for (ToastEntry entry : this.activeEntries) {
            if (!entry.toast.isEquivalentToast(toast)) continue;
            return true;
        }
        return false;
    }

    public void addToast(IToastable toast) {
        if (this.activeEntries.size() >= 5) {
            this.overflowEntries.add(toast);
            return;
        }
        this.activeEntries.add(new ToastEntry(toast, System.currentTimeMillis()));
        toast.onToastStart();
        this.sortList();
    }

    public void endToast(IToastable toast) {
        for (int i = 0; i < this.activeEntries.size(); ++i) {
            ToastEntry entry = this.activeEntries.get(i);
            if (!entry.toast.isEquivalentToast(toast)) continue;
            this.activeEntries.remove(i);
            entry.toast.onToastEnd();
            this.sortList();
            return;
        }
    }

    protected void sortList() {
        this.activeEntries.sort(ToastEntry.TOAST_SORTER);
    }

    private void updateScale() {
        GL11.glViewport(0, 0, this.mc.gameWindow.getWidthPixels(), this.mc.gameWindow.getHeightPixels());
        GL11.glMatrixMode(5889);
        GL11.glLoadIdentity();
        GL11.glMatrixMode(5888);
        GL11.glLoadIdentity();
        GL11.glClear(256);
        GL11.glMatrixMode(5889);
        GL11.glLoadIdentity();
        GL11.glOrtho(0.0, this.mc.resolution.getExactScaledWidthScreenCoords(), this.mc.resolution.getExactScaledHeightScreenCoords(), 0.0, 1000.0, 3000.0);
        GL11.glMatrixMode(5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef(0.0f, 0.0f, -2000.0f);
    }

    public void render(float partialTick) {
        if (Minecraft.hasPaidCheckTime > 0L) {
            GL11.glDisable(2929);
            GL11.glDepthMask(false);
            Lighting.disable();
            String s = I18n.getInstance().translateKeyAndFormat("gui.achievement.label.unlicensed.1", Global.VERSION);
            String s1 = I18n.getInstance().translateKey("gui.achievement.label.unlicensed.2");
            String s2 = I18n.getInstance().translateKey("gui.achievement.label.unlicensed.3");
            this.mc.font.drawStringWithShadow(s, 2, 2, 0xFFFFFF);
            this.mc.font.drawStringWithShadow(s1, 2, 11, 0xFFFFFF);
            this.mc.font.drawStringWithShadow(s2, 2, 20, 0xFFFFFF);
            GL11.glDepthMask(true);
            GL11.glEnable(2929);
        }
        if (!this.overflowEntries.isEmpty()) {
            while (this.activeEntries.size() < 5 && !this.overflowEntries.isEmpty()) {
                IToastable toast = this.overflowEntries.get(0);
                this.overflowEntries.remove(0);
                this.activeEntries.add(new ToastEntry(toast, System.currentTimeMillis() + 1L));
                toast.onToastStart();
                this.sortList();
            }
        }
        ArrayList<ToastEntry> entriesCopy = new ArrayList<ToastEntry>(this.activeEntries);
        for (ToastEntry entry : entriesCopy) {
            long duration = System.currentTimeMillis() - entry.startTime;
            double animProgress = entry.toast.getAnimationProgress(duration);
            if (!(animProgress < 0.0) && !(animProgress > 1.0)) continue;
            this.endToast(entry.toast);
        }
        if (this.activeEntries.isEmpty() || this.mc.thePlayer == null) {
            return;
        }
        this.updateScale();
        GL11.glDisable(2929);
        GL11.glDepthMask(false);
        int yOff = 0;
        for (ToastEntry entry : this.activeEntries) {
            long duration = System.currentTimeMillis() - entry.startTime;
            double animProgress = entry.toast.getAnimationProgress(duration);
            double hideAmount = animProgress * 2.0;
            if (hideAmount > 1.0) {
                hideAmount = 2.0 - hideAmount;
            }
            hideAmount *= 4.0;
            if ((hideAmount = 1.0 - hideAmount) < 0.0) {
                hideAmount = 0.0;
            }
            hideAmount *= hideAmount;
            hideAmount *= hideAmount;
            int toastLeft = this.mc.resolution.getScaledWidthScreenCoords() - 160;
            int toastTop = (int)(-hideAmount * 32.0);
            if (toastTop < 0) {
                Scissor.enable(toastLeft, yOff, 160, 32);
            }
            this.renderToast(entry.toast, duration, toastLeft, toastTop + yOff);
            Scissor.disable();
            yOff += 32 + toastTop;
        }
        GL11.glDisable(32826);
        Lighting.disable();
        GL11.glDisable(2896);
        GL11.glDisable(2929);
    }

    protected void renderToast(IToastable toast, long duration, int x, int y) {
        GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        GL11.glEnable(3553);
        GL11.glDisable(2896);
        this.drawGuiIcon(x, y, 160, 32, TextureRegistry.getTexture(toast.getTexture(duration)));
        if (toast.messageOnly(duration)) {
            this.mc.font.drawStringIntoConstrainedBlock(toast.getMessage(duration), x + 30, y + 7, 120, toast.descriptionColor(duration));
        } else {
            this.mc.font.drawString(toast.getTitle(duration), x + 30, y + 7, toast.nameColor(duration));
            this.mc.font.drawString(toast.getMessage(duration), x + 30, y + 18, toast.descriptionColor(duration));
        }
        GL11.glDepthMask(true);
        Lighting.enableInventoryLight();
        GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        GL11.glEnable(32826);
        GL11.glEnable(2929);
        ItemStack icon = toast.getIcon(duration);
        ItemModelDispatcher.getInstance().getDispatch(icon).renderItemIntoGui(Tessellator.instance, this.mc.font, this.mc.textureManager, icon, x + 8, y + 8, 1.0f);
        GL11.glDisable(2929);
    }

    static class ToastEntry {
        public static final Comparator<ToastEntry> TOAST_SORTER = (o1, o2) -> (int)(o1.startTime - o2.startTime);
        public final long startTime;
        public final IToastable toast;

        public ToastEntry(IToastable toast, long startTime) {
            this.toast = toast;
            this.startTime = startTime;
        }
    }
}

