/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.text.Bidi;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.lang.text.Text;
import net.minecraft.client.option.GameSettings;
import net.minecraft.client.render.TextureManager;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.Texture;
import net.minecraft.client.util.helper.Colors;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.util.helper.ChatAllowedCharacters;
import net.minecraft.core.util.helper.Color;
import org.lwjgl.opengl.GL11;

public class Font {
    private static final Pattern FORMATTING_CODE_REGEX = Pattern.compile("(?i)\\u00A7[0-9A-FK-OR]");
    private final GameSettings gameSettings;
    private final Minecraft mc;
    private final byte[] charWidth;
    public int fontTextureName;
    private final int[] fontTextureNames;
    public int fontHeight;
    public Random random;
    private final byte[] glyphWidth;
    private final int[] glyphTextureNames;
    private final int[] colorCode;
    private int boundTextureName;
    private final TextureManager textureManager;
    private float posX;
    private float posY;
    private boolean bidiFlag;
    private float red;
    private float blue;
    private float green;
    private float alpha;
    private int textColor;
    private boolean obfuscatedStyle;
    private boolean boldStyle;
    private boolean italicStyle;
    private boolean underlineStyle;
    private boolean strikethroughStyle;
    private static final List<Character> DEFAULT_BLACKLIST = Arrays.asList(Character.valueOf('\uff0c'), Character.valueOf('\u3002'), Character.valueOf('\u3001'), Character.valueOf('\u3010'), Character.valueOf('\u3011'), Character.valueOf('\uff1b'), Character.valueOf('\u2019'), Character.valueOf('\u2018'), Character.valueOf('\u201c'), Character.valueOf('\u201d'), Character.valueOf('\uff1f'), Character.valueOf('\uff01'), Character.valueOf('\u00b7'));

    public Font(Minecraft minecraft, GameSettings gameSettings, TextureManager textureManager) {
        this.mc = minecraft;
        this.gameSettings = gameSettings;
        this.charWidth = new byte[65536];
        this.fontTextureName = 0;
        this.fontTextureNames = new int[256];
        this.fontHeight = 9;
        this.random = new Random();
        this.glyphWidth = new byte[65536];
        this.glyphTextureNames = new int[256];
        this.colorCode = new int[32];
        this.obfuscatedStyle = false;
        this.boldStyle = false;
        this.italicStyle = false;
        this.underlineStyle = false;
        this.strikethroughStyle = false;
        this.textureManager = textureManager;
        try (InputStream glyphStream = this.mc.texturePackList.getResourceAsStream("/font/glyph_sizes.bin");
             InputStream glyphStreamDefault = this.mc.texturePackList.getResourceAsStream("/font/glyph_sizes_default.bin");){
            glyphStream.read(this.glyphWidth);
            glyphStreamDefault.read(this.charWidth);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (int i = 0; i < 32; ++i) {
            Color color = Colors.allChatColors[i & 0xF];
            int r = color.getRed();
            int g = color.getGreen();
            int b = color.getBlue();
            if (i >= 16) {
                r /= 4;
                g /= 4;
                b /= 4;
            }
            this.colorCode[i] = (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
        }
    }

    private float renderCharAtPos(int formatCode, char c, boolean italic) {
        float charWidth = 0.0f;
        charWidth = c == ' ' ? 4.0f : (DEFAULT_BLACKLIST.contains(Character.valueOf(c)) ? this.renderUnicodeChar(c, italic) : (formatCode > 0 && (Boolean)this.gameSettings.forceUnicodeFont.value == false ? this.renderDefaultChar((char)formatCode, italic) : this.renderUnicodeChar(c, italic)));
        return charWidth;
    }

    private boolean loadDefaultTexture(int id) {
        boolean success = true;
        String fontPath = String.format("/font/font_%02X.png", id);
        String glyphPath = String.format("/font/glyph_%02X.png", id);
        Texture fontTexture = this.textureManager.loadTextureNoDefault(fontPath);
        if (fontTexture == null) {
            fontTexture = this.textureManager.loadTextureNoDefault(glyphPath);
        }
        if (fontTexture == null) {
            throw new RuntimeException("Failed to load texture from '" + fontPath + "' or '" + glyphPath + "'!");
        }
        this.fontTextureNames[id] = fontTexture.id();
        this.boundTextureName = this.fontTextureNames[id];
        return success;
    }

    private float renderDefaultChar(char c, boolean italic) {
        if (this.charWidth[c] == 0 && this.glyphWidth[c] == 0) {
            return 0.0f;
        }
        int charWrapped = c / 256;
        boolean isFontImage = true;
        if (this.fontTextureNames[charWrapped] == 0) {
            isFontImage = this.loadDefaultTexture(charWrapped);
        }
        if (isFontImage) {
            if (this.boundTextureName != this.fontTextureNames[charWrapped]) {
                GL11.glBindTexture(3553, this.fontTextureNames[charWrapped]);
                this.boundTextureName = this.fontTextureNames[charWrapped];
            }
        } else if (this.boundTextureName != this.glyphTextureNames[charWrapped]) {
            GL11.glBindTexture(3553, this.glyphTextureNames[charWrapped]);
            this.boundTextureName = this.glyphTextureNames[charWrapped];
        }
        int upper = isFontImage ? this.charWidth[c] >> 4 : this.glyphWidth[c] >> 4;
        int lower = isFontImage ? this.charWidth[c] & 0xF : this.glyphWidth[c] & 0xF;
        float fUpper = upper;
        float fLower = lower + 1;
        float x = (float)(c % 16 * 16) + fUpper;
        float y = (c & 0xFF) / 16 * 16;
        float var10 = fLower - fUpper - 0.02f;
        float italicOffset = italic ? 1.0f : 0.0f;
        GL11.glBegin(5);
        GL11.glTexCoord2f(x / 256.0f, y / 256.0f);
        GL11.glVertex3f(this.posX + italicOffset, this.posY, 0.0f);
        GL11.glTexCoord2f(x / 256.0f, (y + 15.98f) / 256.0f);
        GL11.glVertex3f(this.posX - italicOffset, this.posY + 7.99f, 0.0f);
        GL11.glTexCoord2f((x + var10) / 256.0f, y / 256.0f);
        GL11.glVertex3f(this.posX + var10 / 2.0f + italicOffset, this.posY, 0.0f);
        GL11.glTexCoord2f((x + var10) / 256.0f, (y + 15.98f) / 256.0f);
        GL11.glVertex3f(this.posX + var10 / 2.0f - italicOffset, this.posY + 7.99f, 0.0f);
        GL11.glEnd();
        return (fLower - fUpper) / 2.0f + 1.0f;
    }

    private void loadGlyphTexture(int id) {
        BufferedImage glyphTexture;
        String glyphPath = String.format("/font/glyph_%02X.png", id);
        try {
            glyphTexture = ImageIO.read(this.mc.texturePackList.getResourceAsStream(glyphPath));
        }
        catch (IOException var5) {
            throw new RuntimeException(var5);
        }
        this.glyphTextureNames[id] = this.textureManager.loadBufferedTexture(glyphTexture).id();
        this.boundTextureName = this.glyphTextureNames[id];
    }

    private float renderUnicodeChar(char c, boolean par2) {
        if (this.glyphWidth[c] == 0) {
            return 0.0f;
        }
        int charWrapped = c / 256;
        if (this.glyphTextureNames[charWrapped] == 0) {
            this.loadGlyphTexture(charWrapped);
        }
        if (this.boundTextureName != this.glyphTextureNames[charWrapped]) {
            GL11.glBindTexture(3553, this.glyphTextureNames[charWrapped]);
            this.boundTextureName = this.glyphTextureNames[charWrapped];
        }
        int var4 = this.glyphWidth[c] >>> 4;
        int var5 = this.glyphWidth[c] & 0xF;
        float var6 = var4;
        float var7 = var5 + 1;
        float var8 = (float)(c % 16 * 16) + var6;
        float var9 = (c & 0xFF) / 16 * 16;
        float var10 = var7 - var6 - 0.02f;
        float var11 = par2 ? 1.0f : 0.0f;
        GL11.glBegin(5);
        GL11.glTexCoord2f(var8 / 256.0f, var9 / 256.0f);
        GL11.glVertex3f(this.posX + var11, this.posY, 0.0f);
        GL11.glTexCoord2f(var8 / 256.0f, (var9 + 15.98f) / 256.0f);
        GL11.glVertex3f(this.posX - var11, this.posY + 7.99f, 0.0f);
        GL11.glTexCoord2f((var8 + var10) / 256.0f, var9 / 256.0f);
        GL11.glVertex3f(this.posX + var10 / 2.0f + var11, this.posY, 0.0f);
        GL11.glTexCoord2f((var8 + var10) / 256.0f, (var9 + 15.98f) / 256.0f);
        GL11.glVertex3f(this.posX + var10 / 2.0f - var11, this.posY + 7.99f, 0.0f);
        GL11.glEnd();
        return (var7 - var6) / 2.0f + 1.0f;
    }

    public void drawTextWithShadow(Text text, int x, int y, int color) {
        this.drawText(text, x, y, color, true);
    }

    public void drawText(Text text, int x, int y, int color) {
        this.drawText(text, x, y, color, false);
    }

    public int drawText(Text text, int x, int y, int color, boolean shadow) {
        return this.drawString(text.toString(), x, y, color, shadow);
    }

    public void drawStringWithShadow(String text, int x, int y, int color) {
        this.drawString(text, x, y, color, true);
    }

    public void drawString(String text, int x, int y, int color) {
        this.drawString(text, x, y, color, false);
    }

    public int drawString(String text, int x, int y, int color, boolean shadow) {
        int var6;
        if (text != null) {
            StringBuilder sb = new StringBuilder();
            boolean modified = false;
            block4: for (char c : text.toCharArray()) {
                switch (c) {
                    case '\uff08': {
                        sb.append(" (");
                        modified = true;
                        continue block4;
                    }
                    case '\uff09': {
                        sb.append(") ");
                        modified = true;
                        continue block4;
                    }
                    default: {
                        sb.append(c);
                    }
                }
            }
            if (modified) {
                text = sb.toString();
            }
        }
        this.resetStyles();
        if (this.bidiFlag) {
            text = this.bidiReorder(text);
        }
        if (shadow) {
            var6 = this.renderStringInternal(text, x + 1, y + 1, color, true);
            var6 = Math.max(var6, this.renderStringInternal(text, x, y, color, false));
        } else {
            var6 = this.renderStringInternal(text, x, y, color, false);
        }
        return var6;
    }

    private String bidiReorder(String par1Str) {
        if (par1Str != null && Bidi.requiresBidi(par1Str.toCharArray(), 0, par1Str.length())) {
            int var7;
            Bidi var2 = new Bidi(par1Str, -2);
            byte[] var3 = new byte[var2.getRunCount()];
            Object[] var4 = new String[var3.length];
            for (int var11 = 0; var11 < var3.length; ++var11) {
                int var12 = var2.getRunStart(var11);
                var7 = var2.getRunLimit(var11);
                int var13 = var2.getRunLevel(var11);
                String var14 = par1Str.substring(var12, var7);
                var3[var11] = (byte)var13;
                var4[var11] = var14;
            }
            String[] var111 = (String[])var4.clone();
            Bidi.reorderVisually(var3, 0, var4, 0, var3.length);
            StringBuilder var121 = new StringBuilder();
            for (var7 = 0; var7 < var4.length; ++var7) {
                int var141;
                byte var131 = var3[var7];
                for (var141 = 0; var141 < var111.length; ++var141) {
                    if (!var111[var141].equals(var4[var7])) {
                        continue;
                    }
                    var131 = var3[var141];
                    break;
                }
                if ((var131 & 1) == 0) {
                    var121.append((String)var4[var7]);
                    continue;
                }
                for (var141 = ((String)var4[var7]).length() - 1; var141 >= 0; --var141) {
                    char var10 = ((String)var4[var7]).charAt(var141);
                    if (var10 == '(') {
                        var10 = ')';
                    } else if (var10 == ')') {
                        var10 = '(';
                    }
                    var121.append(var10);
                }
            }
            return var121.toString();
        }
        return par1Str;
    }

    private void resetStyles() {
        this.obfuscatedStyle = false;
        this.boldStyle = false;
        this.italicStyle = false;
        this.underlineStyle = false;
        this.strikethroughStyle = false;
    }

    private void renderStringAtPos(String text, boolean flag) {
        for (int i = 0; i < text.length(); ++i) {
            int var6;
            int fontIndex;
            char c = text.charAt(i);
            if (c == '\u00a7' && i + 1 < text.length()) {
                char colorSymbol = text.toLowerCase().charAt(i + 1);
                if (colorSymbol == '<') {
                    int offAmount = 1;
                    StringBuilder colorValue = new StringBuilder();
                    boolean ended = false;
                    for (int j = i + 2; j < text.length(); ++j) {
                        ++offAmount;
                        if (text.charAt(j) == '>') {
                            ended = true;
                            break;
                        }
                        colorValue.append(text.charAt(j));
                    }
                    if (ended) {
                        i += offAmount;
                        int colorInt = 0xFFFFFF;
                        try {
                            colorInt = Integer.decode("0x" + colorValue.toString().toLowerCase());
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        float r = (float)(colorInt >> 16) / 255.0f;
                        float g = (float)(colorInt >> 8 & 0xFF) / 255.0f;
                        float b = (float)(colorInt & 0xFF) / 255.0f;
                        this.obfuscatedStyle = false;
                        this.boldStyle = false;
                        this.strikethroughStyle = false;
                        this.underlineStyle = false;
                        this.italicStyle = false;
                        if (flag) {
                            r /= 4.0f;
                            g /= 4.0f;
                            b /= 4.0f;
                        }
                        this.textColor = colorInt;
                        GL11.glColor4f(r, g, b, this.alpha);
                        continue;
                    }
                } else {
                    fontIndex = "0123456789abcdefklmnor".indexOf(colorSymbol);
                    if (fontIndex != -1) {
                        if (fontIndex < 16) {
                            this.obfuscatedStyle = false;
                            this.boldStyle = false;
                            this.strikethroughStyle = false;
                            this.underlineStyle = false;
                            this.italicStyle = false;
                            if (fontIndex < 0) {
                                fontIndex = 15;
                            }
                            if (flag) {
                                fontIndex += 16;
                            }
                            this.textColor = var6 = this.colorCode[fontIndex];
                            GL11.glColor4f((float)(var6 >> 16) / 255.0f, (float)(var6 >> 8 & 0xFF) / 255.0f, (float)(var6 & 0xFF) / 255.0f, this.alpha);
                        } else if (fontIndex == 16) {
                            this.obfuscatedStyle = true;
                        } else if (fontIndex == 17) {
                            this.boldStyle = true;
                        } else if (fontIndex == 18) {
                            this.strikethroughStyle = true;
                        } else if (fontIndex == 19) {
                            this.underlineStyle = true;
                        } else if (fontIndex == 20) {
                            this.italicStyle = true;
                        } else if (fontIndex == 21) {
                            this.obfuscatedStyle = false;
                            this.boldStyle = false;
                            this.strikethroughStyle = false;
                            this.underlineStyle = false;
                            this.italicStyle = false;
                            GL11.glColor4f(this.red, this.blue, this.green, this.alpha);
                        }
                        ++i;
                        continue;
                    }
                }
            }
            c = text.charAt(i);
            fontIndex = ChatAllowedCharacters.ALLOWED_CHARACTERS.indexOf(c);
            if (this.obfuscatedStyle && fontIndex > 0) {
                while (this.charWidth[fontIndex + 32] != this.charWidth[(var6 = this.random.nextInt(ChatAllowedCharacters.ALLOWED_CHARACTERS.length())) + 32]) {
                }
                fontIndex = var6;
            }
            float var9 = this.renderCharAtPos(fontIndex, c, this.italicStyle);
            if (this.boldStyle) {
                this.posX += 1.0f;
                this.renderCharAtPos(fontIndex, c, this.italicStyle);
                this.posX -= 1.0f;
                var9 += 1.0f;
            }
            if (this.strikethroughStyle) {
                Tessellator var7 = Tessellator.instance;
                GL11.glDisable(3553);
                var7.startDrawingQuads();
                var7.addVertex(this.posX, this.posY + (float)(this.fontHeight / 2), 0.0);
                var7.addVertex(this.posX + var9, this.posY + (float)(this.fontHeight / 2), 0.0);
                var7.addVertex(this.posX + var9, this.posY + (float)(this.fontHeight / 2) - 1.0f, 0.0);
                var7.addVertex(this.posX, this.posY + (float)(this.fontHeight / 2) - 1.0f, 0.0);
                var7.draw();
                GL11.glEnable(3553);
            }
            if (this.underlineStyle) {
                Tessellator var7 = Tessellator.instance;
                GL11.glDisable(3553);
                var7.startDrawingQuads();
                int var8 = this.underlineStyle ? -1 : 0;
                var7.addVertex(this.posX + (float)var8, this.posY + (float)this.fontHeight, 0.0);
                var7.addVertex(this.posX + var9, this.posY + (float)this.fontHeight, 0.0);
                var7.addVertex(this.posX + var9, this.posY + (float)this.fontHeight - 1.0f, 0.0);
                var7.addVertex(this.posX + (float)var8, this.posY + (float)this.fontHeight - 1.0f, 0.0);
                var7.draw();
                GL11.glEnable(3553);
            }
            this.posX += (float)((int)var9);
        }
    }

    private int renderStringAligned(String s, int x, int y, int maxWidth, int argb, boolean isShadow) {
        if (this.bidiFlag) {
            s = this.bidiReorder(s);
            int width = this.getStringWidth(s);
            x = x + maxWidth - width;
        }
        return this.renderStringInternal(s, x, y, argb, isShadow);
    }

    public void renderString(String par1Str, int par2, int par3, int par4, boolean par5) {
        this.renderStringInternal(par1Str, par2, par3, par4, par5);
    }

    private int renderStringInternal(String text, int x, int y, int color, boolean isShadow) {
        if (text == null) {
            return 0;
        }
        this.boundTextureName = 0;
        if ((color & 0xFF000000) == 0) {
            color |= 0xFF000000;
        }
        if (isShadow) {
            color = (color & 0xFCFCFC) >> 2 | color & 0xFF000000;
        }
        this.red = (float)(color >> 16 & 0xFF) / 255.0f;
        this.blue = (float)(color >> 8 & 0xFF) / 255.0f;
        this.green = (float)(color & 0xFF) / 255.0f;
        this.alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        GL11.glColor4f(this.red, this.blue, this.green, this.alpha);
        this.posX = x;
        this.posY = y;
        this.renderStringAtPos(text, isShadow);
        return (int)this.posX;
    }

    public int getTextWidth(Text text) {
        if (text == null) {
            return 0;
        }
        return this.getStringWidth(text.toString());
    }

    public int getStringWidth(String string) {
        if (string == null) {
            return 0;
        }
        string = TextFormatting.removeAllFormatting(string);
        int stringWidth = 0;
        boolean addSpacerPixel = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            int charWidth = this.getCharWidth(c);
            if (charWidth < 0 && i < string.length() - 1) {
                if ((c = string.charAt(++i)) != 'l' && c != 'L') {
                    if (c == 'r' || c == 'R') {
                        addSpacerPixel = false;
                    }
                } else {
                    addSpacerPixel = true;
                }
                charWidth = 0;
            }
            stringWidth += charWidth;
            if (!addSpacerPixel) continue;
            ++stringWidth;
        }
        return stringWidth;
    }

    public int getCharWidth(char c) {
        if (c == ' ') {
            return 4;
        }
        int fontIndex = ChatAllowedCharacters.ALLOWED_CHARACTERS.indexOf(c);
        if (fontIndex >= 0 && !DEFAULT_BLACKLIST.contains(Character.valueOf(c)) && !((Boolean)this.gameSettings.forceUnicodeFont.value).booleanValue()) {
            int upper = this.charWidth[fontIndex] >> 4;
            int lower = this.charWidth[fontIndex] & 0xF;
            float fUpper = upper;
            float fLower = lower + 1;
            return (int)((fLower - fUpper) / 2.0f + 1.0f);
        }
        if (this.glyphWidth[c] != 0) {
            int upper = this.glyphWidth[c] >> 4;
            int lower = this.glyphWidth[c] & 0xF;
            if (lower > 7) {
                lower = 15;
                upper = 0;
            }
            return (++lower - upper) / 2 + 1;
        }
        return 0;
    }

    public String trimStringToWidth(String s, int maxWidth) {
        return this.trimStringToWidth(s, maxWidth, false);
    }

    public String trimStringToWidth(String s, int maxWidth, boolean par3) {
        StringBuilder var4 = new StringBuilder();
        int var5 = 0;
        int var6 = par3 ? s.length() - 1 : 0;
        int var7 = par3 ? -1 : 1;
        boolean var8 = false;
        boolean var9 = false;
        for (int var10 = var6; var10 >= 0 && var10 < s.length() && var5 < maxWidth; var10 += var7) {
            char var11 = s.charAt(var10);
            int var12 = this.getCharWidth(var11);
            if (var8) {
                var8 = false;
                if (var11 != 'l' && var11 != 'L') {
                    if (var11 == 'r' || var11 == 'R') {
                        var9 = false;
                    }
                } else {
                    var9 = true;
                }
            } else if (var12 < 0) {
                var8 = true;
            } else {
                var5 += var12;
                if (var9) {
                    ++var5;
                }
            }
            if (var5 > maxWidth) break;
            if (par3) {
                var4.insert(0, var11);
                continue;
            }
            var4.append(var11);
        }
        return var4.toString();
    }

    private String trimStringNewline(String s) {
        while (s != null && s.endsWith("\n")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public void drawStringIntoConstrainedBlock(String s, int x, int y, int maxWidth, int argb) {
        this.drawStringIntoConstrainedBlock(s, x, y, maxWidth, argb, false);
    }

    private void renderSplitString(String s, int x, int y, int maxWidth, boolean isShadow) {
        List<String> lines = this.listFormattedStringToWidth(s, maxWidth);
        for (String line : lines) {
            this.renderStringAligned(line, x, y, maxWidth, this.textColor, isShadow);
            y += this.fontHeight;
        }
    }

    public int getHeightOfConstrainedString(String s, int maxWidth) {
        return this.fontHeight * this.listFormattedStringToWidth(s, maxWidth).size();
    }

    public void setBidiFlag(boolean par1) {
        this.bidiFlag = par1;
    }

    public List<String> listFormattedStringToWidth(String s, int maxWidth) {
        return Arrays.asList(this.wrapFormattedStringToWidth(s, maxWidth).split("\n"));
    }

    public String wrapFormattedStringToWidth(String s, int maxWidth) {
        int var3 = this.sizeStringToWidth(s, maxWidth);
        if (s.length() <= var3) {
            return s;
        }
        String var4 = s.substring(0, var3);
        char var5 = s.charAt(var3);
        boolean var6 = var5 == ' ' || var5 == '\n';
        String var7 = Font.getFormatFromString(var4) + s.substring(var3 + (var6 ? 1 : 0));
        return var4 + "\n" + this.wrapFormattedStringToWidth(var7, maxWidth);
    }

    private int sizeStringToWidth(String par1Str, int par2) {
        int var5;
        int var3 = par1Str.length();
        int var4 = 0;
        int var6 = -1;
        boolean var7 = false;
        for (var5 = 0; var5 < var3; ++var5) {
            char var8 = par1Str.charAt(var5);
            switch (var8) {
                case '\n': {
                    --var5;
                    break;
                }
                case ' ': {
                    var6 = var5;
                }
                default: {
                    var4 += this.getCharWidth(var8);
                    if (!var7) break;
                    ++var4;
                    break;
                }
                case '\u00a7': {
                    char var9;
                    if (var5 >= var3 - 1) break;
                    if ((var9 = par1Str.charAt(++var5)) != 'l' && var9 != 'L') {
                        if (var9 != 'r' && var9 != 'R' && !Font.isFormatColor(var9)) break;
                        var7 = false;
                        break;
                    }
                    var7 = true;
                }
            }
            if (var8 == '\n') {
                var6 = ++var5;
                break;
            }
            if (var4 > par2) break;
        }
        return var5 != var3 && var6 != -1 && var6 < var5 ? var6 : var5;
    }

    private static boolean isFormatColor(char par0) {
        return par0 >= '0' && par0 <= '9' || par0 >= 'a' && par0 <= 'f' || par0 >= 'A' && par0 <= 'F';
    }

    private static boolean isFormatSpecial(char par0) {
        return par0 >= 'k' && par0 <= 'o' || par0 >= 'K' && par0 <= 'O' || par0 == 'r' || par0 == 'R';
    }

    private static String getFormatFromString(String par0Str) {
        StringBuilder var1 = new StringBuilder();
        int var2 = -1;
        int var3 = par0Str.length();
        while ((var2 = par0Str.indexOf(167, var2 + 1)) != -1) {
            if (var2 >= var3 - 1) continue;
            char var4 = par0Str.charAt(var2 + 1);
            if (Font.isFormatColor(var4)) {
                var1 = new StringBuilder("\u00a7" + var4);
                continue;
            }
            if (!Font.isFormatSpecial(var4)) continue;
            var1.append("\u00a7").append(var4);
        }
        return var1.toString();
    }

    public boolean getBidiFlag() {
        return this.bidiFlag;
    }

    public static String stripColorCodes(String s) {
        return FORMATTING_CODE_REGEX.matcher(s).replaceAll("");
    }

    public void drawStringIntoConstrainedBlock(String s, int x, int y, int maxWidth, int argb, boolean isShadow) {
        this.resetStyles();
        this.textColor = argb;
        this.renderSplitString(this.trimStringNewline(s), x, y, maxWidth, isShadow);
    }

    public void drawCenteredString(String string, int x, int y, int color) {
        int length = this.getStringWidth(string);
        this.drawStringWithShadow(string, x - length / 2, y, color);
    }
}

