/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.block.color.BlockColor;
import net.minecraft.client.render.block.color.BlockColorDispatcher;
import net.minecraft.client.render.block.model.StandardBlockModel;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.util.helper.Side;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

public class CrossedSquaresBlockModel<T extends Block>
extends StandardBlockModel<T> {
    public CrossedSquaresBlockModel(Block block) {
        super(block);
    }

    @Override
    public void renderBlockOnInventory(Tessellator tessellator, int metadata, float brightness, float alpha, @Nullable Integer lightmapCoordinate) {
        if (LightmapHelper.isLightmapEnabled()) {
            brightness = 1.0f;
        }
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        if (CrossedSquaresBlockModel.renderBlocks.useInventoryTint) {
            int color = ((BlockColor)BlockColorDispatcher.getInstance().getDispatch(this.block)).getFallbackColor(metadata);
            r = (float)(color >> 16 & 0xFF) / 255.0f;
            g = (float)(color >> 8 & 0xFF) / 255.0f;
            b = (float)(color & 0xFF) / 255.0f;
        }
        float yOffset = 0.0f;
        this.setBlockBoundsForItemRender();
        GL11.glTranslatef(-0.5f, -0.5f, -0.5f);
        IconCoordinate texIndex = this.getBlockTextureFromSideAndMetadata(Side.BOTTOM, metadata);
        if (CrossedSquaresBlockModel.renderBlocks.overrideBlockTexture != null) {
            texIndex = CrossedSquaresBlockModel.renderBlocks.overrideBlockTexture;
        }
        double minU = texIndex.getIconUMin();
        double maxU = texIndex.getIconUMax();
        double minV = texIndex.getIconVMin();
        double maxV = texIndex.getIconVMax();
        tessellator.startDrawingQuads();
        tessellator.setColorOpaque_F(r * brightness, g * brightness, b * brightness);
        tessellator.setNormal(0.0f, 1.0f, 0.0f);
        if (LightmapHelper.isLightmapEnabled() && lightmapCoordinate != null) {
            tessellator.setLightmapCoord(lightmapCoordinate);
        }
        double xd = 0.0;
        double yd = 0.0;
        double zd = 0.0;
        double minX = xd + 0.5 - 0.45;
        double maxX = xd + 0.5 + 0.45;
        double minZ = zd + 0.5 - 0.45;
        double maxZ = zd + 0.5 + 0.45;
        tessellator.addVertexWithUV(minX, yd + 1.0 + 0.0, minZ, minU, minV);
        tessellator.addVertexWithUV(minX, yd + 0.0, minZ, minU, maxV);
        tessellator.addVertexWithUV(maxX, yd + 0.0, maxZ, maxU, maxV);
        tessellator.addVertexWithUV(maxX, yd + 1.0 + 0.0, maxZ, maxU, minV);
        tessellator.addVertexWithUV(maxX, yd + 1.0 + 0.0, maxZ, minU, minV);
        tessellator.addVertexWithUV(maxX, yd + 0.0, maxZ, minU, maxV);
        tessellator.addVertexWithUV(minX, yd + 0.0, minZ, maxU, maxV);
        tessellator.addVertexWithUV(minX, yd + 1.0 + 0.0, minZ, maxU, minV);
        tessellator.addVertexWithUV(minX, yd + 1.0 + 0.0, maxZ, minU, minV);
        tessellator.addVertexWithUV(minX, yd + 0.0, maxZ, minU, maxV);
        tessellator.addVertexWithUV(maxX, yd + 0.0, minZ, maxU, maxV);
        tessellator.addVertexWithUV(maxX, yd + 1.0 + 0.0, minZ, maxU, minV);
        tessellator.addVertexWithUV(maxX, yd + 1.0 + 0.0, minZ, minU, minV);
        tessellator.addVertexWithUV(maxX, yd + 0.0, minZ, minU, maxV);
        tessellator.addVertexWithUV(minX, yd + 0.0, maxZ, maxU, maxV);
        tessellator.addVertexWithUV(minX, yd + 1.0 + 0.0, maxZ, maxU, minV);
        tessellator.draw();
        GL11.glTranslatef(0.5f, 0.5f, 0.5f);
    }

    @Override
    public boolean render(Tessellator tessellator, int x, int y, int z) {
        this.block.setBlockBoundsBasedOnState(CrossedSquaresBlockModel.renderBlocks.blockAccess, x, y, z);
        float brightness = 1.0f;
        if (!LightmapHelper.isLightmapEnabled()) {
            brightness = this.getBlockBrightness(CrossedSquaresBlockModel.renderBlocks.blockAccess, x, y, z);
        } else {
            tessellator.setLightmapCoord(this.block.getLightmapCoord(CrossedSquaresBlockModel.renderBlocks.blockAccess, x, y, z));
        }
        int color = ((BlockColor)BlockColorDispatcher.getInstance().getDispatch(this.block)).getWorldColor(CrossedSquaresBlockModel.renderBlocks.blockAccess, x, y, z);
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        tessellator.setColorOpaque_F(brightness * r, brightness * g, brightness * b);
        double xd = x;
        double yd = y;
        double zd = z;
        if (this.block == Blocks.TALLGRASS || this.block == Blocks.TALLGRASS_FERN || this.block == Blocks.SPINIFEX) {
            long dRandom = (long)x * 3129871L ^ (long)z * 116129781L ^ (long)y;
            dRandom = dRandom * dRandom * 42317861L + dRandom * 11L;
            xd += ((double)((float)(dRandom >> 16 & 0xFL) / 15.0f) - 0.5) * 0.5;
            yd += ((double)((float)(dRandom >> 20 & 0xFL) / 15.0f) - 1.0) * 0.2;
            zd += ((double)((float)(dRandom >> 24 & 0xFL) / 15.0f) - 0.5) * 0.5;
        }
        int metadata = CrossedSquaresBlockModel.renderBlocks.blockAccess.getBlockMetadata(x, y, z);
        IconCoordinate texIndex = this.getBlockTextureFromSideAndMetadata(Side.BOTTOM, metadata);
        if (CrossedSquaresBlockModel.renderBlocks.overrideBlockTexture != null) {
            texIndex = CrossedSquaresBlockModel.renderBlocks.overrideBlockTexture;
        }
        double minU = texIndex.getIconUMin();
        double maxU = texIndex.getIconUMax();
        double minV = texIndex.getIconVMin();
        double maxV = texIndex.getIconVMax();
        float yOffset = 0.0f;
        double minX = xd + 0.5 - 0.45;
        double maxX = xd + 0.5 + 0.45;
        double minZ = zd + 0.5 - 0.45;
        double maxZ = zd + 0.5 + 0.45;
        tessellator.addVertexWithUV(minX, yd + 1.0 + 0.0, minZ, minU, minV);
        tessellator.addVertexWithUV(minX, yd + 0.0, minZ, minU, maxV);
        tessellator.addVertexWithUV(maxX, yd + 0.0, maxZ, maxU, maxV);
        tessellator.addVertexWithUV(maxX, yd + 1.0 + 0.0, maxZ, maxU, minV);
        tessellator.addVertexWithUV(maxX, yd + 1.0 + 0.0, maxZ, minU, minV);
        tessellator.addVertexWithUV(maxX, yd + 0.0, maxZ, minU, maxV);
        tessellator.addVertexWithUV(minX, yd + 0.0, minZ, maxU, maxV);
        tessellator.addVertexWithUV(minX, yd + 1.0 + 0.0, minZ, maxU, minV);
        tessellator.addVertexWithUV(minX, yd + 1.0 + 0.0, maxZ, minU, minV);
        tessellator.addVertexWithUV(minX, yd + 0.0, maxZ, minU, maxV);
        tessellator.addVertexWithUV(maxX, yd + 0.0, minZ, maxU, maxV);
        tessellator.addVertexWithUV(maxX, yd + 1.0 + 0.0, minZ, maxU, minV);
        tessellator.addVertexWithUV(maxX, yd + 1.0 + 0.0, minZ, minU, minV);
        tessellator.addVertexWithUV(maxX, yd + 0.0, minZ, minU, maxV);
        tessellator.addVertexWithUV(minX, yd + 0.0, maxZ, maxU, maxV);
        tessellator.addVertexWithUV(minX, yd + 1.0 + 0.0, maxZ, maxU, minV);
        return true;
    }

    @Override
    public boolean shouldItemRender3d() {
        return false;
    }

    @Override
    public float getItemRenderScale() {
        return 0.5f;
    }
}

