/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.StandardBlockModel;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.LampBlock;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;

public class LampBlockModel<T extends LampBlock>
extends StandardBlockModel<T> {
    private static final IconCoordinate[] texCoordsInactive = new IconCoordinate[16];
    private static final IconCoordinate[] texCoordsActive = new IconCoordinate[16];

    public LampBlockModel(Block block) {
        super(block);
    }

    @Override
    public IconCoordinate getBlockTexture(WorldSource worldSource, int x, int y, int z, Side side) {
        int color = worldSource.getBlockMetadata(x, y, z) & 0xF;
        if (((LampBlock)this.block).isActive) {
            return texCoordsActive[color];
        }
        return texCoordsInactive[color];
    }

    @Override
    public IconCoordinate getBlockTextureFromSideAndMetadata(Side side, int data) {
        return texCoordsActive[data & 0xF];
    }

    static {
        for (DyeColor c : DyeColor.blockOrderedColors()) {
            LampBlockModel.texCoordsInactive[c.blockMeta] = TextureRegistry.getTexture("minecraft:block/lamp/" + c.colorID + "_idle");
            LampBlockModel.texCoordsActive[c.blockMeta] = TextureRegistry.getTexture("minecraft:block/lamp/" + c.colorID + "_active");
        }
    }
}

