/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.block.model.StandardBlockModel;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.Vec3;

public class LeverBlockModel<T extends Block>
extends StandardBlockModel<T> {
    public LeverBlockModel(Block block) {
        super(block);
    }

    @Override
    public boolean render(Tessellator tessellator, int x, int y, int z) {
        boolean flag1;
        this.block.setBlockBoundsBasedOnState(LeverBlockModel.renderBlocks.blockAccess, x, y, z);
        int l = LeverBlockModel.renderBlocks.blockAccess.getBlockMetadata(x, y, z);
        int i1 = l & 0xF;
        boolean flag = (l & 0x10) > 0;
        boolean bl = flag1 = LeverBlockModel.renderBlocks.overrideBlockTexture != null;
        if (!flag1) {
            LeverBlockModel.renderBlocks.overrideBlockTexture = ((BlockModel)BlockModelDispatcher.getInstance().getDispatch(Blocks.COBBLE_STONE)).getBlockTextureFromSideAndMetadata(Side.BOTTOM, l);
        }
        float f = 0.25f;
        float f1 = 0.1875f;
        float f2 = 0.1875f;
        if (i1 == 7) {
            this.block.setBlockBounds(0.5f - f1, 1.0f - f2, 0.5f - f, 0.5f + f1, 1.0, 0.5f + f);
        } else if (i1 == 8) {
            this.block.setBlockBounds(0.5f - f, 1.0f - f2, 0.5f - f1, 0.5f + f, 1.0, 0.5f + f1);
        } else if (i1 == 5) {
            this.block.setBlockBounds(0.5f - f1, 0.0, 0.5f - f, 0.5f + f1, f2, 0.5f + f);
        } else if (i1 == 6) {
            this.block.setBlockBounds(0.5f - f, 0.0, 0.5f - f1, 0.5f + f, f2, 0.5f + f1);
        } else if (i1 == 4) {
            this.block.setBlockBounds(0.5f - f1, 0.5f - f, 1.0f - f2, 0.5f + f1, 0.5f + f, 1.0);
        } else if (i1 == 3) {
            this.block.setBlockBounds(0.5f - f1, 0.5f - f, 0.0, 0.5f + f1, 0.5f + f, f2);
        } else if (i1 == 2) {
            this.block.setBlockBounds(1.0f - f2, 0.5f - f, 0.5f - f1, 1.0, 0.5f + f, 0.5f + f1);
        } else if (i1 == 1) {
            this.block.setBlockBounds(0.0, 0.5f - f, 0.5f - f1, f2, 0.5f + f, 0.5f + f1);
        }
        this.renderStandardBlock(tessellator, this.block, x, y, z);
        if (!flag1) {
            LeverBlockModel.renderBlocks.overrideBlockTexture = null;
        }
        float brightness = 1.0f;
        if (LightmapHelper.isLightmapEnabled()) {
            tessellator.setLightmapCoord(this.block.getLightmapCoord(LeverBlockModel.renderBlocks.blockAccess, x, y, z));
        } else {
            brightness = Block.lightEmission[this.block.id] > 0 ? 1.0f : this.getBlockBrightness(LeverBlockModel.renderBlocks.blockAccess, x, y, z);
        }
        tessellator.setColorOpaque_F(brightness, brightness, brightness);
        IconCoordinate texture = this.getBlockTextureFromSideAndMetadata(Side.BOTTOM, l);
        if (LeverBlockModel.renderBlocks.overrideBlockTexture != null) {
            texture = LeverBlockModel.renderBlocks.overrideBlockTexture;
        }
        double f4 = texture.getIconUMin();
        double f5 = texture.getIconUMax();
        double f6 = texture.getIconVMin();
        double f7 = texture.getIconVMax();
        Vec3[] avec3 = new Vec3[8];
        float f8 = 0.0625f;
        float f9 = 0.0625f;
        float f10 = 0.625f;
        avec3[0] = Vec3.getTempVec3(-f8, 0.0, -f9);
        avec3[1] = Vec3.getTempVec3(f8, 0.0, -f9);
        avec3[2] = Vec3.getTempVec3(f8, 0.0, f9);
        avec3[3] = Vec3.getTempVec3(-f8, 0.0, f9);
        avec3[4] = Vec3.getTempVec3(-f8, f10, -f9);
        avec3[5] = Vec3.getTempVec3(f8, f10, -f9);
        avec3[6] = Vec3.getTempVec3(f8, f10, f9);
        avec3[7] = Vec3.getTempVec3(-f8, f10, f9);
        for (int i2 = 0; i2 < 8; ++i2) {
            if (flag) {
                avec3[i2].z -= 0.0625;
                avec3[i2].rotateAroundX(0.6981317f);
            } else {
                avec3[i2].z += 0.0625;
                avec3[i2].rotateAroundX(-0.6981317f);
            }
            if (i1 == 6 || i1 == 8) {
                avec3[i2].rotateAroundY(1.5707964f);
            }
            if (i1 < 5) {
                avec3[i2].y -= 0.375;
                avec3[i2].rotateAroundX(1.5707964f);
                if (i1 == 4) {
                    avec3[i2].rotateAroundY(0.0f);
                }
                if (i1 == 3) {
                    avec3[i2].rotateAroundY((float)Math.PI);
                }
                if (i1 == 2) {
                    avec3[i2].rotateAroundY(1.5707964f);
                }
                if (i1 == 1) {
                    avec3[i2].rotateAroundY(-1.5707964f);
                }
                avec3[i2].x += (double)x + 0.5;
                avec3[i2].y += (double)((float)y + 0.5f);
                avec3[i2].z += (double)z + 0.5;
                continue;
            }
            if (i1 == 5 || i1 == 6) {
                avec3[i2].x += (double)x + 0.5;
                avec3[i2].y += (double)((float)y + 0.125f);
                avec3[i2].z += (double)z + 0.5;
                continue;
            }
            avec3[i2].rotateAroundX((float)Math.PI);
            avec3[i2].x += (double)x + 0.5;
            avec3[i2].y += (double)((float)(y + 1) - 0.125f);
            avec3[i2].z += (double)z + 0.5;
        }
        for (int j2 = 0; j2 < 6; ++j2) {
            Vec3 vec3d3;
            Vec3 vec32;
            Vec3 vec31;
            Vec3 vec3;
            if (j2 == 0) {
                f4 = texture.getSubIconU(0.4375);
                f5 = texture.getSubIconU(0.5625);
                f6 = texture.getSubIconV(0.375);
                f7 = texture.getSubIconV(0.5);
            } else if (j2 == 2) {
                f4 = texture.getSubIconU(0.4375);
                f5 = texture.getSubIconU(0.5625);
                f6 = texture.getSubIconV(0.375);
                f7 = texture.getIconVMax();
            }
            if (j2 == 0) {
                vec3 = avec3[0];
                vec31 = avec3[1];
                vec32 = avec3[2];
                vec3d3 = avec3[3];
            } else if (j2 == 1) {
                vec3 = avec3[7];
                vec31 = avec3[6];
                vec32 = avec3[5];
                vec3d3 = avec3[4];
            } else if (j2 == 2) {
                vec3 = avec3[1];
                vec31 = avec3[0];
                vec32 = avec3[4];
                vec3d3 = avec3[5];
            } else if (j2 == 3) {
                vec3 = avec3[2];
                vec31 = avec3[1];
                vec32 = avec3[5];
                vec3d3 = avec3[6];
            } else if (j2 == 4) {
                vec3 = avec3[3];
                vec31 = avec3[2];
                vec32 = avec3[6];
                vec3d3 = avec3[7];
            } else {
                vec3 = avec3[0];
                vec31 = avec3[3];
                vec32 = avec3[7];
                vec3d3 = avec3[4];
            }
            tessellator.addVertexWithUV(vec3.x, vec3.y, vec3.z, f4, f7);
            tessellator.addVertexWithUV(vec31.x, vec31.y, vec31.z, f5, f7);
            tessellator.addVertexWithUV(vec32.x, vec32.y, vec32.z, f5, f6);
            tessellator.addVertexWithUV(vec3d3.x, vec3d3.y, vec3d3.z, f4, f6);
        }
        return true;
    }

    @Override
    public boolean shouldItemRender3d() {
        return false;
    }

    @Override
    public float getItemRenderScale() {
        return 0.5f;
    }
}

