/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.DoorBlockModel;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.DoorBlock;
import net.minecraft.core.util.helper.Axis;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.util.helper.Side;

public class PaintedDoorBlockModel<T extends DoorBlock>
extends DoorBlockModel<T> {
    public static final IconCoordinate[] doorBottomTextures = new IconCoordinate[16];
    public static final IconCoordinate[] doorTopTextures = new IconCoordinate[16];
    public static final IconCoordinate[] frameTopTextures = new IconCoordinate[16];
    private final boolean isTop;

    public PaintedDoorBlockModel(Block block, boolean isTop) {
        super(block);
        this.isTop = isTop;
    }

    @Override
    public IconCoordinate getBlockTextureFromSideAndMetadata(Side side, int data) {
        int color = data >> 4 & 0xF;
        if (side.getAxis() == Axis.Y) {
            return frameTopTextures[color];
        }
        if (this.isTop) {
            return doorTopTextures[color];
        }
        return doorBottomTextures[color];
    }

    static {
        for (DyeColor c : DyeColor.blockOrderedColors()) {
            PaintedDoorBlockModel.doorTopTextures[c.blockMeta] = TextureRegistry.getTexture("minecraft:block/door/planks_" + c.colorID + "/top");
            PaintedDoorBlockModel.doorBottomTextures[c.blockMeta] = TextureRegistry.getTexture("minecraft:block/door/planks_" + c.colorID + "/bottom");
            PaintedDoorBlockModel.frameTopTextures[c.blockMeta] = TextureRegistry.getTexture("minecraft:block/door/planks_" + c.colorID + "/frame_top");
        }
    }
}

