/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.block.model.StandardBlockModel;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.RailBlock;
import net.minecraft.core.enums.LightLayer;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;

public class RailBlockModel<T extends RailBlock>
extends StandardBlockModel<T> {
    protected IconCoordinate railCurve = TextureRegistry.getTexture("minecraft:block/rail/turn");
    protected IconCoordinate powerActive = TextureRegistry.getTexture("minecraft:block/rail_powered/active");
    protected IconCoordinate powerActiveOverlay = TextureRegistry.getTexture("minecraft:block/rail_powered/active_overlay");
    protected IconCoordinate detectorActiveOverlay = TextureRegistry.getTexture("minecraft:block/rail_detector/active_overlay");

    public RailBlockModel(Block block) {
        super(block);
        this.hasOverbright = true;
    }

    @Override
    public boolean render(Tessellator tessellator, int x, int y, int z) {
        ((RailBlock)this.block).setBlockBoundsBasedOnState(RailBlockModel.renderBlocks.blockAccess, x, y, z);
        int l = RailBlockModel.renderBlocks.blockAccess.getBlockMetadata(x, y, z);
        IconCoordinate i1 = this.getBlockTextureFromSideAndMetadata(Side.BOTTOM, l);
        if (RailBlockModel.renderBlocks.overrideBlockTexture != null) {
            i1 = RailBlockModel.renderBlocks.overrideBlockTexture;
        }
        if (((RailBlock)this.block).getIsPowered()) {
            l &= 7;
        }
        float brightness = 1.0f;
        if (LightmapHelper.isLightmapEnabled()) {
            if (RailBlockModel.renderBlocks.overbright) {
                tessellator.setLightmapCoord(LightmapHelper.getOverbrightLightmapCoord(RailBlockModel.renderBlocks.blockAccess.getSavedLightValue(LightLayer.Sky, x, y, z)));
            } else {
                tessellator.setLightmapCoord(((RailBlock)this.block).getLightmapCoord(RailBlockModel.renderBlocks.blockAccess, x, y, z));
            }
        } else if (!RailBlockModel.renderBlocks.overbright) {
            brightness = this.getBlockBrightness(RailBlockModel.renderBlocks.blockAccess, x, y, z);
        }
        if (RailBlockModel.renderBlocks.overbright && (i1 = this.getBlockOverbrightTexture(RailBlockModel.renderBlocks.blockAccess, x, y, z, 0)) == null) {
            return false;
        }
        tessellator.setColorOpaque_F(brightness, brightness, brightness);
        double d = i1.getIconUMin();
        double d1 = i1.getIconUMax();
        double d2 = i1.getIconVMin();
        double d3 = i1.getIconVMax();
        float f1 = 0.0625f;
        float f2 = x + 1;
        float f3 = x + 1;
        float f4 = x;
        float f5 = x;
        float f6 = z;
        float f7 = z + 1;
        float f8 = z + 1;
        float f9 = z;
        float f10 = (float)y + f1;
        float f11 = (float)y + f1;
        float f12 = (float)y + f1;
        float f13 = (float)y + f1;
        if (l == 1 || l == 2 || l == 3 || l == 7) {
            f2 = f5 = (float)(x + 1);
            f3 = f4 = (float)x;
            f6 = f7 = (float)(z + 1);
            f8 = f9 = (float)z;
        } else if (l == 8) {
            f2 = f3 = (float)x;
            f4 = f5 = (float)(x + 1);
            f6 = f9 = (float)(z + 1);
            f7 = f8 = (float)z;
        } else if (l == 9) {
            f2 = f5 = (float)x;
            f3 = f4 = (float)(x + 1);
            f6 = f7 = (float)z;
            f8 = f9 = (float)(z + 1);
        }
        if (l == 2 || l == 4) {
            f10 += 1.0f;
            f13 += 1.0f;
        } else if (l == 3 || l == 5) {
            f11 += 1.0f;
            f12 += 1.0f;
        }
        tessellator.addVertexWithUV(f2, f10, f6, d1, d2);
        tessellator.addVertexWithUV(f3, f11, f7, d1, d3);
        tessellator.addVertexWithUV(f4, f12, f8, d, d3);
        tessellator.addVertexWithUV(f5, f13, f9, d, d2);
        tessellator.addVertexWithUV(f5, f13, f9, d, d2);
        tessellator.addVertexWithUV(f4, f12, f8, d, d3);
        tessellator.addVertexWithUV(f3, f11, f7, d1, d3);
        tessellator.addVertexWithUV(f2, f10, f6, d1, d2);
        return true;
    }

    @Override
    public boolean shouldItemRender3d() {
        return false;
    }

    @Override
    public IconCoordinate getBlockOverbrightTexture(WorldSource blockAccess, int x, int y, int z, int side) {
        if (!((RailBlock)this.block).isPowered || (blockAccess.getBlockMetadata(x, y, z) & 8) == 0) {
            return null;
        }
        return this.block == Blocks.RAIL_POWERED ? this.powerActiveOverlay : this.detectorActiveOverlay;
    }

    @Override
    public IconCoordinate getBlockTextureFromSideAndMetadata(Side side, int data) {
        if (this.block == Blocks.RAIL_POWERED && (data & 8) != 0) {
            return this.powerActive;
        }
        if (!((RailBlock)this.block).isPowered && data >= 6) {
            return this.railCurve;
        }
        return super.getBlockTextureFromSideAndMetadata(side, data);
    }
}

