/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.entity;

import net.minecraft.client.Minecraft;
import net.minecraft.client.render.BlockEntityRenderDispatcher;
import net.minecraft.client.render.Lighting;
import net.minecraft.client.render.RenderBlocks;
import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.blockentity.BlockEntityRenderer;
import net.minecraft.client.render.entity.EntityRenderer;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.BlockEntity;
import net.minecraft.core.entity.FallingBlockEntity;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.BlocksContainer;
import org.lwjgl.opengl.GL11;

public class FallingBlockRenderer
extends EntityRenderer<FallingBlockEntity> {
    private final Minecraft mc = Minecraft.getMinecraft(this);
    private BlocksContainer container = null;
    private RenderBlocks containerRenderBlock = null;

    public FallingBlockRenderer() {
        this.shadowSize = 0.5f;
    }

    @Override
    public void render(Tessellator tessellator, FallingBlockEntity fallingBlock, double x, double y, double z, float yaw, float partialTick) {
        if (this.container == null || this.container.world != fallingBlock.world) {
            this.container = new BlocksContainer(fallingBlock.world);
            this.containerRenderBlock = new RenderBlocks(this.container);
        }
        GL11.glPushMatrix();
        GL11.glTranslated(x, y, z);
        TextureRegistry.blockAtlas.bind();
        Lighting.disable();
        GL11.glBlendFunc(770, 771);
        GL11.glEnable(3042);
        GL11.glDisable(2884);
        if (this.mc.isAmbientOcclusionEnabled()) {
            GL11.glShadeModel(7425);
        } else {
            GL11.glShadeModel(7424);
        }
        int blockX = MathHelper.floor(fallingBlock.x);
        int blockY = MathHelper.floor(fallingBlock.y);
        int blockZ = MathHelper.floor(fallingBlock.z);
        tessellator.startDrawingQuads();
        tessellator.setTranslation((double)(-blockX) - 0.5, (double)(-blockY) - 0.5, (double)(-blockZ) - 0.5);
        BlockModel.setRenderBlocks(this.containerRenderBlock);
        this.container.setLightReferenceEntity(fallingBlock);
        this.container.setBlock(blockX, blockY, blockZ, fallingBlock.carriedBlock.blockId, fallingBlock.carriedBlock.metadata, fallingBlock.carriedBlock.entity);
        ((BlockModel)BlockModelDispatcher.getInstance().getDispatch(Block.getBlock(fallingBlock.carriedBlock.blockId))).renderNoCulling(Tessellator.instance, blockX, blockY, blockZ);
        this.container.setLightReferenceEntity(null);
        this.container.clear();
        tessellator.setTranslation(0.0, 0.0, 0.0);
        tessellator.draw();
        Lighting.enableLight();
        GL11.glPopMatrix();
        BlockEntityRenderer<BlockEntity> renderer = BlockEntityRenderDispatcher.instance.getRenderer(fallingBlock.carriedBlock.entity);
        if (renderer != null) {
            GL11.glPushMatrix();
            renderer.doRender(tessellator, fallingBlock.carriedBlock.entity, x - 0.5, y - 0.5, z - 0.5, partialTick);
            GL11.glPopMatrix();
        }
    }
}

