/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.item.model;

import net.minecraft.client.Minecraft;
import net.minecraft.client.render.EntityRenderDispatcher;
import net.minecraft.client.render.ItemRenderer;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.MapItemRenderer;
import net.minecraft.client.render.PlayerSkinParser;
import net.minecraft.client.render.entity.PlayerRenderer;
import net.minecraft.client.render.item.model.StandardItemModel;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.item.MapItem;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.saveddata.maps.ItemMapSavedData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

public class MapItemModel
extends StandardItemModel {
    private final Minecraft mc = Minecraft.getMinecraft(Minecraft.class);
    private final MapItemRenderer renderMapInstance;

    public MapItemModel(Item item, String namespace) {
        super(item, namespace);
        this.renderMapInstance = new MapItemRenderer(this.mc.font, this.mc.gameSettings, this.mc.textureManager);
    }

    @Override
    public void renderItemFirstPerson(Tessellator tessellator, ItemRenderer renderer, Player player, ItemStack stack, float partialTick) {
        int blockX = MathHelper.floor(player.x);
        int blockY = MathHelper.floor(player.y);
        int blockZ = MathHelper.floor(player.z);
        float brightness = 1.0f;
        if (LightmapHelper.isLightmapEnabled()) {
            LightmapHelper.setLightmapCoord(this.mc.theWorld.getLightmapCoord(blockX, blockY, blockZ, 0));
        } else if (!this.mc.fullbright) {
            brightness = this.mc.theWorld.getLightBrightness(blockX, blockY, blockZ);
        }
        GL11.glColor4f(brightness, brightness, brightness, 1.0f);
        float rotationPitch = player.xRotO + (player.xRot - player.xRotO) * partialTick;
        float swingProgress = player.getSwingProgress(partialTick);
        float f_z = MathHelper.sin(swingProgress * (float)Math.PI);
        float f_x = MathHelper.sin(MathHelper.sqrt_float(swingProgress) * (float)Math.PI);
        GL11.glTranslatef(-f_x * 0.4f, MathHelper.sin(MathHelper.sqrt_float(swingProgress) * (float)Math.PI * 2.0f) * 0.2f, -f_z * 0.2f);
        float f_val = MathHelper.clamp(1.0f - rotationPitch / 45.0f + 0.1f, 0.0f, 1.0f);
        f_val = -MathHelper.cos(f_val * (float)Math.PI) * 0.5f + 0.5f;
        float zOff = -0.71999997f;
        GL11.glTranslatef(0.0f, -(1.0f - renderer.getEquippedProgress(partialTick)) * 1.2f - f_val * 0.5f + 0.04f, -0.71999997f);
        GL11.glRotatef(90.0f, 0.0f, 1.0f, 0.0f);
        GL11.glRotatef(f_val * -85.0f, 0.0f, 0.0f, 1.0f);
        GL11.glEnable(32826);
        this.mc.textureManager.bindDownloadableTexture(this.mc.thePlayer.skinURL, this.mc.thePlayer.getEntityTexture(), PlayerSkinParser.instance);
        PlayerRenderer playerRenderer = (PlayerRenderer)EntityRenderDispatcher.instance.getRenderer(this.mc.thePlayer);
        GL11.glPushMatrix();
        GL11.glTranslatef(-0.0f, -0.6f, -1.1f);
        GL11.glRotatef(180.0f, 0.0f, 1.0f, 0.0f);
        GL11.glRotatef(-45.0f, 1.0f, 0.0f, 0.0f);
        GL11.glRotatef(31.0f, 0.0f, 0.0f, 1.0f);
        GL11.glRotatef(65.0f, 0.0f, 1.0f, 0.0f);
        playerRenderer.drawFirstPersonHand(this.mc.thePlayer, true);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef(-0.0f, -0.6f, 1.1f);
        GL11.glRotatef(-45.0f, 1.0f, 0.0f, 0.0f);
        GL11.glRotatef(-31.0f, 0.0f, 0.0f, 1.0f);
        GL11.glRotatef(-65.0f, 0.0f, 1.0f, 0.0f);
        playerRenderer.drawFirstPersonHand(this.mc.thePlayer, false);
        GL11.glPopMatrix();
        float f_val3 = MathHelper.sin(swingProgress * swingProgress * (float)Math.PI);
        float f_val4 = MathHelper.sin(MathHelper.sqrt_float(swingProgress) * (float)Math.PI);
        GL11.glRotatef(-f_val3 * 20.0f, 0.0f, 1.0f, 0.0f);
        GL11.glRotatef(-f_val4 * 20.0f, 0.0f, 0.0f, 1.0f);
        GL11.glRotatef(-f_val4 * 80.0f, 1.0f, 0.0f, 0.0f);
        float scale1 = 0.38f;
        GL11.glScalef(0.38f, 0.38f, 0.38f);
        GL11.glRotatef(90.0f, 0.0f, 1.0f, 0.0f);
        GL11.glRotatef(180.0f, 0.0f, 0.0f, 1.0f);
        GL11.glTranslatef(-1.0f, -1.0f, 0.0f);
        float scale2 = 0.015625f;
        GL11.glScalef(0.015625f, 0.015625f, 0.015625f);
        GL11.glNormal3f(0.0f, 0.0f, -1.0f);
        this.mc.textureManager.bindTexture(this.mc.textureManager.loadTexture("/assets/minecraft/textures/misc/mapbg.png"));
        tessellator.startDrawingQuads();
        int expansion = 7;
        tessellator.addVertexWithUV(-7.0, 135.0, 0.0, 0.0, 1.0);
        tessellator.addVertexWithUV(135.0, 135.0, 0.0, 1.0, 1.0);
        tessellator.addVertexWithUV(135.0, -7.0, 0.0, 1.0, 0.0);
        tessellator.addVertexWithUV(-7.0, -7.0, 0.0, 0.0, 0.0);
        tessellator.draw();
        ItemMapSavedData mapData = Items.MAP.getOrCreateSavedData(stack, this.mc.theWorld);
        if (mapData == null) {
            return;
        }
        this.renderMapInstance.renderMap(this.mc.textureManager, mapData, brightness);
    }

    @Override
    @NotNull
    public IconCoordinate getIcon(@Nullable Entity entity, ItemStack itemStack) {
        if (!MapItem.hasInitialized(itemStack)) {
            return TextureRegistry.getTexture("minecraft:item/map_blank");
        }
        return super.getIcon(entity, itemStack);
    }
}

