/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.model;

import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.model.SheepModel;
import net.minecraft.core.Global;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.animal.SheepMob;
import org.lwjgl.opengl.GL11;

public class SheepOverlayModel
extends SheepModel {
    Mob sheep;

    @Override
    public void setLivingAnimations(Mob mob, float limbSwing, float limbYaw, float partialTick) {
        super.setLivingAnimations(mob, limbSwing, limbYaw, partialTick);
        this.sheep = mob;
        float brightness = this.sheep.getBrightness(limbSwing);
        if (Global.accessor.isFullbrightEnabled() || LightmapHelper.isLightmapEnabled()) {
            brightness = 1.0f;
        }
        int j = ((SheepMob)this.sheep).getFleeceColor().blockMeta;
        GL11.glColor3f(brightness * SheepMob.FLEECE_COLOR_TABLE[j][0], brightness * SheepMob.FLEECE_COLOR_TABLE[j][1], brightness * SheepMob.FLEECE_COLOR_TABLE[j][2]);
    }

    @Override
    public void onUnload() {
        this.sheep = null;
    }

    @Override
    public void render(float limbSwing, float limbYaw, float ticksExisted, float headYaw, float headPitch, float scale) {
        super.render(limbSwing, limbYaw, ticksExisted, headYaw, headPitch, scale);
    }
}

