/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.model;

import net.minecraft.client.render.model.BipedModel;
import net.minecraft.client.render.model.Cube;
import net.minecraft.core.util.helper.MathHelper;

public class ZombieModel
extends BipedModel {
    public ZombieModel() {
        this(0.0f);
    }

    public ZombieModel(float var1) {
        this.parts(var1, 0.0f);
    }

    public void parts(float var1, float var2) {
        this.holdingLeftHand = false;
        this.holdingRightHand = false;
        this.sneaking = false;
        this.cloak = new Cube(0, 0);
        this.cloak.addBox(-5.0f, 0.0f, -1.0f, 10, 16, 1, var1);
        this.ear = new Cube(24, 0);
        this.ear.addBox(-4.0f, -7.0f, -1.0f, 7, 7, 1, var1);
        this.head = new Cube(0, 0);
        this.head.addBox(-4.0f, -8.0f, -4.0f, 8, 8, 8, var1);
        this.head.setRotationPoint(0.0f, 0.0f + var2, 0.0f);
        this.hair = new Cube(32, 0);
        this.hair.addBox(-4.0f, -8.0f, -4.0f, 8, 8, 8, var1 + 0.5f);
        this.hair.setRotationPoint(0.0f, 0.0f + var2, 0.0f);
        this.body = new Cube(16, 16);
        this.body.addBox(-4.0f, 0.0f, -2.0f, 8, 12, 4, var1);
        this.body.setRotationPoint(0.0f, 0.0f + var2, 0.0f);
        this.armRight = new Cube(40, 16);
        this.armRight.addBox(-3.0f, -2.0f, -2.0f, 4, 12, 4, var1);
        this.armRight.setRotationPoint(-5.0f, 2.0f + var2, 0.0f);
        this.armLeft = new Cube(40, 16);
        this.armLeft.mirror = true;
        this.armLeft.addBox(-1.0f, -2.0f, -2.0f, 4, 12, 4, var1);
        this.armLeft.setRotationPoint(5.0f, 2.0f + var2, 0.0f);
        this.legRight = new Cube(0, 16);
        this.legRight.addBox(-2.0f, 0.0f, -2.0f, 4, 12, 4, var1);
        this.legRight.setRotationPoint(-2.0f, 12.0f + var2, 0.0f);
        this.legLeft = new Cube(0, 16);
        this.legLeft.mirror = true;
        this.legLeft.addBox(-2.0f, 0.0f, -2.0f, 4, 12, 4, var1);
        this.legLeft.setRotationPoint(2.0f, 12.0f + var2, 0.0f);
    }

    @Override
    public void setupAnimation(float limbSwing, float limbYaw, float limbPitch, float headYaw, float headPitch, float scale) {
        super.setupAnimation(limbSwing, limbYaw, limbPitch, headYaw, headPitch, scale);
        float var7 = MathHelper.sin(this.onGround * (float)Math.PI);
        float var8 = MathHelper.sin((1.0f - (1.0f - this.onGround) * (1.0f - this.onGround)) * (float)Math.PI);
        this.armRight.zRot = 0.0f;
        this.armLeft.zRot = 0.0f;
        this.armRight.yRot = -(0.1f - var7 * 0.6f);
        this.armLeft.yRot = 0.1f - var7 * 0.6f;
        this.armRight.xRot = -1.5707964f;
        this.armLeft.xRot = -1.5707964f;
        Cube var10000 = this.armRight;
        var10000.xRot -= var7 * 1.2f - var8 * 0.4f;
        var10000 = this.armLeft;
        var10000.xRot -= var7 * 1.2f - var8 * 0.4f;
        var10000 = this.armRight;
        var10000.zRot += MathHelper.cos(limbPitch * 0.09f) * 0.05f + 0.05f;
        var10000 = this.armLeft;
        var10000.zRot -= MathHelper.cos(limbPitch * 0.09f) * 0.05f + 0.05f;
        var10000 = this.armRight;
        var10000.xRot += MathHelper.sin(limbPitch * 0.067f) * 0.05f;
        var10000 = this.armLeft;
        var10000.xRot -= MathHelper.sin(limbPitch * 0.067f) * 0.05f;
    }
}

