/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.window;

import com.github.zarzelcow.legacylwjgl3.implementation.glfw.GLFWKeyboardImplementation;
import com.github.zarzelcow.legacylwjgl3.implementation.glfw.GLFWMouseImplementation;
import com.github.zarzelcow.legacylwjgl3.implementation.input.CombinedInputImplementation;
import com.github.zarzelcow.legacylwjgl3.implementation.input.InputImplementation;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.PanelCrashReport;
import net.minecraft.client.render.window.GameWindow;
import net.minecraft.core.Global;
import net.minecraft.core.UnexpectedThrowable;
import net.minecraft.core.util.helper.Color;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWImage;
import org.lwjgl.glfw.GLFWVidMode;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL;

public class GameWindowGLFW
implements GameWindow {
    public Minecraft mc;
    public long window;
    private boolean wasResized = false;
    private boolean isFullscreen = false;
    private boolean hasFocus = true;
    private int windowPosX;
    private int windowPosY;
    private int windowWidth;
    private int windowHeight;
    private int widthScreenCoords;
    private int heightScreenCoords;
    private int widthPixels;
    private int heightPixels;

    @Override
    public void init(Minecraft minecraft, int width, int height) {
        block5: {
            this.mc = minecraft;
            System.out.println("GLFW Init");
            if (!GLFW.glfwInit()) {
                throw new RuntimeException("GLFW Init failed!");
            }
            GLFW.glfwWindowHint(131075, 1);
            GLFW.glfwWindowHint(131076, 0);
            GLFW.glfwWindowHint(131078, 1);
            GLFW.glfwWindowHint(131077, 1);
            this.window = GLFW.glfwCreateWindow(width, height, "Better than Adventure! " + Global.VERSION, 0L, 0L);
            int[] w = new int[1];
            int[] h = new int[1];
            GLFW.glfwGetWindowSize(this.window, w, h);
            this.widthScreenCoords = w[0];
            this.heightScreenCoords = h[0];
            GLFW.glfwGetFramebufferSize(this.window, w, h);
            this.widthPixels = w[0];
            this.heightPixels = h[0];
            MonitorInfo monitor = new MonitorInfo(GLFW.glfwGetPrimaryMonitor());
            GLFW.glfwSetWindowPos(this.window, (monitor.widthScreenCoords - this.widthScreenCoords) / 2, (monitor.heightScreenCoords - this.heightScreenCoords) / 2);
            GLFW.glfwSetWindowSizeCallback(this.window, (window, ww, hh) -> {
                this.widthScreenCoords = Math.max(1, ww);
                this.heightScreenCoords = Math.max(1, hh);
                this.wasResized = true;
            });
            GLFW.glfwSetFramebufferSizeCallback(this.window, (window, ww, hh) -> {
                this.widthPixels = Math.max(1, ww);
                this.heightPixels = Math.max(1, hh);
                this.wasResized = true;
            });
            GLFW.glfwSetWindowFocusCallback(this.window, (window, focused) -> {
                this.hasFocus = focused;
            });
            int[] resolutions = new int[]{16, 32, 64, 128, 256};
            GLFWImage.Buffer gb = GLFWImage.create(resolutions.length);
            for (int i = 0; i < resolutions.length; ++i) {
                int res = resolutions[i];
                ByteBuffer icon = GameWindowGLFW.getImageBuffer("/icon/" + res + ".png");
                if (icon == null) {
                    System.err.println("Icon at resolution '" + res + "' is null! Skipping icons!");
                    gb.close();
                    break block5;
                }
                GLFWImage iconGI = GLFWImage.create().set(res, res, icon);
                gb.put(i, iconGI);
            }
            GLFW.glfwSetWindowIcon(this.window, gb);
        }
        GLFW.glfwShowWindow(this.window);
        GLFW.glfwMakeContextCurrent(this.window);
        GL.createCapabilities();
        Display.setWindow(this);
        Method createKeyboard = null;
        Method createMouse = null;
        try {
            createKeyboard = Keyboard.class.getDeclaredMethod("create", InputImplementation.class);
            createKeyboard.setAccessible(true);
            createMouse = Mouse.class.getDeclaredMethod("create", InputImplementation.class);
            createMouse.setAccessible(true);
            GLFWKeyboardImplementation keyboardImplementation = new GLFWKeyboardImplementation();
            GLFWMouseImplementation mouseImplementation = new GLFWMouseImplementation();
            CombinedInputImplementation inputImplementation = new CombinedInputImplementation(keyboardImplementation, mouseImplementation);
            createKeyboard.invoke(null, inputImplementation);
            createMouse.invoke(null, inputImplementation);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        this.setVsync((Boolean)this.mc.gameSettings.enableVsync.value);
    }

    @Override
    public void toggleFullscreen() {
        this.mc.gameSettings.fullscreen.value = (Boolean)this.mc.gameSettings.fullscreen.value == false;
        this.updateWindowState();
    }

    @Override
    public void updateWindowState() {
        if (!this.isFullscreen) {
            int[] x = new int[1];
            int[] y = new int[1];
            GLFW.glfwGetWindowPos(this.window, x, y);
            int[] w = new int[1];
            int[] h = new int[1];
            GLFW.glfwGetWindowSize(this.window, w, h);
            this.windowPosX = x[0];
            this.windowPosY = y[0];
            this.windowWidth = w[0];
            this.windowHeight = h[0];
        }
        boolean fullscreen = (Boolean)this.mc.gameSettings.fullscreen.value;
        boolean borderless = (Boolean)this.mc.gameSettings.borderlessFullscreen.value;
        GLFW.glfwHideWindow(this.window);
        if (fullscreen && !borderless) {
            System.out.println("Change to Fullscreen");
            int x = this.windowPosX + this.windowWidth / 2;
            int y = this.windowPosY + this.windowHeight / 2;
            MonitorInfo monitor = this.getMonitorAt(x, y);
            GLFW.glfwSetWindowMonitor(this.window, monitor.handle, monitor.posX, monitor.posY, monitor.widthScreenCoords, monitor.heightScreenCoords, monitor.refreshRate);
            this.isFullscreen = true;
        } else {
            GLFW.glfwSetWindowMonitor(this.window, 0L, this.windowPosX, this.windowPosY, this.windowWidth, this.windowHeight, 0);
            if (fullscreen && borderless) {
                System.out.println("Change to Borderless Fullscreen");
                int x = this.windowPosX + this.windowWidth / 2;
                int y = this.windowPosY + this.windowHeight / 2;
                MonitorInfo monitor = this.getMonitorAt(x, y);
                GLFW.glfwSetWindowAttrib(this.window, 131077, 0);
                GLFW.glfwSetWindowPos(this.window, monitor.posX, monitor.posY);
                GLFW.glfwSetWindowSize(this.window, monitor.widthScreenCoords, monitor.heightScreenCoords);
                this.isFullscreen = true;
            } else {
                System.out.println("Change to Windowed");
                GLFW.glfwSetWindowAttrib(this.window, 131077, 1);
                this.isFullscreen = false;
            }
        }
        GLFW.glfwShowWindow(this.window);
    }

    public MonitorInfo getMonitorAt(int x, int y) {
        PointerBuffer monitorPointers = GLFW.glfwGetMonitors();
        for (int i = monitorPointers.position(); i < monitorPointers.limit(); ++i) {
            long monitor = monitorPointers.get(i);
            MonitorInfo info = new MonitorInfo(monitor);
            if (x < info.posX || y < info.posY || x >= info.posX + info.widthScreenCoords || y >= info.posY + info.heightScreenCoords) continue;
            return info;
        }
        return new MonitorInfo(GLFW.glfwGetPrimaryMonitor());
    }

    @Override
    public void displayCrashReport(UnexpectedThrowable unexpectedThrowable, int cause) {
        JFrame frame = new JFrame();
        PanelCrashReport panel = new PanelCrashReport(this.mc, unexpectedThrowable, cause);
        panel.setPreferredSize(new Dimension(1280, 720));
        frame.add(panel);
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setDefaultCloseOperation(2);
        frame.setVisible(true);
    }

    @Override
    public int getFrequency() {
        GLFWVidMode vidMode = GLFW.glfwGetVideoMode(this.window);
        if (vidMode != null) {
            return vidMode.refreshRate();
        }
        int x = this.windowPosX + this.windowWidth / 2;
        int y = this.windowPosY + this.windowHeight / 2;
        MonitorInfo monitor = this.getMonitorAt(x, y);
        return monitor.refreshRate;
    }

    @Override
    public void update() {
        GLFW.glfwPollEvents();
        Keyboard.poll();
        Mouse.poll();
        GLFW.glfwSwapBuffers(this.window);
    }

    @Override
    public boolean shouldClose() {
        return GLFW.glfwWindowShouldClose(this.window);
    }

    @Override
    public int getWidthScreenCoords() {
        return this.widthScreenCoords;
    }

    @Override
    public int getHeightScreenCoords() {
        return this.heightScreenCoords;
    }

    @Override
    public int getWidthPixels() {
        return this.widthPixels;
    }

    @Override
    public int getHeightPixels() {
        return this.heightPixels;
    }

    @Override
    public boolean isFocused() {
        return this.hasFocus;
    }

    @Override
    public boolean wasResized() {
        if (this.wasResized) {
            this.wasResized = false;
            return true;
        }
        return false;
    }

    @Override
    public void setVsync(boolean vsync) {
        if (vsync) {
            GLFW.glfwSwapInterval(1);
        } else {
            GLFW.glfwSwapInterval(0);
        }
    }

    public static ByteBuffer getImageBuffer(String resource) {
        try {
            BufferedImage image = ImageIO.read(GameWindowGLFW.class.getResourceAsStream(resource));
            ByteBuffer buf = BufferUtils.createByteBuffer(image.getWidth() * image.getHeight() * 4);
            int index = 0;
            for (int y = 0; y < image.getHeight(); ++y) {
                for (int x = 0; x < image.getWidth(); ++x) {
                    int color = image.getRGB(x, y);
                    buf.put(index + 0, (byte)Color.redFromInt(color));
                    buf.put(index + 1, (byte)Color.greenFromInt(color));
                    buf.put(index + 2, (byte)Color.blueFromInt(color));
                    buf.put(index + 3, (byte)Color.alphaFromInt(color));
                    index += 4;
                }
            }
            buf.flip();
            return buf;
        }
        catch (Exception e) {
            System.out.println("Couldn't open icon image...");
            e.printStackTrace();
            return null;
        }
    }

    public static class MonitorInfo {
        public final long handle;
        public final int posX;
        public final int posY;
        public final int widthScreenCoords;
        public final int heightScreenCoords;
        public final int refreshRate;

        public MonitorInfo(long monitor) {
            this.handle = monitor;
            GLFWVidMode vidmode = GLFW.glfwGetVideoMode(monitor);
            int[] x = new int[1];
            int[] y = new int[1];
            GLFW.glfwGetMonitorPos(monitor, x, y);
            this.posX = x[0];
            this.posY = y[0];
            this.widthScreenCoords = vidmode.width();
            this.heightScreenCoords = vidmode.height();
            this.refreshRate = vidmode.refreshRate();
        }
    }
}

