/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.VeryRotatableEntityBlock;
import net.minecraft.core.block.entity.BlockEntity;
import net.minecraft.core.block.entity.DispenserBlockEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.ItemEntity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.entity.projectile.ArrowProjectile;
import net.minecraft.core.entity.projectile.CannonballProjectile;
import net.minecraft.core.entity.projectile.GoldenArrowProjectile;
import net.minecraft.core.item.IDispensable;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;

public class DispenserBlock
extends VeryRotatableEntityBlock {
    public static final int MASK_POWERED = 8;

    public DispenserBlock(String key, String namespaceId, int id) {
        super(key, namespaceId, id, Material.stone);
    }

    @Override
    public int tickDelay() {
        return 4;
    }

    @Override
    public boolean onBlockRightClicked(World world, int x, int y, int z, Player player, Side side, double xPlaced, double yPlaced) {
        if (world.isClientSide) {
            return true;
        }
        DispenserBlockEntity dispenserBlockEntity = (DispenserBlockEntity)world.getBlockEntity(x, y, z);
        player.displayDispenserScreen(dispenserBlockEntity);
        return true;
    }

    private void dispenseItem(World world, int x, int y, int z, Random random) {
        Direction direction = VeryRotatableEntityBlock.metaToDirection(world.getBlockMetadata(x, y, z));
        int xOffset = direction.getOffsetX();
        int yOffset = direction.getOffsetX();
        int zOffset = direction.getOffsetZ();
        DispenserBlockEntity tileEntity = (DispenserBlockEntity)world.getBlockEntity(x, y, z);
        ItemStack itemStack = tileEntity.getRandomStackFromInventory();
        double px = (double)x + (double)xOffset * 0.6 + 0.5;
        double py = (double)y + (double)yOffset * 0.6 + 0.5;
        double pz = (double)z + (double)zOffset * 0.6 + 0.5;
        if (itemStack == null) {
            world.playBlockEvent(1001, x, y, z, 0);
        } else {
            if (itemStack.getItem() instanceof IDispensable) {
                IDispensable dispensable = (IDispensable)((Object)itemStack.getItem());
                dispensable.onDispensed(itemStack, world, px, py, pz, xOffset, yOffset, zOffset, random);
                world.playBlockEvent(1002, x, y, z, 0);
            } else if (itemStack.itemID == Items.AMMO_ARROW.id || itemStack.itemID == Items.AMMO_ARROW_GOLD.id) {
                ArrowProjectile arrow = itemStack.itemID == Items.AMMO_ARROW.id ? new ArrowProjectile(world, px, py, pz, 0) : new GoldenArrowProjectile(world, px, py, pz);
                arrow.setHeading(xOffset, (double)yOffset + 0.1, zOffset, 1.1f, 6.0f);
                arrow.setDoesArrowBelongToPlayer(true);
                world.entityJoinedWorld(arrow);
                world.playBlockEvent(1002, x, y, z, 0);
            } else if (itemStack.itemID == Items.AMMO_CHARGE_EXPLOSIVE.id) {
                CannonballProjectile cannonballProjectile = new CannonballProjectile(world, px, py, pz);
                cannonballProjectile.setHeading(xOffset, (double)yOffset + 0.1, zOffset, 1.1f, 6.0f);
                world.entityJoinedWorld(cannonballProjectile);
                world.playBlockEvent(1002, x, y, z, 0);
            } else {
                ItemEntity item = new ItemEntity(world, px, py - 0.3, pz, itemStack);
                double randOffset = random.nextDouble() * 0.1 + 0.2;
                item.xd = (double)xOffset * randOffset;
                item.yd = (double)yOffset + 0.2;
                item.zd = (double)zOffset * randOffset;
                item.xd += random.nextGaussian() * 0.0075 * 6.0;
                item.yd += random.nextGaussian() * 0.0075 * 6.0;
                item.zd += random.nextGaussian() * 0.0075 * 6.0;
                world.entityJoinedWorld(item);
                world.playBlockEvent(1000, x, y, z, 0);
            }
            world.playBlockEvent(2000, x, y, z, xOffset + 1 + (zOffset + 1) * 3);
        }
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        boolean flag = world.hasNeighborSignal(x, y, z) || world.hasNeighborSignal(x, y + 1, z);
        int meta = world.getBlockMetadata(x, y, z);
        if (flag && (meta & 8) == 0) {
            world.scheduleBlockUpdate(x, y, z, this.id, this.tickDelay());
            world.setBlockMetadata(x, y, z, meta | 8);
        } else if (!flag) {
            world.setBlockMetadata(x, y, z, meta & 0xFFFFFFF7);
        }
    }

    @Override
    public void updateTick(World world, int x, int y, int z, Random rand) {
        if (world.hasNeighborSignal(x, y, z) || world.hasNeighborSignal(x, y + 1, z)) {
            this.dispenseItem(world, x, y, z, rand);
        }
    }

    @Override
    protected BlockEntity getNewBlockEntity() {
        return new DispenserBlockEntity();
    }
}

