/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.IPaintable;
import net.minecraft.core.block.entity.ActivatorBlockEntity;
import net.minecraft.core.block.entity.BlockEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.tag.ItemTags;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.util.phys.HitResult;
import net.minecraft.core.util.phys.Vec3;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DoorBlock
extends Block
implements IPaintable {
    public static final int MASK_ROTATION = 3;
    public static final int MASK_OPENED = 4;
    public static final int MASK_HINGE = 8;
    public final boolean isTop;
    public final boolean requireTool;
    @Nullable
    public final Supplier<Item> droppedItem;

    public DoorBlock(String key, String namespaceId, int id, Material material, boolean isTop, boolean requireTool, @Nullable Supplier<Item> droppedItem) {
        super(key, namespaceId, id, material);
        this.isTop = isTop;
        this.requireTool = requireTool;
        this.droppedItem = droppedItem;
        float f = 0.5f;
        if (isTop) {
            this.setBlockBounds(0.5f - f, -1.0, 0.5f - f, 0.5f + f, 1.0, 0.5f + f);
        } else {
            this.setBlockBounds(0.5f - f, 0.0, 0.5f - f, 0.5f + f, 2.0, 0.5f + f);
        }
    }

    @Override
    public void onBlockPlacedOnSide(World world, int x, int y, int z, @NotNull Side side, double xPlaced, double yPlaced) {
        super.onBlockPlacedOnSide(world, x, y, z, side, xPlaced, yPlaced);
        int meta = world.getBlockMetadata(x, y, z);
        if (world.hasNeighborSignal(x, y, z)) {
            world.setBlockMetadataWithNotify(x, y, z, meta | 4);
            if (this.isTop) {
                world.setBlockMetadataWithNotify(x, y - 1, z, meta | 4);
            } else {
                world.setBlockMetadataWithNotify(x, y + 1, z, meta | 4);
            }
        }
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    public AABB getSelectedBoundingBoxFromPool(WorldSource world, int x, int y, int z) {
        this.setBoundsForRotation(this.getRotation(world.getBlockMetadata(x, y, z)), true);
        return super.getSelectedBoundingBoxFromPool(world, x, y, z);
    }

    @Override
    public AABB getCollisionBoundingBoxFromPool(WorldSource world, int x, int y, int z) {
        this.setBlockBoundsBasedOnState(world, x, y, z);
        return super.getCollisionBoundingBoxFromPool(world, x, y, z);
    }

    @Override
    public void setBlockBoundsBasedOnState(WorldSource world, int x, int y, int z) {
        this.setBoundsForRotation(this.getRotation(world.getBlockMetadata(x, y, z)), false);
    }

    public void setBoundsForRotation(int rotation, boolean drawingSelection) {
        float top = 1.0f;
        float bottom = 0.0f;
        if (this.isTop && drawingSelection) {
            top = 1.0f;
            bottom = -1.0f;
        } else if (drawingSelection) {
            top = 2.0f;
            bottom = 0.0f;
        }
        float f = 0.1875f;
        this.setBlockBounds(0.0, bottom, 0.0, 1.0, top, 1.0);
        if (rotation == 0) {
            this.setBlockBounds(0.0, bottom, 0.0, 1.0, top, f);
        }
        if (rotation == 1) {
            this.setBlockBounds(1.0f - f, bottom, 0.0, 1.0, top, 1.0);
        }
        if (rotation == 2) {
            this.setBlockBounds(0.0, bottom, 1.0f - f, 1.0, top, 1.0);
        }
        if (rotation == 3) {
            this.setBlockBounds(0.0, bottom, 0.0, f, top, 1.0);
        }
    }

    @Override
    public void onBlockLeftClicked(World world, int x, int y, int z, Player player, Side side, double xHit, double yHit) {
        if (!Item.hasTag(player.getCurrentEquippedItem(), ItemTags.PREVENT_LEFT_CLICK_INTERACTIONS)) {
            this.onBlockRightClicked(world, x, y, z, player, side, xHit, yHit);
        }
    }

    @Override
    public boolean onBlockRightClicked(World world, int x, int y, int z, @Nullable Player player, Side side, double xPlaced, double yPlaced) {
        if (this.blockMaterial == Material.metal || this.blockMaterial == Material.steel) {
            return false;
        }
        int l = world.getBlockMetadata(x, y, z);
        if (this.isTop) {
            if (Block.blocksList[world.getBlockId(x, y - 1, z)] instanceof DoorBlock) {
                Block.blocksList[world.getBlockId(x, y - 1, z)].onBlockRightClicked(world, x, y - 1, z, player, side, xPlaced, yPlaced);
            }
            return true;
        }
        if (Block.blocksList[world.getBlockId(x, y + 1, z)] instanceof DoorBlock) {
            world.setBlockMetadataWithNotify(x, y + 1, z, l ^ 4);
        }
        world.setBlockMetadataWithNotify(x, y, z, l ^ 4);
        world.markBlocksDirty(x, y - 1, z, x, y, z);
        world.playBlockEvent(player, 1003, x, y, z, 0);
        return true;
    }

    @Override
    public void onActivatorInteract(World world, int x, int y, int z, ActivatorBlockEntity activator, Direction direction) {
        this.onBlockRightClicked(world, x, y, z, null, direction.getSide(), 0.5, 0.5);
    }

    public void onPoweredBlockChange(World world, int x, int y, int z, boolean isPowered) {
        boolean isOpen;
        int meta = world.getBlockMetadata(x, y, z);
        if ((meta & 8) > 0) {
            boolean bl = isPowered = !isPowered;
        }
        if (this.isTop) {
            if (Block.blocksList[world.getBlockId(x, y - 1, z)] instanceof DoorBlock) {
                ((DoorBlock)Block.blocksList[world.getBlockId(x, y - 1, z)]).onPoweredBlockChange(world, x, y - 1, z, isPowered);
            }
            return;
        }
        boolean bl = isOpen = (world.getBlockMetadata(x, y, z) & 4) > 0;
        if (isOpen == isPowered) {
            return;
        }
        if (Block.blocksList[world.getBlockId(x, y + 1, z)] instanceof DoorBlock) {
            world.setBlockMetadataWithNotify(x, y + 1, z, meta ^ 4);
        }
        world.setBlockMetadataWithNotify(x, y, z, meta ^ 4);
        world.markBlocksDirty(x, y - 1, z, x, y, z);
        world.playBlockEvent(null, 1003, x, y, z, 0);
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        int i1 = world.getBlockMetadata(x, y, z);
        if (this.isTop) {
            Block otherBlock = Block.blocksList[world.getBlockId(x, y - 1, z)];
            if (!(otherBlock instanceof DoorBlock)) {
                world.setBlockWithNotify(x, y, z, 0);
            }
            if (blockId > 0 && Block.blocksList[blockId].isSignalSource()) {
                otherBlock.onNeighborBlockChange(world, x, y - 1, z, blockId);
            }
        } else {
            boolean flag = false;
            Block otherBlock = Block.blocksList[world.getBlockId(x, y + 1, z)];
            if (!(otherBlock instanceof DoorBlock)) {
                world.setBlockWithNotify(x, y, z, 0);
                flag = true;
            }
            if (!world.canPlaceOnSurfaceOfBlock(x, y - 1, z)) {
                this.dropBlockWithCause(world, EnumDropCause.WORLD, x, y, z, world.getBlockMetadata(x, y, z), null, null);
                world.setBlockWithNotify(x, y, z, 0);
                flag = true;
                if (otherBlock instanceof DoorBlock) {
                    world.setBlockWithNotify(x, y + 1, z, 0);
                }
            }
            if (flag) {
                if (!world.isClientSide) {
                    // empty if block
                }
            } else if (blockId > 0 && Block.blocksList[blockId].isSignalSource()) {
                boolean flag1 = world.hasNeighborSignal(x, y, z) || world.hasNeighborSignal(x, y + 1, z);
                this.onPoweredBlockChange(world, x, y, z, flag1);
            }
        }
    }

    @Override
    public void animationTick(World world, int x, int y, int z, Random rand) {
        int myId = world.getBlockId(x, y, z);
        int myMetadata = world.getBlockMetadata(x, y, z);
        int upId = world.getBlockId(x, y + 1, z);
        if (myId == Blocks.DOOR_PLANKS_OAK_BOTTOM.id && upId == Blocks.DOOR_PLANKS_OAK_BOTTOM.id) {
            world.setBlockAndMetadata(x, y + 1, z, Blocks.DOOR_PLANKS_OAK_TOP.id, myMetadata);
        } else if (myId == Blocks.DOOR_IRON_BOTTOM.id && upId == Blocks.DOOR_IRON_BOTTOM.id) {
            world.setBlockAndMetadata(x, y + 1, z, Blocks.DOOR_IRON_TOP.id, myMetadata);
        }
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int meta, BlockEntity blockEntity) {
        if (this.droppedItem == null) {
            return null;
        }
        if (this.requireTool && dropCause != EnumDropCause.IMPROPER_TOOL) {
            return new ItemStack[]{new ItemStack(this.droppedItem.get())};
        }
        if (!this.requireTool) {
            return new ItemStack[]{new ItemStack(this.droppedItem.get())};
        }
        return null;
    }

    @Override
    public HitResult collisionRayTrace(World world, int x, int y, int z, Vec3 start, Vec3 end) {
        this.setBlockBoundsBasedOnState(world, x, y, z);
        return super.collisionRayTrace(world, x, y, z, start, end);
    }

    public int getRotation(int i) {
        if ((i & 4) != 0) {
            return i & 3;
        }
        return i - 1 & 3;
    }

    public static boolean isOpen(int i) {
        boolean hasRightHinge = (i & 8) != 0;
        boolean opened = (i & 4) != 0;
        return !hasRightHinge && opened || hasRightHinge && !opened;
    }

    @Override
    public boolean canPlaceBlockAt(World world, int x, int y, int z) {
        if (y >= world.getHeightBlocks() - 1) {
            return false;
        }
        return world.canPlaceOnSurfaceOfBlock(x, y - 1, z) && super.canPlaceBlockAt(world, x, y, z) && super.canPlaceBlockAt(world, x, y + 1, z);
    }

    @Override
    public int getPistonPushReaction(World world, int x, int y, int z) {
        return 1;
    }

    @Override
    public void setColor(World world, int x, int y, int z, DyeColor color) {
        int meta = world.getBlockMetadata(x, y, z);
        if (this.isTop) {
            world.setBlockAndMetadata(x, y, z, Blocks.DOOR_PLANKS_PAINTED_TOP.id, meta);
            ((IPaintable)((Object)Blocks.DOOR_PLANKS_PAINTED_TOP)).setColor(world, x, y, z, color);
            world.setBlockAndMetadata(x, y - 1, z, Blocks.DOOR_PLANKS_PAINTED_BOTTOM.id, meta);
            ((IPaintable)((Object)Blocks.DOOR_PLANKS_PAINTED_BOTTOM)).setColor(world, x, y - 1, z, color);
        } else {
            world.setBlockAndMetadata(x, y, z, Blocks.DOOR_PLANKS_PAINTED_BOTTOM.id, meta);
            ((IPaintable)((Object)Blocks.DOOR_PLANKS_PAINTED_BOTTOM)).setColor(world, x, y, z, color);
            world.setBlockAndMetadata(x, y + 1, z, Blocks.DOOR_PLANKS_PAINTED_TOP.id, meta);
            ((IPaintable)((Object)Blocks.DOOR_PLANKS_PAINTED_TOP)).setColor(world, x, y + 1, z, color);
        }
    }
}

