/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.EntityBlock;
import net.minecraft.core.block.entity.BlockEntity;
import net.minecraft.core.block.entity.MobSpawnerBlockEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.ItemEntity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.player.gamemode.Gamemode;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;

public class MobSpawnerBlock
extends EntityBlock {
    public MobSpawnerBlock(String key, String namespaceId, int id) {
        super(key, namespaceId, id, Material.stone);
    }

    @Override
    public boolean onBlockRightClicked(World world, int x, int y, int z, Player player, Side side, double xPlaced, double yPlaced) {
        if (player.getGamemode() != Gamemode.creative) {
            return false;
        }
        player.displayMobPickerScreen(x, y, z);
        return true;
    }

    @Override
    public BlockEntity getNewBlockEntity() {
        return new MobSpawnerBlockEntity();
    }

    @Override
    public void onBlockPlacedOnSide(World world, int x, int y, int z, @NotNull Side side, double xPlaced, double yPlaced) {
        MobSpawnerBlockEntity tileEntity = (MobSpawnerBlockEntity)world.getBlockEntity(x, y, z);
        tileEntity.setMobId("none");
    }

    @Override
    public boolean collidesWithEntity(Entity entity, World world, int x, int y, int z) {
        return !(entity instanceof ItemEntity);
    }

    @Override
    public void onBlockRemoved(World world, int x, int y, int z, int data) {
        if (!world.isClientSide) {
            MobSpawnerBlockEntity tileEntityMobSpawner = (MobSpawnerBlockEntity)world.getBlockEntity(x, y, z);
            if (tileEntityMobSpawner == null) {
                return;
            }
            int amountToDrop = world.rand.nextInt(10) + 10;
            for (int l = 0; l < amountToDrop; ++l) {
                ItemStack itemstack;
                String mobInSpawner = tileEntityMobSpawner.getMobId();
                if (mobInSpawner == null) continue;
                switch (mobInSpawner) {
                    case "Zombie": {
                        itemstack = new ItemStack(Items.CLOTH);
                        break;
                    }
                    case "Skeleton": {
                        if (world.rand.nextInt(2) == 0) {
                            itemstack = new ItemStack(Items.BONE);
                            break;
                        }
                        itemstack = new ItemStack(Items.AMMO_ARROW);
                        break;
                    }
                    case "ArmouredZombie": {
                        itemstack = new ItemStack(Items.CHAINLINK);
                        break;
                    }
                    case "Spider": {
                        itemstack = new ItemStack(Items.STRING);
                        break;
                    }
                    case "Snowman": {
                        itemstack = new ItemStack(Items.AMMO_SNOWBALL);
                        break;
                    }
                    default: {
                        itemstack = null;
                    }
                }
                if (itemstack == null) continue;
                float f = world.rand.nextFloat() * 0.8f + 0.1f;
                float f1 = world.rand.nextFloat() * 0.8f + 0.1f;
                float f2 = world.rand.nextFloat() * 0.8f + 0.1f;
                while (itemstack.stackSize > 0) {
                    int i1 = world.rand.nextInt(21) + 10;
                    if (i1 > itemstack.stackSize) {
                        i1 = itemstack.stackSize;
                    }
                    itemstack.stackSize -= i1;
                    ItemEntity entityitem = new ItemEntity(world, (float)x + f, (float)y + f1, (float)z + f2, new ItemStack(itemstack.itemID, i1, itemstack.getMetadata()));
                    float f3 = 0.05f;
                    entityitem.xd = (float)world.rand.nextGaussian() * f3;
                    entityitem.yd = (float)world.rand.nextGaussian() * f3 + 0.2f;
                    entityitem.zd = (float)world.rand.nextGaussian() * f3;
                    world.entityJoinedWorld(entityitem);
                }
            }
        }
        super.onBlockRemoved(world, x, y, z, data);
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int meta, BlockEntity blockEntity) {
        if (dropCause == EnumDropCause.SILK_TOUCH) {
            return new ItemStack[]{new ItemStack(Blocks.MOBSPAWNER_DEACTIVATED)};
        }
        return null;
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }
}

