/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.World;

public class PumiceBlock
extends Block {
    final boolean isWet;

    public PumiceBlock(String key, String namespaceId, int id, boolean isWet) {
        super(key, namespaceId, id, Material.stone);
        this.isWet = isWet;
    }

    @Override
    public void onBlockPlacedByWorld(World world, int x, int y, int z) {
        super.onBlockPlacedByWorld(world, x, y, z);
        int radius = 2;
        if (this.isWet && (this.inWater(world, x, y, z) || world.dimension.id == Dimension.PARADISE.id)) {
            world.setBlockWithNotify(x, y, z, Blocks.PUMICE_DRY.id);
            world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.fizz", 0.5f, 2.6f + (world.rand.nextFloat() - world.rand.nextFloat()) * 0.8f);
            for (int l = 0; l < 8; ++l) {
                world.spawnParticle("largesmoke", (double)x + Math.random(), (double)y + Math.random(), (double)z + Math.random(), 0.0, 0.0, 0.0, 0);
            }
        }
        if (!this.isWet && this.inLava(world, x, y, z)) {
            for (int _x = x - radius; _x <= x + radius; ++_x) {
                for (int _y = y - radius; _y <= y + radius; ++_y) {
                    for (int _z = z - radius; _z <= z + radius; ++_z) {
                        if (!Block.hasTag(world.getBlockId(_x, _y, _z), BlockTags.IS_LAVA)) continue;
                        world.setBlockWithNotify(_x, _y, _z, 0);
                    }
                }
            }
            world.setBlockWithNotify(x, y, z, Blocks.PUMICE_WET.id);
        }
    }

    public boolean inLava(World world, int x, int y, int z) {
        if (Block.hasTag(world.getBlockId(x + 1, y, z), BlockTags.IS_LAVA)) {
            return true;
        }
        if (Block.hasTag(world.getBlockId(x - 1, y, z), BlockTags.IS_LAVA)) {
            return true;
        }
        if (Block.hasTag(world.getBlockId(x, y + 1, z), BlockTags.IS_LAVA)) {
            return true;
        }
        if (Block.hasTag(world.getBlockId(x, y - 1, z), BlockTags.IS_LAVA)) {
            return true;
        }
        if (Block.hasTag(world.getBlockId(x, y, z + 1), BlockTags.IS_LAVA)) {
            return true;
        }
        return Block.hasTag(world.getBlockId(x, y, z - 1), BlockTags.IS_LAVA);
    }

    public boolean inWater(World world, int x, int y, int z) {
        if (Block.hasTag(world.getBlockId(x + 1, y, z), BlockTags.IS_WATER)) {
            return true;
        }
        if (Block.hasTag(world.getBlockId(x - 1, y, z), BlockTags.IS_WATER)) {
            return true;
        }
        if (Block.hasTag(world.getBlockId(x, y + 1, z), BlockTags.IS_WATER)) {
            return true;
        }
        if (Block.hasTag(world.getBlockId(x, y - 1, z), BlockTags.IS_WATER)) {
            return true;
        }
        if (Block.hasTag(world.getBlockId(x, y, z + 1), BlockTags.IS_WATER)) {
            return true;
        }
        return Block.hasTag(world.getBlockId(x, y, z - 1), BlockTags.IS_WATER);
    }

    @Override
    public void onBlockRemoved(World world, int x, int y, int z, int data) {
        if (!this.isWet) {
            int radius = 2;
            for (int _x = x - radius; _x <= x + radius; ++_x) {
                for (int _y = y - radius; _y <= y + radius; ++_y) {
                    for (int _z = z - radius; _z <= z + radius; ++_z) {
                        world.notifyBlocksOfNeighborChange(_x, _y, _z, world.getBlockId(_x, _y, _z));
                    }
                }
            }
        }
    }

    @Override
    public void animationTick(World world, int x, int y, int z, Random rand) {
        if (this.isWet) {
            Side side = Side.sides[rand.nextInt(6)];
            if (side == Side.TOP || world.isBlockOpaqueCube(x + side.getOffsetX(), y + side.getOffsetY(), z + side.getOffsetZ())) {
                return;
            }
            float off1 = rand.nextFloat() * 0.9f + 0.05f;
            float off2 = rand.nextFloat() * 0.9f + 0.05f;
            switch (side) {
                case BOTTOM: {
                    world.spawnParticle("dripLava", (float)x + off1, y, (float)z + off2, 0.0, 0.0, 0.0, 0);
                    break;
                }
                case NORTH: {
                    world.spawnParticle("dripLava", (float)x + off1, (float)y + off2, z, 0.0, 0.0, 0.0, 0);
                    break;
                }
                case SOUTH: {
                    world.spawnParticle("dripLava", (float)x + off1, (float)y + off2, z + 1, 0.0, 0.0, 0.0, 0);
                    break;
                }
                case WEST: {
                    world.spawnParticle("dripLava", x, (float)y + off1, (float)z + off2, 0.0, 0.0, 0.0, 0);
                    break;
                }
                case EAST: {
                    world.spawnParticle("dripLava", x + 1, (float)y + off1, (float)z + off2, 0.0, 0.0, 0.0, 0);
                }
            }
        }
    }
}

