/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.RotatableBlock;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;

public class RedstonePumpkinBlock
extends RotatableBlock {
    public RedstonePumpkinBlock(String translationKey, String namespaceId, int id) {
        super(translationKey, namespaceId, id, Material.vegetable);
    }

    @Override
    public void onBlockPlacedByWorld(World world, int x, int y, int z) {
        for (Side s : Side.sides) {
            world.notifyBlocksOfNeighborChange(x + s.getOffsetX(), y + s.getOffsetY(), z + s.getOffsetZ(), this.id);
        }
    }

    @Override
    public void onBlockRemoved(World world, int x, int y, int z, int data) {
        for (Side s : Side.sides) {
            world.notifyBlocksOfNeighborChange(x + s.getOffsetX(), y + s.getOffsetY(), z + s.getOffsetZ(), this.id);
        }
    }

    @Override
    public boolean getDirectSignal(World world, int x, int y, int z, Side side) {
        return this.getSignal(world, x, y, z, side.getOpposite());
    }

    @Override
    public boolean getSignal(WorldSource worldSource, int x, int y, int z, Side side) {
        if (!side.isHorizontal()) {
            return false;
        }
        Side mySide = Side.getSideById(worldSource.getBlockMetadata(x, y, z));
        return mySide == side.getOpposite();
    }

    @Override
    public int getPistonPushReaction(World world, int x, int y, int z) {
        return 0;
    }
}

