/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.World;

public class SpongeBlock
extends Block {
    final boolean isWet;

    public SpongeBlock(String key, String namespaceId, int id, boolean isWet) {
        super(key, namespaceId, id, Material.sponge);
        this.isWet = isWet;
    }

    @Override
    public void onBlockPlacedByWorld(World world, int x, int y, int z) {
        int l;
        super.onBlockPlacedByWorld(world, x, y, z);
        int byte0 = 2;
        if (world.dimension.id == Dimension.NETHER.id && this.isWet) {
            world.setBlockWithNotify(x, y, z, Blocks.SPONGE_DRY.id);
            world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.fizz", 0.5f, 2.6f + (world.rand.nextFloat() - world.rand.nextFloat()) * 0.8f);
            for (l = 0; l < 8; ++l) {
                world.spawnParticle("largesmoke", (double)x + Math.random(), (double)y + Math.random(), (double)z + Math.random(), 0.0, 0.0, 0.0, 0);
            }
        }
        if (!this.isWet && this.inWater(world, x, y, z)) {
            for (l = x - byte0; l <= x + byte0; ++l) {
                for (int i1 = y - byte0; i1 <= y + byte0; ++i1) {
                    for (int j1 = z - byte0; j1 <= z + byte0; ++j1) {
                        if (!Block.hasTag(world.getBlockId(l, i1, j1), BlockTags.IS_WATER)) continue;
                        world.setBlockWithNotify(l, i1, j1, 0);
                    }
                }
            }
            world.setBlockWithNotify(x, y, z, Blocks.SPONGE_WET.id);
        }
    }

    public boolean inWater(World world, int x, int y, int z) {
        if (Block.hasTag(world.getBlockId(x + 1, y, z), BlockTags.IS_WATER)) {
            return true;
        }
        if (Block.hasTag(world.getBlockId(x - 1, y, z), BlockTags.IS_WATER)) {
            return true;
        }
        if (Block.hasTag(world.getBlockId(x, y + 1, z), BlockTags.IS_WATER)) {
            return true;
        }
        if (Block.hasTag(world.getBlockId(x, y - 1, z), BlockTags.IS_WATER)) {
            return true;
        }
        if (Block.hasTag(world.getBlockId(x, y, z + 1), BlockTags.IS_WATER)) {
            return true;
        }
        return Block.hasTag(world.getBlockId(x, y, z - 1), BlockTags.IS_WATER);
    }

    @Override
    public void onBlockRemoved(World world, int x, int y, int z, int data) {
        if (!this.isWet) {
            int byte0 = 2;
            for (int l = x - byte0; l <= x + byte0; ++l) {
                for (int i1 = y - byte0; i1 <= y + byte0; ++i1) {
                    for (int j1 = z - byte0; j1 <= z + byte0; ++j1) {
                        world.notifyBlocksOfNeighborChange(l, i1, j1, world.getBlockId(l, i1, j1));
                    }
                }
            }
        }
    }

    @Override
    public void animationTick(World world, int x, int y, int z, Random rand) {
        if (this.isWet) {
            Side side = Side.sides[rand.nextInt(6)];
            if (side == Side.TOP || world.isBlockOpaqueCube(x + side.getOffsetX(), y + side.getOffsetY(), z + side.getOffsetZ())) {
                return;
            }
            float off1 = rand.nextFloat() * 0.9f + 0.05f;
            float off2 = rand.nextFloat() * 0.9f + 0.05f;
            float lOff = 0.1f;
            switch (side) {
                case BOTTOM: {
                    world.spawnParticle("dripWater", (float)x + off1, (float)y - lOff, (float)z + off2, 0.0, 0.0, 0.0, 0);
                    break;
                }
                case NORTH: {
                    world.spawnParticle("dripWater", (float)x + off1, (float)y + off2, (float)z - lOff, 0.0, 0.0, 0.0, 0);
                    break;
                }
                case SOUTH: {
                    world.spawnParticle("dripWater", (float)x + off1, (float)y + off2, (float)(z + 1) + lOff, 0.0, 0.0, 0.0, 0);
                    break;
                }
                case WEST: {
                    world.spawnParticle("dripWater", (float)x - lOff, (float)y + off1, (float)z + off2, 0.0, 0.0, 0.0, 0);
                    break;
                }
                case EAST: {
                    world.spawnParticle("dripWater", (float)(x + 1) + lOff, (float)y + off1, (float)z + off2, 0.0, 0.0, 0.0, 0);
                }
            }
        }
    }
}

