/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.achievement.Achievements;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.BlockEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.Chunk;

public class StoneBlock
extends Block {
    private final Supplier<Block> cobblestoneSupplier;

    public StoneBlock(String key, String namespaceId, int id, Supplier<Block> cobbleStoneSupplier, Material material) {
        super(key, namespaceId, id, material);
        this.cobblestoneSupplier = cobbleStoneSupplier;
    }

    @Override
    public void harvestBlock(World world, Player player, int x, int y, int z, int meta, BlockEntity blockEntity) {
        super.harvestBlock(world, player, x, y, z, meta, blockEntity);
        if (player.getStat(Blocks.STONE.getStat("stat_mined")) > 0 && player.getStat(Blocks.BASALT.getStat("stat_mined")) > 0 && player.getStat(Blocks.GRANITE.getStat("stat_mined")) > 0 && player.getStat(Blocks.LIMESTONE.getStat("stat_mined")) > 0 && player.getStat(Blocks.PERMAFROST.getStat("stat_mined")) > 0) {
            player.triggerAchievement(Achievements.COLLECT_STONE);
        }
    }

    @Override
    public void animationTick(World world, int x, int y, int z, Random rand) {
        Chunk chunk = world.getChunkFromBlockCoords(x, z);
        if (y <= 32 && chunk.getChunkRandom(987234911L).nextInt(10) == 0 && world.getBlockId(x, y - 1, z) == 0 && rand.nextInt(50) == 0) {
            world.spawnParticle("slimechunk", x, y, z, 0.0, 0.0, 0.0, 0);
        }
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int meta, BlockEntity blockEntity) {
        switch (dropCause) {
            case PISTON_CRUSH: 
            case WORLD: 
            case EXPLOSION: 
            case PROPER_TOOL: {
                return new ItemStack[]{new ItemStack(this.cobblestoneSupplier.get())};
            }
            case PICK_BLOCK: 
            case SILK_TOUCH: {
                return new ItemStack[]{new ItemStack(this)};
            }
        }
        return null;
    }
}

