/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block.entity;

import com.mojang.logging.LogUtils;
import com.mojang.nbt.CompoundTag;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.block.entity.ActivatorBlockEntity;
import net.minecraft.core.block.entity.BasketBlockEntity;
import net.minecraft.core.block.entity.BlastFurnaceBlockEntity;
import net.minecraft.core.block.entity.BlockEntity;
import net.minecraft.core.block.entity.ChestBlockEntity;
import net.minecraft.core.block.entity.DispenserBlockEntity;
import net.minecraft.core.block.entity.FlagBlockEntity;
import net.minecraft.core.block.entity.FlowerJarBlockEntity;
import net.minecraft.core.block.entity.FurnaceBlockEntity;
import net.minecraft.core.block.entity.GoldMeshBlockEntity;
import net.minecraft.core.block.entity.JukeboxBlockEntity;
import net.minecraft.core.block.entity.MobSpawnerBlockEntity;
import net.minecraft.core.block.entity.NoteBlockEntity;
import net.minecraft.core.block.entity.SeatBlockEntity;
import net.minecraft.core.block.entity.SensorBlockEntity;
import net.minecraft.core.block.entity.SignBlockEntity;
import net.minecraft.core.block.entity.TrommelBlockEntity;
import net.minecraft.core.block.piston.MovingPistonBlockEntity;
import org.slf4j.Logger;

public class BlockEntityDispatcher {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<String, Class<? extends BlockEntity>> nameToClassMap = new HashMap<String, Class<? extends BlockEntity>>();
    private static final Map<Class<? extends BlockEntity>, String> classToNameMap = new HashMap<Class<? extends BlockEntity>, String>();

    public static void addMapping(Class<? extends BlockEntity> entityClass, String name) {
        if (nameToClassMap.containsKey(name)) {
            throw new IllegalArgumentException("Duplicate id: " + name);
        }
        nameToClassMap.put(name, entityClass);
        classToNameMap.put(entityClass, name);
    }

    public static BlockEntity createAndLoadEntity(CompoundTag nbttagcompound) {
        BlockEntity blockEntity = null;
        Class<? extends BlockEntity> entityClass = nameToClassMap.get(nbttagcompound.getString("id"));
        try {
            if (entityClass != null) {
                blockEntity = entityClass.newInstance();
            }
        }
        catch (Exception exception) {
            LOGGER.error("Exception when instancing class '{}'!", (Object)entityClass.getSimpleName(), (Object)exception);
        }
        if (blockEntity != null) {
            blockEntity.readFromNBT(nbttagcompound);
        } else {
            LOGGER.warn("Skipping BlockEntity with id {}", (Object)nbttagcompound.getString("id"));
        }
        return blockEntity;
    }

    public static Class<? extends BlockEntity> getClassFromID(String id) {
        return nameToClassMap.get(id);
    }

    public static String getIDFromClass(Class<? extends BlockEntity> clazz) {
        return classToNameMap.get(clazz);
    }

    static {
        BlockEntityDispatcher.addMapping(FurnaceBlockEntity.class, "Furnace");
        BlockEntityDispatcher.addMapping(ChestBlockEntity.class, "Chest");
        BlockEntityDispatcher.addMapping(JukeboxBlockEntity.class, "RecordPlayer");
        BlockEntityDispatcher.addMapping(DispenserBlockEntity.class, "Trap");
        BlockEntityDispatcher.addMapping(ActivatorBlockEntity.class, "Activator");
        BlockEntityDispatcher.addMapping(SignBlockEntity.class, "Sign");
        BlockEntityDispatcher.addMapping(MobSpawnerBlockEntity.class, "MobSpawner");
        BlockEntityDispatcher.addMapping(NoteBlockEntity.class, "Music");
        BlockEntityDispatcher.addMapping(MovingPistonBlockEntity.class, "Piston");
        BlockEntityDispatcher.addMapping(BlastFurnaceBlockEntity.class, "BlastFurnace");
        BlockEntityDispatcher.addMapping(SensorBlockEntity.class, "Sensor");
        BlockEntityDispatcher.addMapping(TrommelBlockEntity.class, "Trommel");
        BlockEntityDispatcher.addMapping(BasketBlockEntity.class, "Basket");
        BlockEntityDispatcher.addMapping(FlagBlockEntity.class, "Flag");
        BlockEntityDispatcher.addMapping(SeatBlockEntity.class, "Seat");
        BlockEntityDispatcher.addMapping(FlowerJarBlockEntity.class, "FlowerJar");
        BlockEntityDispatcher.addMapping(GoldMeshBlockEntity.class, "MeshGold");
    }
}

