/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block.entity;

import com.mojang.nbt.CompoundTag;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.StackedFlowerBlock;
import net.minecraft.core.block.entity.BlockEntity;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.net.packet.BlockEntityDataPacket;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.core.world.World;

public class FlowerJarBlockEntity
extends BlockEntity {
    public int flowerInPot;
    public int flowerData;

    @Override
    public void readFromNBT(CompoundTag tag) {
        super.readFromNBT(tag);
        this.flowerInPot = tag.getInteger("PlantedId");
        this.flowerData = Byte.toUnsignedInt(tag.getByteOrDefault("PlantedData", (byte)0));
    }

    @Override
    public void writeToNBT(CompoundTag tag) {
        super.writeToNBT(tag);
        if (this.flowerInPot > 0) {
            tag.putInt("PlantedId", this.flowerInPot);
            tag.putByte("PlantedData", (byte)this.flowerData);
        }
    }

    @Override
    public void dropContents(World world, int x, int y, int z) {
        super.dropContents(world, x, y, z);
        if (this.flowerInPot > 0 && Block.hasTag(this.flowerInPot, BlockTags.PLANTABLE_IN_JAR)) {
            if (!world.isClientSide) {
                if (Block.getBlock(this.flowerInPot) instanceof StackedFlowerBlock) {
                    world.dropItem(x, y, z, new ItemStack(this.flowerInPot, StackedFlowerBlock.getStackCount(this.flowerData) + 1, 0));
                } else {
                    world.dropItem(x, y, z, new ItemStack(this.flowerInPot, 1, this.flowerData));
                }
            }
            this.flowerInPot = 0;
        }
    }

    @Override
    public Packet getDescriptionPacket() {
        return new BlockEntityDataPacket(this);
    }
}

