/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block.piston;

import java.util.ArrayList;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.BlockEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.piston.PistonBaseBlock;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;

public class PistonHeadBlock
extends Block {
    public static final int MASK_DIRECTION = 7;
    public static final int MASK_TYPE = 248;
    public static final int TYPE_NORMAL = 0;
    public static final int TYPE_STICKY = 1;
    public static final int TYPE_STEEL = 2;
    private final double headThickness;

    public PistonHeadBlock(String key, String namespaceId, int id, double headThickness) {
        super(key, namespaceId, id, Material.piston);
        this.withHardness(0.5f);
        this.headThickness = headThickness;
    }

    @Override
    public void onBlockRemoved(World world, int x, int y, int z, int data) {
        int data2;
        int z2;
        int y2;
        super.onBlockRemoved(world, x, y, z, data);
        Direction direction = PistonHeadBlock.getDirectionFromMeta(data);
        if (direction == Direction.NONE) {
            return;
        }
        Direction orientation = direction.getOpposite();
        int x2 = x + orientation.getOffsetX();
        Block block = world.getBlock(x2, y2 = y + orientation.getOffsetY(), z2 = z + orientation.getOffsetZ());
        if (block instanceof PistonBaseBlock && PistonBaseBlock.isPowered(data2 = world.getBlockMetadata(x2, y2, z2))) {
            block.dropBlockWithCause(world, EnumDropCause.PROPER_TOOL, x2, y2, z2, data2, null, null);
            world.setBlockWithNotify(x2, y2, z2, 0);
        }
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    public boolean canPlaceBlockAt(World world, int x, int y, int z) {
        return false;
    }

    @Override
    public boolean canPlaceBlockOnSide(World world, int x, int y, int z, Side side) {
        return false;
    }

    @Override
    public void getCollidingBoundingBoxes(World world, int x, int y, int z, AABB aabb, ArrayList<AABB> aabbList) {
        int l = world.getBlockMetadata(x, y, z);
        switch (PistonHeadBlock.getDirectionFromMeta(l)) {
            case DOWN: {
                this.setBlockBounds(0.0, 0.0, 0.0, 1.0, this.headThickness, 1.0);
                super.getCollidingBoundingBoxes(world, x, y, z, aabb, aabbList);
                this.setBlockBounds(0.375, this.headThickness, 0.375, 0.625, 1.0 + this.headThickness, 0.625);
                super.getCollidingBoundingBoxes(world, x, y, z, aabb, aabbList);
                break;
            }
            case UP: {
                this.setBlockBounds(0.0, 1.0 - this.headThickness, 0.0, 1.0, 1.0, 1.0);
                super.getCollidingBoundingBoxes(world, x, y, z, aabb, aabbList);
                this.setBlockBounds(0.375, -this.headThickness, 0.375, 0.625, 1.0 - this.headThickness, 0.625);
                super.getCollidingBoundingBoxes(world, x, y, z, aabb, aabbList);
                break;
            }
            case NORTH: {
                this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 1.0, this.headThickness);
                super.getCollidingBoundingBoxes(world, x, y, z, aabb, aabbList);
                this.setBlockBounds(this.headThickness, 0.375, this.headThickness, 1.0 - this.headThickness, 0.625, 1.0 + this.headThickness);
                super.getCollidingBoundingBoxes(world, x, y, z, aabb, aabbList);
                break;
            }
            case SOUTH: {
                this.setBlockBounds(0.0, 0.0, 1.0 - this.headThickness, 1.0, 1.0, 1.0);
                super.getCollidingBoundingBoxes(world, x, y, z, aabb, aabbList);
                this.setBlockBounds(this.headThickness, 0.375, -this.headThickness, 1.0 - this.headThickness, 0.625, 1.0 - this.headThickness);
                super.getCollidingBoundingBoxes(world, x, y, z, aabb, aabbList);
                break;
            }
            case WEST: {
                this.setBlockBounds(0.0, 0.0, 0.0, this.headThickness, 1.0, 1.0);
                super.getCollidingBoundingBoxes(world, x, y, z, aabb, aabbList);
                this.setBlockBounds(this.headThickness, 0.375, this.headThickness, 1.0 + this.headThickness, 0.625, 1.0 - this.headThickness);
                super.getCollidingBoundingBoxes(world, x, y, z, aabb, aabbList);
                break;
            }
            case EAST: {
                this.setBlockBounds(1.0 - this.headThickness, 0.0, 0.0, 1.0, 1.0, 1.0);
                super.getCollidingBoundingBoxes(world, x, y, z, aabb, aabbList);
                this.setBlockBounds(-this.headThickness, 0.375, this.headThickness, 1.0 - this.headThickness, 0.625, 1.0 - this.headThickness);
                super.getCollidingBoundingBoxes(world, x, y, z, aabb, aabbList);
            }
        }
        this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    }

    @Override
    public void setBlockBoundsBasedOnState(WorldSource world, int x, int y, int z) {
        int l = world.getBlockMetadata(x, y, z);
        switch (PistonHeadBlock.getDirectionFromMeta(l)) {
            case DOWN: {
                this.setBlockBounds(0.0, 0.0, 0.0, 1.0, this.headThickness, 1.0);
                break;
            }
            case UP: {
                this.setBlockBounds(0.0, 1.0 - this.headThickness, 0.0, 1.0, 1.0, 1.0);
                break;
            }
            case NORTH: {
                this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 1.0, this.headThickness);
                break;
            }
            case SOUTH: {
                this.setBlockBounds(0.0, 0.0, 1.0 - this.headThickness, 1.0, 1.0, 1.0);
                break;
            }
            case WEST: {
                this.setBlockBounds(0.0, 0.0, 0.0, this.headThickness, 1.0, 1.0);
                break;
            }
            case EAST: {
                this.setBlockBounds(1.0 - this.headThickness, 0.0, 0.0, 1.0, 1.0, 1.0);
            }
        }
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        Direction direction = PistonHeadBlock.getDirectionFromMeta(world.getBlockMetadata(x, y, z));
        if (direction == Direction.NONE) {
            return;
        }
        Block block = world.getBlock(x - direction.getOffsetX(), y - direction.getOffsetY(), z - direction.getOffsetZ());
        if (block instanceof PistonBaseBlock) {
            block.onNeighborBlockChange(world, x - direction.getOffsetX(), y - direction.getOffsetY(), z - direction.getOffsetZ(), blockId);
        } else {
            world.setBlockWithNotify(x, y, z, 0);
        }
    }

    @Override
    public int getPistonPushReaction(World world, int x, int y, int z) {
        return 2;
    }

    public static Direction getDirectionFromMeta(int meta) {
        return Direction.getDirectionById(meta & 7);
    }

    public static int getPistonType(int data) {
        return (data & 0xFF & 0xF8) >> 3;
    }

    public static int setPistonType(int type, int data) {
        return (data & 0xFFFFFF07 | type << 3) & 0xFF;
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int meta, BlockEntity blockEntity) {
        if (dropCause == EnumDropCause.PICK_BLOCK) {
            switch (PistonHeadBlock.getPistonType(meta)) {
                case 0: {
                    return new ItemStack[]{new ItemStack(Blocks.PISTON_BASE)};
                }
                case 1: {
                    return new ItemStack[]{new ItemStack(Blocks.PISTON_BASE_STICKY)};
                }
                case 2: {
                    return new ItemStack[]{new ItemStack(Blocks.PISTON_BASE_STEEL)};
                }
            }
        }
        return null;
    }
}

