/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block.piston;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.BlockEntity;
import net.minecraft.core.block.piston.MovingPistonBlock;
import net.minecraft.core.block.piston.MovingPistonBlockEntity;
import net.minecraft.core.block.piston.PistonBaseBlock;
import net.minecraft.core.block.piston.PistonHeadBlock;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.world.World;

public class StickyPistonBaseBlock
extends PistonBaseBlock {
    public StickyPistonBaseBlock(String key, String namespaceId, int id, int maxPushedBlocks) {
        super(key, namespaceId, id, maxPushedBlocks);
    }

    @Override
    public void retractEvent(World world, int x, int y, int z, int data, Direction direction) {
        MovingPistonBlockEntity movingPistonBlock;
        BlockEntity blockEntity1;
        BlockEntity blockEntity = world.getBlockEntity(x + direction.getOffsetX(), y + direction.getOffsetY(), z + direction.getOffsetZ());
        if (blockEntity instanceof MovingPistonBlockEntity) {
            MovingPistonBlockEntity moving = (MovingPistonBlockEntity)blockEntity;
            if (!moving.isExtending()) {
                ((MovingPistonBlockEntity)blockEntity).finalTick();
            } else {
                world.setBlock(x + direction.getOffsetX(), y + direction.getOffsetY(), z + direction.getOffsetZ(), 0);
            }
        }
        world.setBlockAndMetadata(x, y, z, Blocks.PISTON_MOVING.id, direction.getId());
        world.replaceBlockTileEntity(x, y, z, MovingPistonBlock.createTileEntity(this.id, direction.getId(), null, direction, false, true));
        int x1 = x + direction.getOffsetX() * 2;
        int y1 = y + direction.getOffsetY() * 2;
        int z1 = z + direction.getOffsetZ() * 2;
        int retractId = world.getBlockId(x1, y1, z1);
        int retactMeta = world.getBlockMetadata(x1, y1, z1);
        BlockEntity retractEntity = world.getBlockEntity(x1, y1, z1);
        boolean pulledMoving = false;
        if (retractId == Blocks.PISTON_MOVING.id && (blockEntity1 = world.getBlockEntity(x1, y1, z1)) instanceof MovingPistonBlockEntity && (movingPistonBlock = (MovingPistonBlockEntity)blockEntity1).getDirection() == direction && movingPistonBlock.isExtending()) {
            movingPistonBlock.finalTick();
            retractId = movingPistonBlock.getMovedId();
            retactMeta = movingPistonBlock.getMovedData();
            retractEntity = movingPistonBlock.getMovedEntity();
            pulledMoving = true;
        }
        if (!pulledMoving && retractId > 0 && this.isPushable(retractId, world, x1, y1, z1, false) && (Block.blocksList[retractId].getPistonPushReaction(world, x1, y1, z1) == 0 || Block.getBlock(retractId) instanceof PistonBaseBlock)) {
            if (!(retractEntity instanceof MovingPistonBlockEntity)) {
                world.removeBlockTileEntity(x1, y1, z1);
            }
            world.setBlock(x1, y1, z1, 0);
            world.setBlockAndMetadata(x += direction.getOffsetX(), y += direction.getOffsetY(), z += direction.getOffsetZ(), Blocks.PISTON_MOVING.id, retactMeta);
            world.replaceBlockTileEntity(x, y, z, MovingPistonBlock.createTileEntity(retractId, retactMeta, retractEntity, direction, false, false));
            world.notifyBlockChange(x1, y1, z1, 0);
        } else if (!pulledMoving) {
            world.setBlockWithNotify(x + direction.getOffsetX(), y + direction.getOffsetY(), z + direction.getOffsetZ(), 0);
        }
        world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "tile.piston.in", 0.5f, world.rand.nextFloat() * 0.15f + 0.6f);
    }

    @Override
    public void createPistonHeadAt(World world, int x, int y, int z, int data, Direction direction) {
        world.setBlockAndMetadata(x, y, z, Blocks.PISTON_MOVING.id, PistonHeadBlock.setPistonType(1, direction.getId()));
        world.replaceBlockTileEntity(x, y, z, MovingPistonBlock.createTileEntity(Blocks.PISTON_HEAD.id, PistonHeadBlock.setPistonType(1, direction.getId()), null, direction, true, false));
    }
}

