/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.entity.animal;

import com.mojang.nbt.CompoundTag;
import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.entity.ItemEntity;
import net.minecraft.core.entity.animal.Animal;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.ToolShearsItem;
import net.minecraft.core.util.collection.NamespaceID;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;

public class SheepMob
extends Animal {
    public static final int DATA_WOOL_STATE_ID = 16;
    public static final int MASK_WOOL_COLOR = 15;
    public static final int MASK_SHEARED = 16;
    public static final int DATA_EATING_ID = 17;
    public static final float[][] FLEECE_COLOR_TABLE = new float[][]{{1.0f, 1.0f, 1.0f}, {0.95f, 0.7f, 0.2f}, {0.9f, 0.5f, 0.85f}, {0.6f, 0.7f, 0.95f}, {0.9f, 0.9f, 0.2f}, {0.5f, 0.8f, 0.1f}, {0.95f, 0.7f, 0.8f}, {0.3f, 0.3f, 0.3f}, {0.6f, 0.6f, 0.6f}, {0.3f, 0.6f, 0.7f}, {0.7f, 0.4f, 0.9f}, {0.2f, 0.4f, 0.8f}, {0.5f, 0.4f, 0.3f}, {0.4f, 0.5f, 0.2f}, {0.8f, 0.3f, 0.3f}, {0.1f, 0.1f, 0.1f}};
    private int growthTimer;
    public int timeSheepEating;
    public int prevTimeSheepEating;

    public SheepMob(World world) {
        super(world);
        this.textureIdentifier = new NamespaceID("minecraft", "sheep");
        this.setSize(0.9f, 1.3f);
    }

    @Override
    protected void defineSynchedData() {
        super.defineSynchedData();
        this.entityData.define(16, (byte)0, Byte.class);
        this.entityData.define(17, (byte)0, Byte.class);
    }

    @Override
    public void spawnInit() {
        this.setFleeceColor(SheepMob.getRandomFleeceColor(this.random));
    }

    @Override
    protected void dropDeathItems() {
        super.dropDeathItems();
        if (!this.getSheared()) {
            this.spawnAtLocation(new ItemStack(Blocks.WOOL.id, 1, this.getFleeceColor().blockMeta), 0.0f);
        }
    }

    @Override
    public boolean interact(Player entityplayer) {
        if (super.interact(entityplayer)) {
            return true;
        }
        ItemStack itemstack = entityplayer.inventory.getCurrentItem();
        if (itemstack != null && itemstack.getItem() instanceof ToolShearsItem && !this.getSheared()) {
            if (!this.world.isClientSide) {
                this.setSheared(true);
                int count = 2 + this.random.nextInt(3);
                for (int j = 0; j < count; ++j) {
                    ItemEntity entityitem = this.spawnAtLocation(new ItemStack(Blocks.WOOL.id, 1, this.getFleeceColor().blockMeta), 1.0f);
                    entityitem.yd += (double)(this.random.nextFloat() * 0.05f);
                    entityitem.xd += (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.1f);
                    entityitem.zd += (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.1f);
                }
            }
            itemstack.damageItem(1, entityplayer);
            if (itemstack.stackSize <= 0) {
                entityplayer.destroyCurrentEquippedItem();
            }
            return true;
        }
        return false;
    }

    public void onItemInteract(ItemStack itemStack) {
        if (itemStack.getItem() instanceof ToolShearsItem && !this.getSheared()) {
            if (!this.world.isClientSide) {
                this.setSheared(true);
                int count = 2 + this.random.nextInt(3);
                for (int j = 0; j < count; ++j) {
                    ItemEntity itemEntity = this.spawnAtLocation(new ItemStack(Blocks.WOOL.id, 1, this.getFleeceColor().blockMeta), 1.0f);
                    itemEntity.yd += (double)(this.random.nextFloat() * 0.05f);
                    itemEntity.xd += (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.1f);
                    itemEntity.zd += (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.1f);
                }
            }
            itemStack.damageItem(1, null);
        }
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("Sheared", this.getSheared());
        tag.putByte("Color", (byte)this.getFleeceColor().blockMeta);
        tag.putShort("GrowthTimer", (short)this.growthTimer);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setSheared(tag.getBoolean("Sheared"));
        this.setFleeceColor(DyeColor.colorFromBlockMeta(tag.getByte("Color")));
        this.setGrowthTimer(tag.getShort("GrowthTimer"));
    }

    @Override
    protected boolean isMovementBlocked() {
        return super.isMovementBlocked() || this.getIsSheepEating();
    }

    public boolean getIsSheepEating() {
        return this.entityData.getByte(17) != 0;
    }

    protected void setIsSheepEating(boolean value) {
        this.entityData.set(17, (byte)(value ? 1 : 0));
    }

    @Override
    public void onLivingUpdate() {
        Block blockBelow;
        int blockZ;
        int blockY;
        int blockX;
        super.onLivingUpdate();
        if (this.getSheared()) {
            ++this.growthTimer;
        }
        if (this.growthTimer > 400) {
            blockX = MathHelper.floor(this.x);
            blockY = MathHelper.floor(this.y);
            blockZ = MathHelper.floor(this.z);
            blockBelow = this.world.getBlock(blockX, blockY - 1, blockZ);
            this.growthTimer = 0;
            if (!(blockBelow != Blocks.GRASS && blockBelow != Blocks.GRASS_RETRO || this.world.isClientSide)) {
                this.setIsSheepEating(true);
            }
            this.timeSheepEating = 0;
            this.prevTimeSheepEating = 0;
        }
        if (this.getIsSheepEating()) {
            blockX = MathHelper.floor(this.x);
            blockY = MathHelper.floor(this.y);
            blockZ = MathHelper.floor(this.z);
            blockBelow = this.world.getBlock(blockX, blockY - 1, blockZ);
            if (this.timeSheepEating >= 5 && this.timeSheepEating <= 35 && this.timeSheepEating % 5 == 0 && !this.world.isClientSide) {
                this.world.playBlockSoundEffect(null, this.x + 0.5, this.y + 0.5, this.z + 0.5, Blocks.GRASS, EnumBlockSoundEffectType.DIG);
            }
            this.prevTimeSheepEating = this.timeSheepEating++;
            if (!(this.prevTimeSheepEating != 35 || blockBelow != Blocks.GRASS && blockBelow != Blocks.GRASS_RETRO || this.world.isClientSide)) {
                this.world.playBlockEvent(null, 2001, (int)this.x, (int)this.y - 1, (int)this.z, this.world.getBlockId((int)this.x, (int)this.y - 1, (int)this.z));
                this.world.setBlockWithNotify(blockX, blockY - 1, blockZ, Blocks.DIRT.id);
                this.setSheared(false);
            }
            if (this.prevTimeSheepEating >= 40) {
                this.prevTimeSheepEating = 0;
                this.timeSheepEating = 0;
                if (!this.world.isClientSide) {
                    this.setIsSheepEating(false);
                }
            }
        }
    }

    @Override
    public String getLivingSound() {
        return "mob.sheep";
    }

    @Override
    protected String getHurtSound() {
        return "mob.sheep";
    }

    @Override
    protected String getDeathSound() {
        return "mob.sheep";
    }

    public DyeColor getFleeceColor() {
        return DyeColor.colorFromBlockMeta(this.entityData.getByte(16) & 0xF);
    }

    public void setFleeceColor(DyeColor color) {
        byte woolState = this.entityData.getByte(16);
        this.entityData.set(16, (byte)(woolState & 0xFFFFFFF0 | color.blockMeta & 0xF));
    }

    public boolean getSheared() {
        return (this.entityData.getByte(16) & 0x10) != 0;
    }

    public void setSheared(boolean flag) {
        byte woolState = this.entityData.getByte(16);
        if (flag) {
            this.entityData.set(16, (byte)(woolState | 0x10));
        } else {
            this.entityData.set(16, (byte)(woolState & 0xFFFFFFEF));
        }
    }

    public static DyeColor getRandomFleeceColor(Random random) {
        int i = random.nextInt(100);
        if (i < 5) {
            return DyeColor.BLACK;
        }
        if (i < 10) {
            return DyeColor.GRAY;
        }
        if (i < 15) {
            return DyeColor.SILVER;
        }
        if (i < 18) {
            return DyeColor.BROWN;
        }
        return random.nextInt(500) != 0 ? DyeColor.WHITE : DyeColor.PINK;
    }

    @Override
    public boolean isFavouriteItem(ItemStack itemStack) {
        if (itemStack == null || itemStack.itemID >= Block.blocksList.length) {
            return false;
        }
        return Block.blocksList[itemStack.itemID].hasTag(BlockTags.SHEEPS_FAVOURITE_BLOCK);
    }

    public void setGrowthTimer(int growthTimer) {
        this.growthTimer = growthTimer;
    }
}

