/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.ActivatorBlockEntity;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;

public class SeedsItem
extends Item {
    private int cropsId;

    public SeedsItem(String name, String namespaceId, int id, Block cropsBlock) {
        super(name, namespaceId, id);
        this.cropsId = cropsBlock.id;
    }

    @Override
    public boolean onUseItemOnBlock(ItemStack itemstack, Player entityplayer, World world, int blockX, int blockY, int blockZ, Side side, double xPlaced, double yPlaced) {
        if (!world.canPlaceInsideBlock(blockX, blockY, blockZ)) {
            blockX += side.getOffsetX();
            blockY += side.getOffsetY();
            blockZ += side.getOffsetZ();
        }
        if (world.getBlockId(blockX, blockY - 1, blockZ) == Blocks.FARMLAND_DIRT.id && world.canPlaceInsideBlock(blockX, blockY, blockZ) && world.setBlockWithNotify(blockX, blockY, blockZ, this.cropsId)) {
            world.playBlockSoundEffect(entityplayer, (float)blockX + 0.5f, (float)blockY + 0.5f, (float)blockZ + 0.5f, Block.blocksList[this.cropsId], EnumBlockSoundEffectType.PLACE);
            itemstack.consumeItem(entityplayer);
            return true;
        }
        return false;
    }

    @Override
    public void onUseByActivator(ItemStack itemStack, ActivatorBlockEntity activatorBlock, World world, Random random, int blockX, int blockY, int blockZ, double offX, double offY, double offZ, Direction direction) {
        int z;
        int y;
        int x = blockX + direction.getOffsetX();
        Block b = world.getBlock(x, y = blockY + direction.getOffsetY(), z = blockZ + direction.getOffsetZ());
        if (b == null || BlockTags.PLACE_OVERWRITES.appliesTo(b)) {
            this.onUseItemOnBlock(itemStack, null, world, x, y, z, direction.getSide(), 0.5, 0.5);
        }
    }
}

