/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.ActivatorBlockEntity;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.block.BlockItem;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.HitResult;
import net.minecraft.core.util.phys.Vec3;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.Nullable;

public class AlgaeBlockItem
extends BlockItem {
    public AlgaeBlockItem(Block block) {
        super(block);
        this.setMaxDamage(0);
        this.setHasSubtypes(true);
    }

    @Override
    public boolean onUseItemOnBlock(ItemStack itemstack, @Nullable Player player, World world, int blockX, int blockY, int blockZ, Side side, double xPlaced, double yPlaced) {
        return false;
    }

    @Override
    public ItemStack onUseItem(ItemStack itemstack, World world, Player player) {
        float f9;
        float f6;
        float f8;
        double d3;
        float f5;
        float f = 1.0f;
        float f1 = player.xRotO + (player.xRot - player.xRotO) * f;
        float f2 = player.yRotO + (player.yRot - player.yRotO) * f;
        double d = player.xo + (player.x - player.xo) * (double)f;
        double d1 = player.yo + (player.y - player.yo) * (double)f + 1.62 - (double)player.heightOffset;
        double d2 = player.zo + (player.z - player.zo) * (double)f;
        Vec3 vec3 = Vec3.getTempVec3(d, d1, d2);
        float f3 = MathHelper.cos(-f2 * 0.01745329f - (float)Math.PI);
        float f4 = MathHelper.sin(-f2 * 0.01745329f - (float)Math.PI);
        float f7 = f4 * (f5 = -MathHelper.cos(-f1 * 0.01745329f));
        Vec3 vec31 = vec3.add((double)f7 * (d3 = 5.0), (double)(f8 = (f6 = MathHelper.sin(-f1 * 0.01745329f))) * d3, (double)(f9 = f3 * f5) * d3);
        HitResult movingobjectposition = world.checkBlockCollisionBetweenPoints(vec3, vec31, true);
        if (movingobjectposition == null) {
            return itemstack;
        }
        if (movingobjectposition.hitType == HitResult.HitType.TILE) {
            int blockX = movingobjectposition.x;
            int blockY = movingobjectposition.y;
            int blockZ = movingobjectposition.z;
            if (world.getBlockId(blockX, blockY, blockZ) != Blocks.FLUID_WATER_STILL.id) {
                return itemstack;
            }
            if (world.getBlockId(blockX, ++blockY, blockZ) != 0) {
                return itemstack;
            }
            Block block = Block.blocksList[Blocks.ALGAE.id];
            if (itemstack.consumeItem(player) && world.setBlockAndMetadataWithNotify(blockX, blockY, blockZ, Blocks.ALGAE.id, 0)) {
                Block.blocksList[this.blockID].onBlockPlacedByMob(world, blockX, blockY, blockZ, Side.NONE, player, 0.5, 0.5);
                world.playBlockSoundEffect(player, (float)blockX + 0.5f, (float)blockY + 0.5f, (float)blockZ + 0.5f, block, EnumBlockSoundEffectType.PLACE);
                player.swingItem();
            }
        }
        return itemstack;
    }

    @Override
    public void onUseByActivator(ItemStack itemStack, ActivatorBlockEntity activatorBlock, World world, Random random, int blockX, int blockY, int blockZ, double offX, double offY, double offZ, Direction direction) {
        int x = blockX + direction.getOffsetX();
        int y = blockY + direction.getOffsetY();
        int z = blockZ + direction.getOffsetZ();
        Block b = world.getBlock(x, y, z);
        Block bAbove = world.getBlock(x, y + 1, z);
        if (b == Blocks.FLUID_WATER_STILL && (bAbove == null || bAbove.hasTag(BlockTags.PLACE_OVERWRITES))) {
            world.setBlockWithNotify(x, y + 1, z, Blocks.ALGAE.id);
            Blocks.ALGAE.onBlockPlacedOnSide(world, x, y + 1, z, Side.NONE, 0.5, 0.5);
        }
    }
}

