/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.lang;

import com.b100.json.JsonParser;
import com.b100.json.element.JsonArray;
import com.b100.json.element.JsonElement;
import com.b100.json.element.JsonObject;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipFile;
import net.minecraft.core.Global;
import net.minecraft.core.lang.Language;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class LanguageSeeker {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final File LANGUAGE_DIR = Global.accessor.getMinecraftDir().toPath().resolve("languages").toFile();

    @Nullable
    public static Language seek(String id) throws IOException {
        File[] files;
        if (id.equals("en_US")) {
            return Language.Default.INSTANCE;
        }
        Language ret = null;
        if (LANGUAGE_DIR.exists() && LANGUAGE_DIR.isDirectory() && (files = LANGUAGE_DIR.listFiles()) != null) {
            for (File file : files) {
                File info;
                String string;
                ArrayList<String> langCredits;
                JsonArray array;
                String langRegion;
                String langName;
                String langId;
                JsonObject json;
                String content;
                InputStream stream;
                if (file.getName().endsWith(".zip")) {
                    ZipFile zip2 = new ZipFile(file);
                    try {
                        stream = zip2.getInputStream(zip2.getEntry("lang_info.json"));
                        try {
                            content = LanguageSeeker.readInputString(stream);
                            json = JsonParser.instance.parseString(content);
                            langId = json.getString("id");
                            langName = json.getString("name");
                            langRegion = json.getString("region");
                            array = json.getArray("credits");
                            langCredits = new ArrayList<String>();
                            for (JsonElement element : array) {
                                string = element.getAsString().toString();
                                if (string == null) continue;
                                langCredits.add(string);
                            }
                            if (langId == null || langName == null || langCredits.isEmpty() || !langId.equals(id)) continue;
                            ret = new Language(id, langName, langRegion, langCredits, zip2);
                            break;
                        }
                        finally {
                            if (stream != null) {
                                stream.close();
                            }
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (!file.isDirectory() || !(info = new File(file, "lang_info.json")).exists()) continue;
                try {
                    stream = Files.newInputStream(info.toPath(), new OpenOption[0]);
                    try {
                        content = LanguageSeeker.readInputString(stream);
                        json = JsonParser.instance.parseString(content);
                        langId = json.getString("id");
                        langName = json.getString("name");
                        langRegion = json.getString("region");
                        array = json.getArray("credits");
                        langCredits = new ArrayList();
                        for (JsonElement element : array) {
                            string = element.getAsString().toString();
                            if (string == null) continue;
                            langCredits.add(string);
                        }
                        if (langId == null || langName == null || langCredits.isEmpty() || !langId.equals(id)) continue;
                        ret = new Language(id, langName, langRegion, langCredits, file);
                        break;
                    }
                    finally {
                        if (stream != null) {
                            stream.close();
                        }
                    }
                }
                catch (IOException e) {
                    LOGGER.error("Exception loading json 'lang_info.json'!", e);
                }
            }
        }
        return ret;
    }

    public static List<Language> getAvailableLanguages() throws IOException {
        File[] files;
        ArrayList<Language> ret = new ArrayList<Language>();
        ret.add(Language.Default.INSTANCE);
        if (LANGUAGE_DIR.exists() && LANGUAGE_DIR.isDirectory() && (files = LANGUAGE_DIR.listFiles()) != null) {
            for (File file : files) {
                File info;
                String string;
                ArrayList<String> langCredits;
                JsonArray array;
                String langRegion;
                String langName;
                String langId;
                JsonObject json;
                String content;
                InputStream stream;
                if (file.getName().endsWith(".zip")) {
                    ZipFile zip2 = new ZipFile(file);
                    try {
                        stream = zip2.getInputStream(zip2.getEntry("lang_info.json"));
                        try {
                            content = LanguageSeeker.readInputString(stream);
                            json = JsonParser.instance.parseString(content);
                            langId = json.getString("id");
                            langName = json.getString("name");
                            langRegion = json.getString("region");
                            array = json.getArray("credits");
                            langCredits = new ArrayList<String>();
                            for (JsonElement element : array) {
                                string = element.getAsString().toString();
                                if (string == null) continue;
                                langCredits.add(string);
                            }
                            ret.add(new Language(langId, langName, langRegion, langCredits, zip2));
                        }
                        finally {
                            if (stream != null) {
                                stream.close();
                            }
                        }
                    }
                    catch (IOException e) {
                        LOGGER.error("Exception loading json 'lang_info.json'!", e);
                    }
                    continue;
                }
                if (!file.isDirectory() || !(info = new File(file, "lang_info.json")).exists()) continue;
                try {
                    stream = Files.newInputStream(info.toPath(), new OpenOption[0]);
                    try {
                        content = LanguageSeeker.readInputString(stream);
                        json = JsonParser.instance.parseString(content);
                        langId = json.getString("id");
                        langName = json.getString("name");
                        langRegion = json.getString("region");
                        array = json.getArray("credits");
                        langCredits = new ArrayList();
                        for (JsonElement element : array) {
                            string = element.getAsString().toString();
                            if (string == null) continue;
                            langCredits.add(string);
                        }
                        ret.add(new Language(langId, langName, langRegion, langCredits, file));
                    }
                    finally {
                        if (stream != null) {
                            stream.close();
                        }
                    }
                }
                catch (IOException e) {
                    LOGGER.error("Exception loading json 'lang_info.json'!", e);
                }
            }
        }
        return ret;
    }

    private static String readInputString(InputStream inputStream) {
        if (inputStream == null) {
            throw new NullPointerException();
        }
        try {
            InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
            BufferedReader br = new BufferedReader(reader);
            StringBuilder builder = new StringBuilder();
            String line = null;
            boolean firstLine = true;
            while ((line = br.readLine()) != null) {
                if (firstLine) {
                    firstLine = false;
                } else {
                    line = "\n" + line;
                }
                builder.append(line);
            }
            br.close();
            reader.close();
            return builder.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

