/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.command;

import java.util.Collection;
import java.util.Collections;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.util.phys.Vec3;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.Nullable;

public interface CommandSource {
    public Collection<String> getPlayerNames();

    default public Collection<String> getChatSuggestions() {
        return this.getPlayerNames();
    }

    default public Collection<String> getEntitySuggestions() {
        return Collections.emptyList();
    }

    public String toString();

    @Nullable
    public Player getSender();

    public boolean hasAdmin();

    @Nullable
    public Vec3 getCoordinates(boolean var1);

    @Nullable
    public Vec3 getBlockCoordinates();

    public boolean messageMayBeMultiline();

    public void sendMessage(String var1);

    public void sendMessage(Player var1, String var2);

    default public void sendTranslatableMessage(String message, Object ... args2) {
        this.sendMessage(I18n.getInstance().translateKeyAndFormat(message, args2));
    }

    default public void sendTranslatableMessage(Player player, String message, Object ... args2) {
        this.sendMessage(player, I18n.getInstance().translateKeyAndFormat(message, args2));
    }

    public void sendMessageToAllPlayers(String var1);

    public World getWorld();

    public World getWorld(int var1);

    public void movePlayerToDimension(Player var1, int var2);

    public String getName();
}

