/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.command.arguments;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.entity.particle.ParticleDispatcher;
import net.minecraft.core.lang.I18n;

public class ParticleIdArgumentType
implements ArgumentType<String> {
    private static final List<String> EXAMPLES = Arrays.asList("fireflyGreen", "explode", "soulflame");

    public static ArgumentType<String> particleId() {
        return new ParticleIdArgumentType();
    }

    @Override
    public String parse(StringReader reader) throws CommandSyntaxException {
        String string = reader.readString();
        for (String particleId : ParticleDispatcher.getInstance().getParticleIds()) {
            if (!particleId.equalsIgnoreCase(string)) continue;
            return string;
        }
        throw new CommandSyntaxException(CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownArgument(), () -> I18n.getInstance().translateKeyAndFormat("command.argument_types.particle_id.invalid_id", string));
    }

    @Override
    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        for (String particleId : ParticleDispatcher.getInstance().getParticleIds()) {
            if (!particleId.toLowerCase(Locale.ROOT).startsWith(builder.getRemainingLowerCase())) continue;
            builder.suggest(particleId);
        }
        return builder.buildFuture();
    }

    @Override
    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}

