/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.command.arguments;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.sound.SoundEvent;
import net.minecraft.client.sound.SoundRepository;
import net.minecraft.core.Global;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.sound.SoundTypes;

public class SoundIdArgumentType
implements ArgumentType<String> {
    private static final List<String> EXAMPLES = Arrays.asList("random.fuse.lit", "note.snare", "mob.skeletonhurt");

    public static ArgumentType<String> soundId() {
        return new SoundIdArgumentType();
    }

    @Override
    public String parse(StringReader reader) throws CommandSyntaxException {
        String string = reader.readString();
        for (String se : this.soundIds()) {
            if (!se.equalsIgnoreCase(string)) continue;
            return string;
        }
        throw new CommandSyntaxException(CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownArgument(), () -> I18n.getInstance().translateKeyAndFormat("command.argument_types.sound_id.invalid_id", string));
    }

    @Override
    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        for (String se : this.soundIds()) {
            if (!se.startsWith(builder.getRemainingLowerCase())) continue;
            builder.suggest(se);
        }
        return builder.buildFuture();
    }

    public Collection<String> soundIds() {
        if (Global.isServer) {
            return SoundTypes.getSoundIds().keySet();
        }
        ArrayList<String> ids = new ArrayList<String>();
        for (SoundEvent e : SoundRepository.SOUNDS.getAllEvents()) {
            ids.add(e.getEventID());
        }
        return ids;
    }

    @Override
    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}

