/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.command.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import net.minecraft.core.net.command.CommandSource;
import net.minecraft.core.net.command.arguments.ChunkCoordinatesArgumentType;
import net.minecraft.core.net.command.helpers.Coordinates2D;
import net.minecraft.core.world.LevelListener;
import net.minecraft.core.world.World;

public class ChunkCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal("chunk").requires(CommandSource::hasAdmin)).then(LiteralArgumentBuilder.literal("reset").then(RequiredArgumentBuilder.argument("position", ChunkCoordinatesArgumentType.chunkCoordinates()).executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            Coordinates2D coordinates2D = c.getArgument("position", Coordinates2D.class);
            World world = source.getWorld();
            int x = coordinates2D.getX(source);
            int z = coordinates2D.getZ(source);
            world.getChunkProvider().regenerateChunk(x, z);
            for (LevelListener listener : world.listeners) {
                listener.allChanged(false, true);
            }
            source.sendTranslatableMessage("command.commands.chunk.reset.success", x, z);
            return 1;
        }))));
    }
}

