/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.command.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import java.util.List;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.net.command.CommandSource;
import net.minecraft.core.net.command.arguments.DamageTypeArgumentType;
import net.minecraft.core.net.command.arguments.EntityArgumentType;
import net.minecraft.core.net.command.helpers.EntitySelector;
import net.minecraft.core.util.helper.DamageType;

public class DamageCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal("damage").requires(CommandSource::hasAdmin)).then(RequiredArgumentBuilder.argument("entities", EntityArgumentType.entities()).then(RequiredArgumentBuilder.argument("type", DamageTypeArgumentType.damageType()).then(RequiredArgumentBuilder.argument("amount", IntegerArgumentType.integer(0, 32768)).executes(c -> {
            List<? extends Entity> entities = c.getArgument("entities", EntitySelector.class).get((CommandSource)c.getSource());
            DamageType type = c.getArgument("type", DamageType.class);
            int amount = c.getArgument("amount", Integer.class);
            int entitiesAffected = 0;
            for (Entity entity : entities) {
                if (!entity.hurt(null, amount, type)) continue;
                ++entitiesAffected;
            }
            ((CommandSource)c.getSource()).sendTranslatableMessage("command.commands.damage.success_" + (entitiesAffected == 1 ? "single" : "multiple"), entitiesAffected);
            return entitiesAffected;
        })))));
    }
}

