/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.command.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import java.util.Collection;
import net.minecraft.core.entity.EntityDispatcher;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.net.command.CommandSource;
import net.minecraft.core.net.command.arguments.EntitySummonArgumentType;
import net.minecraft.core.world.World;
import net.minecraft.core.world.config.spawning.SpawnerConfig;

public class MobSpawningCommand {
    private static final DynamicCommandExceptionType FAILURE = new DynamicCommandExceptionType(arg -> () -> I18n.getInstance().translateKeyAndFormat("command.commands.mobspawning.exception_failure", arg));

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal("mobspawning").requires(CommandSource::hasAdmin)).then(LiteralArgumentBuilder.literal("list").executes(c -> {
            Collection<String> ids = EntityDispatcher.classToKeyMap.values();
            World world = ((CommandSource)c.getSource()).getWorld();
            SpawnerConfig config = world.getSpawnerConfig();
            for (String s : ids) {
                ((CommandSource)c.getSource()).sendMessage(String.format("%s : %s", s, config.canMobSpawn(s)));
            }
            ((CommandSource)c.getSource()).sendMessage("Passive Spawning : " + config.canPassiveSpawn(world));
            ((CommandSource)c.getSource()).sendMessage("Hostile Spawning : " + config.canHostileSpawn(world));
            return 1;
        }))).then(LiteralArgumentBuilder.literal("set").then(RequiredArgumentBuilder.argument("entity", EntitySummonArgumentType.entity()).then(RequiredArgumentBuilder.argument("value", BoolArgumentType.bool()).executes(c -> {
            World world = ((CommandSource)c.getSource()).getWorld();
            SpawnerConfig config = world.getSpawnerConfig();
            String mobId = EntityDispatcher.getEncodeId(c.getArgument("entity", Class.class));
            boolean value = c.getArgument("value", Boolean.class);
            config.setMobSpawn(mobId, value);
            ((CommandSource)c.getSource()).sendTranslatableMessage("command.commands.mobspawning.set", mobId, value);
            return 1;
        }))))).then(LiteralArgumentBuilder.literal("passive").then(RequiredArgumentBuilder.argument("value", BoolArgumentType.bool()).executes(c -> {
            World world = ((CommandSource)c.getSource()).getWorld();
            SpawnerConfig config = world.getSpawnerConfig();
            boolean value = c.getArgument("value", Boolean.class);
            config.setPassiveSpawning(value);
            ((CommandSource)c.getSource()).sendTranslatableMessage("command.commands.mobspawning.passive", value);
            return 1;
        })))).then(LiteralArgumentBuilder.literal("hostile").then(RequiredArgumentBuilder.argument("value", BoolArgumentType.bool()).executes(c -> {
            World world = ((CommandSource)c.getSource()).getWorld();
            SpawnerConfig config = world.getSpawnerConfig();
            boolean value = c.getArgument("value", Boolean.class);
            config.setHostileSpawning(value);
            ((CommandSource)c.getSource()).sendTranslatableMessage("command.commands.mobspawning.hostile", value);
            return 1;
        }))));
    }
}

