/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.command.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.nbt.CompoundTag;
import java.util.List;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.BlockEntity;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.net.command.CommandSource;
import net.minecraft.core.net.command.arguments.BlockArgumentType;
import net.minecraft.core.net.command.arguments.EntityArgumentType;
import net.minecraft.core.net.command.arguments.IntegerCoordinatesArgumentType;
import net.minecraft.core.net.command.helpers.BlockInput;
import net.minecraft.core.net.command.helpers.EntitySelector;
import net.minecraft.core.net.command.helpers.IntegerCoordinates;
import net.minecraft.core.net.command.util.CommandHelper;

public class TestForCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal("testfor").requires(CommandSource::hasAdmin)).then(LiteralArgumentBuilder.literal("entity").then(RequiredArgumentBuilder.argument("entities", EntityArgumentType.entities()).executes(c -> {
            List<? extends Entity> entities = c.getArgument("entities", EntitySelector.class).get((CommandSource)c.getSource());
            ((CommandSource)c.getSource()).sendTranslatableMessage("command.commands.testfor.entity." + (entities.isEmpty() ? "none" : (entities.size() == 1 ? "single" : "multiple")), entities.size());
            return entities.size();
        })))).then(((LiteralArgumentBuilder)LiteralArgumentBuilder.literal("block").then(RequiredArgumentBuilder.argument("block", BlockArgumentType.block()).then(RequiredArgumentBuilder.argument("second", IntegerCoordinatesArgumentType.intCoordinates()).executes(c -> {
            BlockInput block = c.getArgument("block", BlockInput.class);
            IntegerCoordinates secondPos = c.getArgument("second", IntegerCoordinates.class);
            CompoundTag blockInWorldCompoundTag = new CompoundTag();
            BlockEntity blockEntity = ((CommandSource)c.getSource()).getWorld().getBlockEntity(secondPos.getX((CommandSource)c.getSource()), secondPos.getY((CommandSource)c.getSource(), true), secondPos.getZ((CommandSource)c.getSource()));
            if (blockEntity != null) {
                blockEntity.writeToNBT(blockInWorldCompoundTag);
            }
            if (((CommandSource)c.getSource()).getWorld().getBlock(secondPos.getX((CommandSource)c.getSource()), secondPos.getY((CommandSource)c.getSource(), true), secondPos.getZ((CommandSource)c.getSource())) == block.getBlock() && ((CommandSource)c.getSource()).getWorld().getBlockMetadata(secondPos.getX((CommandSource)c.getSource()), secondPos.getY((CommandSource)c.getSource(), true), secondPos.getZ((CommandSource)c.getSource())) == block.getMetadata() && (blockInWorldCompoundTag == block.getTag() || block.getTag().getValues().isEmpty())) {
                ((CommandSource)c.getSource()).sendTranslatableMessage("command.commands.testfor.block.success", new Object[0]);
                return 1;
            }
            ((CommandSource)c.getSource()).sendTranslatableMessage("command.commands.testfor.block.failure", new Object[0]);
            return 0;
        })))).then(RequiredArgumentBuilder.argument("first", IntegerCoordinatesArgumentType.intCoordinates()).then(RequiredArgumentBuilder.argument("second", IntegerCoordinatesArgumentType.intCoordinates()).executes(c -> {
            int secondMetadata;
            Block secondBlock;
            IntegerCoordinates firstPos = c.getArgument("first", IntegerCoordinates.class);
            IntegerCoordinates secondPos = c.getArgument("second", IntegerCoordinates.class);
            Block firstBlock = ((CommandSource)c.getSource()).getWorld().getBlock(firstPos.getX((CommandSource)c.getSource()), firstPos.getY((CommandSource)c.getSource(), true), firstPos.getZ((CommandSource)c.getSource()));
            if (firstBlock != (secondBlock = ((CommandSource)c.getSource()).getWorld().getBlock(secondPos.getX((CommandSource)c.getSource()), secondPos.getY((CommandSource)c.getSource(), true), secondPos.getZ((CommandSource)c.getSource())))) {
                ((CommandSource)c.getSource()).sendTranslatableMessage("command.commands.testfor.block.failure", new Object[0]);
                return 0;
            }
            int firstMetadata = ((CommandSource)c.getSource()).getWorld().getBlockMetadata(firstPos.getX((CommandSource)c.getSource()), firstPos.getY((CommandSource)c.getSource(), true), firstPos.getZ((CommandSource)c.getSource()));
            if (firstMetadata != (secondMetadata = ((CommandSource)c.getSource()).getWorld().getBlockMetadata(secondPos.getX((CommandSource)c.getSource()), secondPos.getY((CommandSource)c.getSource(), true), secondPos.getZ((CommandSource)c.getSource())))) {
                ((CommandSource)c.getSource()).sendTranslatableMessage("command.commands.testfor.block.failure", new Object[0]);
                return 0;
            }
            CompoundTag firstTag = new CompoundTag();
            BlockEntity firstBlockEntity = ((CommandSource)c.getSource()).getWorld().getBlockEntity(firstPos.getX((CommandSource)c.getSource()), firstPos.getY((CommandSource)c.getSource(), true), firstPos.getZ((CommandSource)c.getSource()));
            if (firstBlockEntity != null) {
                firstBlockEntity.writeToNBT(firstTag);
            }
            CompoundTag secondTag = new CompoundTag();
            BlockEntity secondBlockEntity = ((CommandSource)c.getSource()).getWorld().getBlockEntity(secondPos.getX((CommandSource)c.getSource()), secondPos.getY((CommandSource)c.getSource(), true), secondPos.getZ((CommandSource)c.getSource()));
            if (secondBlockEntity != null) {
                secondBlockEntity.writeToNBT(secondTag);
            }
            if (!CommandHelper.blockEntitiesAreEqual(firstTag, secondTag)) {
                ((CommandSource)c.getSource()).sendTranslatableMessage("command.commands.testfor.block.failure", new Object[0]);
                return 0;
            }
            ((CommandSource)c.getSource()).sendTranslatableMessage("command.commands.testfor.block.success", new Object[0]);
            return 1;
        })))));
    }
}

