/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.packet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.net.handler.PacketHandler;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.core.util.helper.Direction;

public class UseItemPacket
extends Packet {
    public int xPosition;
    public int yPosition;
    public int zPosition;
    public Direction direction;
    public double xPlaced;
    public double yPlaced;
    public ItemStack itemStack;

    public UseItemPacket() {
    }

    public UseItemPacket(int x, int y, int z, Direction direction, ItemStack itemstack, double xPlaced, double yPlaced) {
        this.xPosition = x;
        this.yPosition = y;
        this.zPosition = z;
        this.direction = direction;
        this.itemStack = itemstack;
        this.xPlaced = xPlaced;
        this.yPlaced = yPlaced;
    }

    @Override
    public void read(DataInputStream dis) throws IOException {
        this.xPosition = dis.readInt();
        this.yPosition = dis.read();
        this.zPosition = dis.readInt();
        this.direction = Direction.getDirectionById(dis.read());
        this.xPlaced = dis.readDouble();
        this.yPlaced = dis.readDouble();
        short word0 = dis.readShort();
        if (word0 >= 0) {
            byte byte0 = dis.readByte();
            short word1 = dis.readShort();
            this.itemStack = new ItemStack(word0, (int)byte0, (int)word1);
        } else {
            this.itemStack = null;
        }
    }

    @Override
    public void write(DataOutputStream dos) throws IOException {
        dos.writeInt(this.xPosition);
        dos.write(this.yPosition);
        dos.writeInt(this.zPosition);
        dos.write(this.direction.getId());
        dos.writeDouble(this.xPlaced);
        dos.writeDouble(this.yPlaced);
        if (this.itemStack == null) {
            dos.writeShort(-1);
        } else {
            dos.writeShort(this.itemStack.itemID);
            dos.writeByte(this.itemStack.stackSize);
            dos.writeShort(this.itemStack.getMetadata());
        }
    }

    @Override
    public void handlePacket(PacketHandler packetHandler) {
        packetHandler.handlePlace(this);
    }

    @Override
    public int getEstimatedSize() {
        return 19;
    }
}

