/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world;

import com.mojang.logging.LogUtils;
import com.mojang.nbt.CompoundTag;
import net.minecraft.core.block.motion.CarriedBlock;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import org.slf4j.Logger;

public interface ICarriable {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final String TYPE_BLOCK = "block";

    public void heldTick(World var1, Entity var2);

    public boolean tryPlace(World var1, Entity var2, int var3, int var4, int var5, Side var6, double var7, double var9);

    public void drop(World var1, Entity var2);

    public boolean canBeCarried(World var1, Entity var2);

    public ICarriable pickup(World var1, Entity var2);

    public void writeToNBT(CompoundTag var1);

    public void readFromNBT(CompoundTag var1);

    public static ICarriable createAndLoadCarriable(Entity holder, CompoundTag tag) {
        String type = tag.getString("type");
        if (type.equalsIgnoreCase(TYPE_BLOCK)) {
            return CarriedBlock.createAndLoadCarriedBlock(holder, tag);
        }
        LOGGER.warn("Could not identify carriable for type {}!", (Object)type);
        return null;
    }
}

