/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.PortalBlock;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.World;
import net.minecraft.core.world.type.WorldType;

public class PortalHandler {
    private Random rand = new Random();

    public void teleportEntity(World world, Entity entity, Dimension oldDim, Dimension newDim) {
        if (!this.attemptToTeleportToClosestPortal(world, entity, oldDim, newDim)) {
            this.generatePortal(world, entity, oldDim, newDim);
            this.attemptToTeleportToClosestPortal(world, entity, oldDim, newDim);
        }
    }

    public boolean attemptToTeleportToClosestPortal(World world, Entity entity, Dimension oldDim, Dimension newDim) {
        int searchRadius = 128;
        double lowestEntityDistanceSquared = -1.0;
        int closestPortalX = 0;
        int closestPortalY = 0;
        int closestPortalZ = 0;
        int entityBlockX = MathHelper.floor(entity.x);
        int entityBlockZ = MathHelper.floor(entity.z);
        WorldType oldWorldType = oldDim.getDimensionData(world).getWorldType();
        WorldType newWorldType = newDim.getDimensionData(world).getWorldType();
        double entityPosYScaled = entity.y;
        int oldDimRangeY = oldWorldType.getMaxY() - oldWorldType.getMinY();
        entityPosYScaled -= (double)oldWorldType.getMinY();
        entityPosYScaled /= (double)oldDimRangeY;
        int newDimRangeY = newWorldType.getMaxY() - newWorldType.getMinY();
        entityPosYScaled *= (double)newDimRangeY;
        entityPosYScaled += (double)newWorldType.getMinY();
        int targetPortalId = newDim.homeDim == null ? oldDim.portalBlockId : newDim.portalBlockId;
        for (int dx = entityBlockX - searchRadius; dx <= entityBlockX + searchRadius; ++dx) {
            double xEntityDistance = (double)dx + 0.5 - entity.x;
            for (int dz = entityBlockZ - searchRadius; dz <= entityBlockZ + searchRadius; ++dz) {
                double zEntityDistance = (double)dz + 0.5 - entity.z;
                for (int dy = newWorldType.getMaxY() - 1; dy >= newWorldType.getMinY(); --dy) {
                    if (world.getBlockId(dx, dy, dz) != targetPortalId) continue;
                    while (world.getBlockId(dx, dy - 1, dz) == targetPortalId) {
                        --dy;
                    }
                    double yEntityDistance = (double)dy + 0.5 - entityPosYScaled;
                    double entityDistanceSquared = xEntityDistance * xEntityDistance + yEntityDistance * yEntityDistance + zEntityDistance * zEntityDistance;
                    if (!(lowestEntityDistanceSquared < 0.0) && !(entityDistanceSquared < lowestEntityDistanceSquared)) continue;
                    lowestEntityDistanceSquared = entityDistanceSquared;
                    closestPortalX = dx;
                    closestPortalY = dy;
                    closestPortalZ = dz;
                }
            }
        }
        if (lowestEntityDistanceSquared >= 0.0) {
            int portalX = closestPortalX;
            int portalY = closestPortalY;
            int portalZ = closestPortalZ;
            double newEntityX = (double)portalX + 0.5;
            double newEntityY = (double)portalY + 0.5;
            double newEntityZ = (double)portalZ + 0.5;
            if (world.getBlockId(portalX - 1, portalY, portalZ) == targetPortalId) {
                newEntityX -= 0.5;
            }
            if (world.getBlockId(portalX + 1, portalY, portalZ) == targetPortalId) {
                newEntityX += 0.5;
            }
            if (world.getBlockId(portalX, portalY, portalZ - 1) == targetPortalId) {
                newEntityZ -= 0.5;
            }
            if (world.getBlockId(portalX, portalY, portalZ + 1) == targetPortalId) {
                newEntityZ += 0.5;
            }
            entity.moveTo(newEntityX, newEntityY - 0.5, newEntityZ, entity.yRot, 0.0f);
            entity.zd = 0.0;
            entity.yd = 0.0;
            entity.xd = 0.0;
            return true;
        }
        return false;
    }

    public boolean generatePortal(World world, Entity entity, Dimension oldDim, Dimension newDim) {
        int dy;
        int dz;
        int dx;
        int targetPortalId;
        int targetPortalFrameId;
        WorldType oldWorldType = oldDim.getDimensionData(world).getWorldType();
        WorldType newWorldType = newDim.getDimensionData(world).getWorldType();
        double entityPosYScaled = entity.y;
        int oldDimRangeY = oldWorldType.getMaxY() - oldWorldType.getMinY();
        entityPosYScaled -= (double)oldWorldType.getMinY();
        entityPosYScaled /= (double)oldDimRangeY;
        int newDimRangeY = newWorldType.getMaxY() - newWorldType.getMinY();
        entityPosYScaled *= (double)newDimRangeY;
        int portalSearchRadius = 16;
        double lowestEntityDistance = -1.0;
        int blockX = MathHelper.floor(entity.x);
        int blockY = MathHelper.floor(entityPosYScaled += (double)newWorldType.getMinY());
        int blockZ = MathHelper.floor(entity.z);
        int closestPortalX = blockX;
        int closestPortalY = blockY;
        int closestPortalZ = blockZ;
        int k1 = 0;
        int l1 = this.rand.nextInt(4);
        if (newDim.homeDim == null) {
            targetPortalFrameId = ((PortalBlock)Block.blocksList[oldDim.portalBlockId]).portalFrameId;
            targetPortalId = oldDim.portalBlockId;
        } else {
            targetPortalFrameId = ((PortalBlock)Block.blocksList[newDim.portalBlockId]).portalFrameId;
            targetPortalId = newDim.portalBlockId;
        }
        for (dx = blockX - portalSearchRadius; dx <= blockX + portalSearchRadius; ++dx) {
            double xEntityDistance = (double)dx + 0.5 - entity.x;
            for (dz = blockZ - portalSearchRadius; dz <= blockZ + portalSearchRadius; ++dz) {
                double zEntityDistance = (double)dz + 0.5 - entity.z;
                block2: for (dy = newWorldType.getMaxY() - 1; dy >= newWorldType.getMinY(); --dy) {
                    if (!world.isAirBlock(dx, dy, dz)) continue;
                    while (dy > 0 && world.isAirBlock(dx, dy - 1, dz)) {
                        --dy;
                    }
                    for (int k5 = l1; k5 < l1 + 4; ++k5) {
                        int frameXMult = k5 % 2;
                        int frameZMult = 1 - frameXMult;
                        if (k5 % 4 >= 2) {
                            frameXMult = -frameXMult;
                            frameZMult = -frameZMult;
                        }
                        for (int j9 = 0; j9 < 3; ++j9) {
                            for (int xzOffset = 0; xzOffset < 4; ++xzOffset) {
                                for (int yOffset = -1; yOffset < 4; ++yOffset) {
                                    int lookupX = dx + (xzOffset - 1) * frameXMult + j9 * frameZMult;
                                    int lookupY = dy + yOffset;
                                    int lookupZ = dz + (xzOffset - 1) * frameZMult - j9 * frameXMult;
                                    if (yOffset < 0 && !world.getBlockMaterial(lookupX, lookupY, lookupZ).isSolid() || yOffset >= 0 && !world.isAirBlock(lookupX, lookupY, lookupZ)) continue block2;
                                }
                            }
                        }
                        double yEntityDistance = (double)dy + 0.5 - entityPosYScaled;
                        double entityDistanceSquared = xEntityDistance * xEntityDistance + yEntityDistance * yEntityDistance + zEntityDistance * zEntityDistance;
                        if (!(lowestEntityDistance < 0.0) && !(entityDistanceSquared < lowestEntityDistance)) continue;
                        lowestEntityDistance = entityDistanceSquared;
                        closestPortalX = dx;
                        closestPortalY = dy;
                        closestPortalZ = dz;
                        k1 = k5 % 4;
                    }
                }
            }
        }
        if (lowestEntityDistance < 0.0) {
            for (dx = blockX - portalSearchRadius; dx <= blockX + portalSearchRadius; ++dx) {
                double entityDistanceX = (double)dx + 0.5 - entity.x;
                for (dz = blockZ - portalSearchRadius; dz <= blockZ + portalSearchRadius; ++dz) {
                    double entityDistanceZ = (double)dz + 0.5 - entity.z;
                    block10: for (dy = newWorldType.getMaxY() - 1; dy >= newWorldType.getMinY(); --dy) {
                        if (!world.isAirBlock(dx, dy, dz)) continue;
                        while (world.isAirBlock(dx, dy - 1, dz) && dy > 0) {
                            --dy;
                        }
                        for (int l5 = l1; l5 < l1 + 2; ++l5) {
                            int i7 = l5 % 2;
                            int j8 = 1 - i7;
                            for (int k9 = 0; k9 < 4; ++k9) {
                                for (int yOffset = -1; yOffset < 4; ++yOffset) {
                                    int lookupX = dx + (k9 - 1) * i7;
                                    int lookupY = dy + yOffset;
                                    int lookupZ = dz + (k9 - 1) * j8;
                                    if (yOffset < 0 && !world.getBlockMaterial(lookupX, lookupY, lookupZ).isSolid() || yOffset >= 0 && !world.isAirBlock(lookupX, lookupY, lookupZ)) continue block10;
                                }
                            }
                            double entityDistanceY = (double)dy + 0.5 - entityPosYScaled;
                            double entityDistanceSquared = entityDistanceX * entityDistanceX + entityDistanceY * entityDistanceY + entityDistanceZ * entityDistanceZ;
                            if (!(lowestEntityDistance < 0.0) && !(entityDistanceSquared < lowestEntityDistance)) continue;
                            lowestEntityDistance = entityDistanceSquared;
                            closestPortalX = dx;
                            closestPortalY = dy;
                            closestPortalZ = dz;
                            k1 = l5 % 2;
                        }
                    }
                }
            }
        }
        int k2 = k1;
        int portalX = closestPortalX;
        int portalY = closestPortalY;
        int portalZ = closestPortalZ;
        int frameXMult = k2 % 2;
        int frameZMult = 1 - frameXMult;
        if (k2 % 4 >= 2) {
            frameXMult = -frameXMult;
            frameZMult = -frameZMult;
        }
        if (lowestEntityDistance < 0.0) {
            portalY = closestPortalY;
            for (int i5 = -1; i5 <= 1; ++i5) {
                for (int i6 = 1; i6 < 3; ++i6) {
                    for (int j7 = -1; j7 < 3; ++j7) {
                        int x = portalX + (i6 - 1) * frameXMult + i5 * frameZMult;
                        int y = portalY + j7;
                        int z = portalZ + (i6 - 1) * frameZMult - i5 * frameXMult;
                        boolean flag = j7 < 0;
                        world.setBlockWithNotify(x, y, z, flag ? targetPortalFrameId : 0);
                    }
                }
            }
        }
        for (int j5 = 0; j5 < 4; ++j5) {
            world.noNeighborUpdate = true;
            for (int xzOffset = 0; xzOffset < 4; ++xzOffset) {
                for (int yOffset = -1; yOffset < 4; ++yOffset) {
                    int lookupX = portalX + (xzOffset - 1) * frameXMult;
                    int lookupY = portalY + yOffset;
                    int lookupZ = portalZ + (xzOffset - 1) * frameZMult;
                    boolean isPortalBorder = xzOffset == 0 || xzOffset == 3 || yOffset == -1 || yOffset == 3;
                    world.setBlockWithNotify(lookupX, lookupY, lookupZ, isPortalBorder ? targetPortalFrameId : 0);
                }
            }
            ((PortalBlock)Block.blocksList[targetPortalId]).tryToCreatePortal(world, portalX, portalY, portalZ);
            world.noNeighborUpdate = false;
            for (int k6 = 0; k6 < 4; ++k6) {
                for (int l7 = -1; l7 < 4; ++l7) {
                    int i9 = portalX + (k6 - 1) * frameXMult;
                    int j10 = portalY + l7;
                    int k11 = portalZ + (k6 - 1) * frameZMult;
                    world.notifyBlocksOfNeighborChange(i9, j10, k11, world.getBlockId(i9, j10, k11));
                }
            }
        }
        return true;
    }
}

