/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.config.spawning;

import com.mojang.nbt.ByteTag;
import com.mojang.nbt.CompoundTag;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.core.world.World;

public class SpawnerConfig {
    private boolean allowPassive = true;
    private boolean allowHostile = true;
    private final Map<String, Boolean> mobSpawnOverrides = new HashMap<String, Boolean>();

    public boolean canPassiveSpawn(World world) {
        return this.allowPassive;
    }

    public void setPassiveSpawning(boolean flag) {
        this.allowPassive = flag;
    }

    public boolean canHostileSpawn(World world) {
        return this.allowHostile && world.getDifficulty().canHostileMobsSpawn();
    }

    public void setHostileSpawning(boolean flag) {
        this.allowHostile = flag;
    }

    public boolean canMobSpawn(String mobID) {
        return this.mobSpawnOverrides.getOrDefault(mobID.toLowerCase(Locale.ROOT), true);
    }

    public void setMobSpawn(String mobID, boolean flag) {
        this.mobSpawnOverrides.put(mobID.toLowerCase(Locale.ROOT), flag);
    }

    public Collection<Map.Entry<String, Boolean>> getSpawnEntries() {
        return this.mobSpawnOverrides.entrySet();
    }

    public void writeToTag(CompoundTag tag) {
        tag.putBoolean("passive", this.allowPassive);
        tag.putBoolean("hostile", this.allowHostile);
        CompoundTag overridesTag = new CompoundTag();
        for (Map.Entry<String, Boolean> e : this.mobSpawnOverrides.entrySet()) {
            overridesTag.putBoolean(e.getKey(), e.getValue());
        }
        tag.putCompound("overrides", overridesTag);
    }

    public void readFromTag(CompoundTag tag) {
        this.allowPassive = tag.getBoolean("passive");
        this.allowHostile = tag.getBoolean("hostile");
        CompoundTag overrides = tag.getCompound("overrides");
        for (Map.Entry tagEntry : ((Map)overrides.getValue()).entrySet()) {
            this.mobSpawnOverrides.put((String)tagEntry.getKey(), (Byte)((ByteTag)tagEntry.getValue()).getValue() != 0);
        }
    }

    public static SpawnerConfig createFromTag(CompoundTag tag) {
        SpawnerConfig config = new SpawnerConfig();
        if (tag != null) {
            config.readFromTag(tag);
        }
        return config;
    }
}

