/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.generate.feature.tree;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.world.World;
import net.minecraft.core.world.generate.feature.MethodParametersAnnotation;
import net.minecraft.core.world.generate.feature.WorldFeature;

public class WorldFeatureTree
extends WorldFeature {
    protected int leavesID;
    protected int logID;
    protected int heightMod;

    @MethodParametersAnnotation(names={"leavesID", "logID", "heightMod"})
    public WorldFeatureTree(int leavesID, int logID, int heightMod) {
        this.leavesID = leavesID;
        this.logID = logID;
        this.heightMod = heightMod;
    }

    @Override
    public boolean place(World world, Random random, int x, int y, int z) {
        int treeHeight = random.nextInt(3) + this.heightMod;
        boolean canSpawn = true;
        if (y < 1 || y + treeHeight + 1 > world.getHeightBlocks()) {
            return false;
        }
        for (int iy = y; iy <= y + 1 + treeHeight; ++iy) {
            int treeRadius = 1;
            if (iy == y) {
                treeRadius = 0;
            }
            if (iy >= y + 1 + treeHeight - 2) {
                treeRadius = 2;
            }
            for (int ix = x - treeRadius; ix <= x + treeRadius && canSpawn; ++ix) {
                for (int iz = z - treeRadius; iz <= z + treeRadius && canSpawn; ++iz) {
                    if (iy >= 0 && iy < world.getHeightBlocks()) {
                        int blockId = world.getBlockId(ix, iy, iz);
                        if (blockId == 0 || blockId == this.leavesID) continue;
                        canSpawn = false;
                        continue;
                    }
                    canSpawn = false;
                }
            }
        }
        if (!canSpawn) {
            return false;
        }
        int idBelow = world.getBlockId(x, y - 1, z);
        if (!Block.hasTag(idBelow, BlockTags.GROWS_TREES) || y >= world.getHeightBlocks() - treeHeight - 1) {
            return false;
        }
        WorldFeatureTree.onTreeGrown(world, x, y, z);
        for (int iy = y - 3 + treeHeight; iy <= y + treeHeight; ++iy) {
            int j2 = iy - (y + treeHeight);
            int i3 = 1 - j2 / 2;
            for (int ix = x - i3; ix <= x + i3; ++ix) {
                int l3 = ix - x;
                for (int iz = z - i3; iz <= z + i3; ++iz) {
                    int j4 = iz - z;
                    if (Math.abs(l3) == i3 && Math.abs(j4) == i3 && (random.nextInt(2) == 0 || j2 == 0) || !WorldFeatureTree.canLeavesReplace(world, ix, iy, iz)) continue;
                    this.placeLeaves(world, ix, iy, iz, random);
                }
            }
        }
        for (int l1 = 0; l1 < treeHeight; ++l1) {
            int id = world.getBlockId(x, y + l1, z);
            if (id != 0 && !this.isLeaf(id)) continue;
            world.setBlockWithNotify(x, y + l1, z, this.logID);
        }
        return true;
    }

    public void placeLeaves(World world, int x, int y, int z, Random rand) {
        world.setBlockWithNotify(x, y, z, this.leavesID);
    }

    public boolean isLeaf(int id) {
        return id == this.leavesID;
    }

    public static void onTreeGrown(World world, int x, int y, int z) {
        Block dirt = WorldFeatureTree.getDirtForGrass(world.getBlockId(x, y - 1, z));
        if (dirt != null) {
            world.setBlockWithNotify(x, y - 1, z, dirt.id);
        }
    }

    public static Block getDirtForGrass(int id) {
        if (id == Blocks.GRASS.id || id == Blocks.GRASS_RETRO.id) {
            return Blocks.DIRT;
        }
        if (id == Blocks.GRASS_SCORCHED.id) {
            return Blocks.DIRT_SCORCHED;
        }
        return null;
    }

    public static boolean canLeavesReplace(World world, int x, int y, int z) {
        Block b = world.getBlock(x, y, z);
        return b == null || b.hasTag(BlockTags.PLACE_OVERWRITES);
    }
}

