/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.entity.player;

import com.mojang.nbt.CompoundTag;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.achievement.stat.Stat;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.PortalBlock;
import net.minecraft.core.block.entity.ActivatorBlockEntity;
import net.minecraft.core.block.entity.BlastFurnaceBlockEntity;
import net.minecraft.core.block.entity.BlockEntity;
import net.minecraft.core.block.entity.DispenserBlockEntity;
import net.minecraft.core.block.entity.FlagBlockEntity;
import net.minecraft.core.block.entity.FurnaceBlockEntity;
import net.minecraft.core.block.entity.TrommelBlockEntity;
import net.minecraft.core.crafting.ContainerListener;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.ItemEntity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.entity.projectile.ArrowProjectile;
import net.minecraft.core.enums.EnumSleepStatus;
import net.minecraft.core.item.IComplexItem;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.net.packet.AnimatePacket;
import net.minecraft.core.net.packet.BlockRegionUpdatePacket;
import net.minecraft.core.net.packet.ChatPacket;
import net.minecraft.core.net.packet.ContainerClosePacket;
import net.minecraft.core.net.packet.ContainerOpenPacket;
import net.minecraft.core.net.packet.ContainerSetContentPacket;
import net.minecraft.core.net.packet.ContainerSetDataPacket;
import net.minecraft.core.net.packet.ContainerSetSlotPacket;
import net.minecraft.core.net.packet.FlagOpenPacket;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.core.net.packet.PlayerGamemodePacket;
import net.minecraft.core.net.packet.SetCarriedItemPacket;
import net.minecraft.core.net.packet.SetEquippedItemPacket;
import net.minecraft.core.net.packet.SetHealthPacket;
import net.minecraft.core.net.packet.SetHeldObjectPacket;
import net.minecraft.core.net.packet.SetHotbarOffsetPacket;
import net.minecraft.core.net.packet.SetRidingPacket;
import net.minecraft.core.net.packet.SleepPacket;
import net.minecraft.core.net.packet.StatisticPacket;
import net.minecraft.core.net.packet.TakeItemEntityPacket;
import net.minecraft.core.net.packet.UpdatePlayerProfilePacket;
import net.minecraft.core.player.gamemode.Gamemode;
import net.minecraft.core.player.inventory.container.Container;
import net.minecraft.core.player.inventory.menu.AbstractContainerMenu;
import net.minecraft.core.player.inventory.menu.ActivatorMenu;
import net.minecraft.core.player.inventory.menu.ContainerMenu;
import net.minecraft.core.player.inventory.menu.CraftingMenu;
import net.minecraft.core.player.inventory.menu.FlagMenu;
import net.minecraft.core.player.inventory.menu.FurnaceMenu;
import net.minecraft.core.player.inventory.menu.GuidebookMenu;
import net.minecraft.core.player.inventory.menu.InventoryMenu;
import net.minecraft.core.player.inventory.menu.TrapMenu;
import net.minecraft.core.player.inventory.menu.TrommelMenu;
import net.minecraft.core.player.inventory.slot.ResultSlot;
import net.minecraft.core.util.helper.AES;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.ICarriable;
import net.minecraft.core.world.IVehicle;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.ChunkCoordinate;
import net.minecraft.core.world.chunk.ChunkCoordinates;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.entity.EntityTracker;
import net.minecraft.server.net.handler.ServerPacketHandler;
import net.minecraft.server.world.ServerPlayerController;
import net.minecraft.server.world.WorldServer;
import org.jetbrains.annotations.Nullable;

public class ServerPlayer
extends Player
implements ContainerListener {
    public ServerPacketHandler playerNetServerHandler;
    public MinecraftServer mcServer;
    public ServerPlayerController playerController;
    public double viewingX;
    public double viewingZ;
    public List<ChunkCoordinate> loadedChunks;
    public Set<ChunkCoordinate> field_420_ah;
    private int lastHealth = -99999999;
    private int lastScore = -99999999;
    private int ticksOfInvuln = 60;
    private ItemStack[] playerInventory = new ItemStack[]{null, null, null, null, null};
    private int currentWindowId = 0;
    public boolean isChangingQuantityOnly;

    public ServerPlayer(MinecraftServer minecraftserver, World world, String username, UUID uuid, ServerPlayerController serverPlayerController) {
        super(world);
        this.loadedChunks = new LinkedList<ChunkCoordinate>();
        this.field_420_ah = new HashSet<ChunkCoordinate>();
        serverPlayerController.player = this;
        this.playerController = serverPlayerController;
        ChunkCoordinates chunkcoordinates = world.getSpawnPoint();
        int i = chunkcoordinates.x;
        int j = chunkcoordinates.z;
        int k = chunkcoordinates.y;
        if (!world.worldType.hasCeiling()) {
            k = world.findTopSolidBlock(i += this.random.nextInt(20) - 10, j);
            j += this.random.nextInt(20) - 10;
        }
        this.moveTo((double)i + 0.5, k, (double)j + 0.5, 0.0f, 0.0f);
        this.mcServer = minecraftserver;
        this.footSize = 0.0f;
        this.username = username;
        this.uuid = uuid;
        this.heightOffset = 0.0f;
        this.gamemode = minecraftserver.defaultGamemode;
    }

    @Override
    public void moveEntityWithHeading(float moveStrafing, float moveForward) {
        super.moveEntityWithHeading(moveStrafing, moveForward);
        if (this.noPhysics) {
            this.yd = 0.0;
            this.onGround = true;
            this.fallDistance = 0.0f;
            if (this.isSneaking()) {
                this.yd = -0.4;
            }
        }
    }

    @Override
    public void setGamemode(Gamemode gamemode) {
        this.mcServer.playerList.sendPacketToAllPlayers(new PlayerGamemodePacket(this.id, gamemode.getId()));
        this.gamemode = gamemode;
        InventoryMenu newContainer = gamemode.getContainer(this.inventory, !this.world.isClientSide);
        if (this.craftingInventory == this.inventorySlots) {
            this.craftingInventory = newContainer;
        }
        this.inventorySlots = newContainer;
        this.inventorySlots.addSlotListener(this);
        if (!gamemode.canPlayerFly()) {
            this.noPhysics = false;
        }
        this.fireImmune = gamemode.isImmuneToFire();
    }

    @Override
    public AABB getBb() {
        if (this.noPhysics) {
            return null;
        }
        return super.getBb();
    }

    @Override
    public void awardKillScore(Entity entity, int i) {
        super.awardKillScore(entity, i);
        this.mcServer.playerList.sendPacketToAllPlayers(new UpdatePlayerProfilePacket(this.username, this.nickname, this.uuid, this.score, this.chatColor, true, this.isOperator()));
    }

    public boolean isOperator() {
        return this.mcServer.playerList.isOp(this.uuid);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("Score", this.score);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.score = tag.getInteger("Score");
    }

    @Override
    public void setWorld(World world) {
        super.setWorld(world);
        this.playerController = new ServerPlayerController((WorldServer)world);
        this.playerController.player = this;
    }

    @Override
    public void animate4() {
    }

    public void setupCraftingInventoryListener() {
        this.craftingInventory.addSlotListener(this);
    }

    @Override
    @Nullable
    public @Nullable ItemStack @Nullable [] getInventory() {
        return this.playerInventory;
    }

    @Override
    protected void resetHeight() {
        this.heightOffset = 0.0f;
    }

    @Override
    public float getHeadHeight() {
        return this.getHeightOffset();
    }

    @Override
    public void tick() {
        this.playerController.tick();
        --this.ticksOfInvuln;
        this.craftingInventory.broadcastChanges();
        for (int i = 0; i < 5; ++i) {
            ItemStack itemstack = this.getEquipmentInSlot(i);
            if (itemstack == this.playerInventory[i]) continue;
            this.mcServer.getEntityTracker(this.dimension).sendPacketToTrackedPlayers(this, new SetEquippedItemPacket(this.id, i, itemstack));
            this.playerInventory[i] = itemstack;
        }
    }

    @Override
    public String getDisplayName() {
        String name = this.nickname;
        if (name.isEmpty()) {
            name = this.username;
        } else {
            Player player;
            ArrayList<ServerPlayer> players = new ArrayList<ServerPlayer>(MinecraftServer.getInstance().playerList.playerEntities);
            players.sort(new Player.SortByUsername());
            int nickNum = 0;
            Iterator iterator2 = players.iterator();
            while (iterator2.hasNext() && (player = (Player)iterator2.next()) != this) {
                if (!player.nickname.equals(this.nickname)) continue;
                ++nickNum;
            }
            name = TextFormatting.ITALIC + name;
            if (nickNum > 0) {
                name = name + " (" + nickNum + ")";
            }
        }
        return TextFormatting.get(this.chatColor) + name;
    }

    public ItemStack getEquipmentInSlot(int i) {
        if (i == 0) {
            return this.inventory.getCurrentItem();
        }
        return this.inventory.armorInventory[i - 1];
    }

    @Override
    public boolean hurt(Entity attacker, int i, DamageType type) {
        if (this.ticksOfInvuln > 0) {
            return false;
        }
        if (!this.mcServer.pvpOn) {
            if (attacker instanceof Player) {
                return false;
            }
            if (attacker instanceof ArrowProjectile) {
                ArrowProjectile entityarrow = (ArrowProjectile)attacker;
                if (entityarrow.owner instanceof Player) {
                    return false;
                }
            }
        }
        return super.hurt(attacker, i, type);
    }

    protected boolean isPVPEnabled() {
        return this.mcServer.pvpOn;
    }

    @Override
    public void heal(int i) {
        super.heal(i);
    }

    public void onUpdateEntity() {
        super.tick();
        for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
            Packet packet;
            ItemStack itemstack = this.inventory.getItem(i);
            if (itemstack == null || !(Item.itemsList[itemstack.itemID] instanceof IComplexItem) || this.playerNetServerHandler.getNumChunkDataPackets() > 2 || (packet = ((IComplexItem)((Object)Item.itemsList[itemstack.itemID])).sendPacketData(itemstack, this.world, this)) == null) continue;
            this.playerNetServerHandler.sendPacket(packet);
        }
        if (this.inPortal) {
            int targetDim = ((PortalBlock)Block.blocksList[this.portalID]).targetDimension;
            boolean netherAllowed = this.mcServer.propertyManager.getBooleanProperty("allow-nether", true);
            boolean paradiseAllowed = this.mcServer.propertyManager.getBooleanProperty("allow-paradise", false);
            if (netherAllowed && targetDim == Dimension.NETHER.id || paradiseAllowed && targetDim == Dimension.PARADISE.id || targetDim != Dimension.NETHER.id && targetDim != Dimension.PARADISE.id) {
                if (this.craftingInventory != this.inventorySlots) {
                    this.usePersonalCraftingInventory();
                }
                if (this.vehicle != null) {
                    this.startRiding(this.vehicle);
                } else {
                    this.timeInPortal += 0.0125f;
                    if (this.timeInPortal >= 1.0f || this.getGamemode().instantPortalTravel()) {
                        this.timeInPortal = 1.0f;
                        this.timeUntilPortal = 10;
                        if (this.dimension == targetDim) {
                            this.mcServer.playerList.sendPlayerToOtherDimension(this, 0, true);
                        } else {
                            this.mcServer.playerList.sendPlayerToOtherDimension(this, targetDim, true);
                        }
                    }
                }
                this.inPortal = false;
            }
        } else {
            if (this.timeInPortal > 0.0f) {
                this.timeInPortal -= 0.05f;
            }
            if (this.timeInPortal < 0.0f) {
                this.timeInPortal = 0.0f;
            }
        }
        if (this.timeUntilPortal > 0) {
            --this.timeUntilPortal;
        }
        if (this.getHealth() != this.lastHealth) {
            this.playerNetServerHandler.sendPacket(new SetHealthPacket(this.getHealth()));
            this.lastHealth = this.getHealth();
        }
        if (this.score != this.lastScore) {
            this.playerNetServerHandler.sendPacket(new UpdatePlayerProfilePacket(this.username, this.nickname, this.uuid, this.score, this.chatColor, true, this.isOperator()));
            this.lastScore = this.score;
        }
    }

    public void tickSendChunks() {
        ChunkCoordinate chunkCoord;
        if (!this.loadedChunks.isEmpty() && (chunkCoord = this.loadedChunks.get(0)) != null) {
            boolean canSendMoreDataPackets;
            boolean bl = canSendMoreDataPackets = this.playerNetServerHandler.getNumChunkDataPackets() < 8;
            if (canSendMoreDataPackets) {
                WorldServer worldserver = this.mcServer.getDimensionWorld(this.dimension);
                this.loadedChunks.remove(chunkCoord);
                this.playerNetServerHandler.sendPacket(new BlockRegionUpdatePacket(chunkCoord.x * 16, 0, chunkCoord.z * 16, 16, 256, 16, worldserver));
                List<BlockEntity> list = worldserver.getBlockEntitiesWithinBounds(chunkCoord.x * 16, 0, chunkCoord.z * 16, chunkCoord.x * 16 + 16, 256, chunkCoord.z * 16 + 16);
                for (int j = 0; j < list.size(); ++j) {
                    this.getTileEntityInfo(list.get(j));
                }
            }
        }
    }

    private void getTileEntityInfo(BlockEntity tileentity) {
        Packet packet;
        if (tileentity != null && (packet = tileentity.getDescriptionPacket()) != null) {
            this.playerNetServerHandler.sendPacket(packet);
        }
    }

    @Override
    public void onLivingUpdate() {
        super.onLivingUpdate();
        if (this.tickCount % 10 == 0) {
            Item arrow = this.getNextArrow();
            this.entityData.set(18, arrow == null ? -1 : arrow.id);
        }
    }

    @Override
    public void onItemPickup(Entity entity, ItemStack item) {
        if (!entity.removed) {
            EntityTracker entitytracker = this.mcServer.getEntityTracker(this.dimension);
            if (entity instanceof ItemEntity) {
                entitytracker.sendPacketToTrackedPlayers(entity, new TakeItemEntityPacket(entity.id, this.id));
            }
            if (entity instanceof ArrowProjectile) {
                entitytracker.sendPacketToTrackedPlayers(entity, new TakeItemEntityPacket(entity.id, this.id));
            }
        }
        super.onItemPickup(entity, item);
        this.craftingInventory.broadcastChanges();
    }

    @Override
    public void swingItem() {
        if (!this.isSwinging) {
            this.swingProgressInt = -1;
            this.isSwinging = true;
            EntityTracker entitytracker = this.mcServer.getEntityTracker(this.dimension);
            entitytracker.sendPacketToTrackedPlayers(this, new AnimatePacket(this, 1));
        }
    }

    public void func_22068_s() {
    }

    @Override
    public EnumSleepStatus sleepInBedAt(int x, int y, int z) {
        EnumSleepStatus status = super.sleepInBedAt(x, y, z);
        if (status == EnumSleepStatus.OK) {
            EntityTracker entitytracker = this.mcServer.getEntityTracker(this.dimension);
            SleepPacket sleepPacket = new SleepPacket(this, 0, x, y, z);
            entitytracker.sendPacketToTrackedPlayers(this, sleepPacket);
            this.playerNetServerHandler.teleportAndRotate(this.x, this.y, this.z, this.yRot, this.xRot);
            this.playerNetServerHandler.sendPacket(sleepPacket);
        }
        return status;
    }

    @Override
    public void wakeUpPlayer(boolean flag, boolean flag1) {
        if (this.isPlayerSleeping()) {
            EntityTracker entitytracker = this.mcServer.getEntityTracker(this.dimension);
            entitytracker.sendPacketToTrackedPlayersAndTrackedEntity(this, new AnimatePacket(this, 3));
            super.wakeUpPlayer(flag, flag1);
        }
        if (this.playerNetServerHandler != null) {
            this.playerNetServerHandler.teleportAndRotate(this.x, this.y, this.z, this.yRot, this.xRot);
        }
    }

    @Override
    public void startRiding(IVehicle vehicle) {
        if (!this.canRide()) {
            return;
        }
        if (this.vehicle == vehicle) {
            return;
        }
        super.startRiding(vehicle);
        if (vehicle instanceof Entity) {
            this.playerNetServerHandler.sendPacket(new SetRidingPacket(this, (Entity)this.vehicle));
        } else if (vehicle instanceof BlockEntity) {
            BlockEntity blockEntity = (BlockEntity)((Object)vehicle);
            this.playerNetServerHandler.sendPacket(new SetRidingPacket(this, blockEntity.x, blockEntity.y, blockEntity.z));
        }
        this.playerNetServerHandler.teleport(this.x, this.y, this.z);
    }

    @Override
    protected void checkFallDamage(double yd, boolean onGround) {
    }

    public void handleFalling(double dy, boolean onGround) {
        super.checkFallDamage(dy, onGround);
    }

    private void getNextWindowId() {
        this.currentWindowId = this.currentWindowId % 100 + 1;
    }

    @Override
    public void displayWorkbenchScreen(int x, int y, int z) {
        this.getNextWindowId();
        this.playerNetServerHandler.sendPacket(new ContainerOpenPacket(this.currentWindowId, 1, "Crafting", 9));
        this.craftingInventory = new CraftingMenu(this.inventory, this.world, x, y, z);
        this.craftingInventory.containerId = this.currentWindowId;
        this.craftingInventory.addSlotListener(this);
    }

    @Override
    public void displayPaintingPickerScreen() {
        this.playerNetServerHandler.sendPacket(new ContainerOpenPacket(this.currentWindowId, 7, "Painting", 0));
    }

    @Override
    public void displayContainerScreen(Container container) {
        this.getNextWindowId();
        ServerPacketHandler.LOGGER.info("{} interacted with chest at ({}, {}, {})", this.username, this.x, this.y, this.z);
        this.playerNetServerHandler.sendPacket(new ContainerOpenPacket(this.currentWindowId, 0, container.getName(), container.getContainerSize()));
        this.craftingInventory = new ContainerMenu(this.inventory, container);
        this.craftingInventory.containerId = this.currentWindowId;
        this.craftingInventory.addSlotListener(this);
    }

    @Override
    public void displayFurnaceScreen(FurnaceBlockEntity blockEntity) {
        this.getNextWindowId();
        if (blockEntity instanceof BlastFurnaceBlockEntity) {
            this.playerNetServerHandler.sendPacket(new ContainerOpenPacket(this.currentWindowId, 4, blockEntity.getName(), blockEntity.getContainerSize()));
        } else {
            this.playerNetServerHandler.sendPacket(new ContainerOpenPacket(this.currentWindowId, 2, blockEntity.getName(), blockEntity.getContainerSize()));
        }
        this.craftingInventory = new FurnaceMenu(this.inventory, blockEntity);
        this.craftingInventory.containerId = this.currentWindowId;
        this.craftingInventory.addSlotListener(this);
    }

    @Override
    public void displayDispenserScreen(DispenserBlockEntity blockEntity) {
        this.getNextWindowId();
        this.playerNetServerHandler.sendPacket(new ContainerOpenPacket(this.currentWindowId, 3, blockEntity.getName(), blockEntity.getContainerSize()));
        this.craftingInventory = new TrapMenu(this.inventory, blockEntity);
        this.craftingInventory.containerId = this.currentWindowId;
        this.craftingInventory.addSlotListener(this);
    }

    @Override
    public void displayActivatorScreen(ActivatorBlockEntity blockEntity) {
        this.getNextWindowId();
        this.playerNetServerHandler.sendPacket(new ContainerOpenPacket(this.currentWindowId, 6, blockEntity.getName(), blockEntity.getContainerSize()));
        this.craftingInventory = new ActivatorMenu(this.inventory, blockEntity);
        this.craftingInventory.containerId = this.currentWindowId;
        this.craftingInventory.addSlotListener(this);
    }

    @Override
    public void displayTrommelScreen(TrommelBlockEntity blockEntity) {
        this.getNextWindowId();
        this.playerNetServerHandler.sendPacket(new ContainerOpenPacket(this.currentWindowId, 5, blockEntity.getName(), blockEntity.getContainerSize()));
        this.craftingInventory = new TrommelMenu(this.inventory, blockEntity);
        this.craftingInventory.containerId = this.currentWindowId;
        this.craftingInventory.addSlotListener(this);
    }

    @Override
    public void displayFlagEditorScreen(FlagBlockEntity blockEntity) {
        this.getNextWindowId();
        this.playerNetServerHandler.sendPacket(new FlagOpenPacket(this.currentWindowId, blockEntity.x, blockEntity.y, blockEntity.z));
        this.craftingInventory = new FlagMenu(this.inventory, blockEntity);
        this.craftingInventory.containerId = this.currentWindowId;
        this.craftingInventory.addSlotListener(this);
    }

    public void displayGUIGuidebook() {
        this.getNextWindowId();
        this.craftingInventory = new GuidebookMenu();
        this.craftingInventory.containerId = this.currentWindowId;
        this.craftingInventory.addSlotListener(this);
    }

    @Override
    public void updateInventorySlot(AbstractContainerMenu container, int i, ItemStack itemstack) {
        if (container.getSlot(i) instanceof ResultSlot) {
            return;
        }
        if (this.isChangingQuantityOnly) {
            return;
        }
        if (this.playerNetServerHandler != null) {
            this.playerNetServerHandler.sendPacket(new ContainerSetSlotPacket(container.containerId, i, itemstack));
        }
    }

    public void initializeCraftingInventory(AbstractContainerMenu container) {
        this.updateCraftingInventory(container, container.getSlotStackList());
    }

    @Override
    public void updateCraftingInventory(AbstractContainerMenu container, List<ItemStack> list) {
        if (this.playerNetServerHandler != null) {
            this.playerNetServerHandler.sendPacket(new ContainerSetContentPacket(container.containerId, list));
        }
    }

    @Override
    public void updateCraftingInventoryInfo(AbstractContainerMenu container, int id, int value) {
        this.playerNetServerHandler.sendPacket(new ContainerSetDataPacket(container.containerId, id, value));
    }

    @Override
    public void onItemStackChanged(ItemStack itemstack) {
    }

    public void usePersonalCraftingInventory() {
        this.playerNetServerHandler.sendPacket(new ContainerClosePacket(this.craftingInventory.containerId));
        this.closeCraftingGui();
    }

    public void updateHeldItem() {
        if (this.isChangingQuantityOnly) {
            return;
        }
        this.playerNetServerHandler.sendPacket(new ContainerSetSlotPacket(-1, -1, this.inventory.getHeldItemStack()));
    }

    public void closeCraftingGui() {
        this.craftingInventory.onCraftGuiClosed(this);
        this.craftingInventory = this.inventorySlots;
    }

    public void setMovementType(float f, float f1, boolean flag, boolean flag1, float f2, float f3) {
        this.moveStrafing = f;
        this.moveForward = f1;
        this.isJumping = flag;
        this.setSneaking(flag1);
        this.xRot = f2;
        this.yRot = f3;
    }

    @Override
    public void addStat(Stat stat, int i) {
        if (stat == null) {
            return;
        }
        if (!stat.clientside) {
            while (i > 100) {
                this.playerNetServerHandler.sendPacket(new StatisticPacket(stat.statId, 100));
                i -= 100;
            }
            if (i > 0) {
                this.playerNetServerHandler.sendPacket(new StatisticPacket(stat.statId, i));
            }
        }
    }

    public void func_30002_A() {
        if (this.vehicle != null) {
            this.startRiding(this.vehicle);
        }
        if (this.passenger != null) {
            this.passenger.startRiding(this);
        }
        if (this.sleeping) {
            this.wakeUpPlayer(true, false);
        }
    }

    public void initializeLastFieldValues() {
        this.lastHealth = Integer.MIN_VALUE;
        this.lastScore = Integer.MIN_VALUE;
    }

    public void func_22061_a(String s) {
        I18n stringtranslate = I18n.getInstance();
        String s1 = stringtranslate.translateKey(s);
        this.playerNetServerHandler.sendPacket(new ChatPacket(s1));
    }

    @Override
    public void setCurrentItem(int i) {
        super.setCurrentItem(i);
        this.playerNetServerHandler.sendPacket(new SetCarriedItemPacket(i));
    }

    @Override
    public void setHeldObject(@Nullable ICarriable heldObject) {
        super.setHeldObject(heldObject);
        this.mcServer.getEntityTracker(this.dimension).sendPacketToTrackedPlayers(this, new SetHeldObjectPacket(this.id, heldObject));
        this.playerNetServerHandler.sendPacket(new SetHotbarOffsetPacket(this.inventory.getHotbarOffset()));
        this.playerNetServerHandler.sendPacket(new SetCarriedItemPacket(this.inventory.getCurrentItemIndex()));
    }

    @Override
    public void sendMessage(String message) {
        this.playerNetServerHandler.sendPacket(new ChatPacket(message, 0, AES.keyChain.get(this.username)));
    }

    @Override
    public void sendStatusMessage(String message) {
        this.playerNetServerHandler.sendPacket(new ChatPacket(message, 1, AES.keyChain.get(this.username)));
    }

    public void teleport(double x, double y, double z, float xr, float yr) {
        this.playerNetServerHandler.teleportAndRotate(x, y, z, xr, yr);
    }
}

