/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.net;

import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.achievement.Achievements;
import net.minecraft.core.block.entity.BlockEntity;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.net.packet.BedMessagePacket;
import net.minecraft.core.net.packet.ChatPacket;
import net.minecraft.core.net.packet.GameRulePacket;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.core.net.packet.PlayerGamemodePacket;
import net.minecraft.core.net.packet.RespawnPacket;
import net.minecraft.core.net.packet.SetTimePacket;
import net.minecraft.core.util.helper.AES;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.UUIDHelper;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.PortalHandler;
import net.minecraft.core.world.chunk.ChunkCoordinates;
import net.minecraft.core.world.save.PlayerIO;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.entity.player.ServerPlayer;
import net.minecraft.server.net.handler.LoginPacketHandler;
import net.minecraft.server.player.PlayerManager;
import net.minecraft.server.world.ServerPlayerController;
import net.minecraft.server.world.WorldServer;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class PlayerList {
    public static Logger logger = LogUtils.getLogger();
    public List<ServerPlayer> playerEntities;
    private final MinecraftServer server;
    private final Map<Integer, PlayerManager> playerManagers;
    private final Set<UUID> bans;
    private final Set<String> ipBans;
    private final Set<UUID> ops;
    private final Set<UUID> whitelist;
    private final File bansFile;
    private final File ipBansFile;
    private final File opsFile;
    private final File whitelistFile;
    private PlayerIO playerIo;
    public boolean whitelistEnforced;
    AtomicInteger awaitedLoadThreads = new AtomicInteger(0);

    public PlayerList(MinecraftServer server) {
        this.playerEntities = new ArrayList<ServerPlayer>();
        this.bans = new HashSet<UUID>();
        this.ipBans = new HashSet<String>();
        this.ops = new HashSet<UUID>();
        this.whitelist = new HashSet<UUID>();
        this.playerManagers = new HashMap<Integer, PlayerManager>();
        this.server = server;
        this.bansFile = server.getFile("banned-players.txt");
        this.ipBansFile = server.getFile("banned-ips.txt");
        this.opsFile = server.getFile("ops.txt");
        this.whitelistFile = server.getFile("white-list.txt");
        int viewDistance = server.propertyManager.getIntProperty("view-distance", 10);
        for (Integer dim : Dimension.getDimensionList().keySet()) {
            this.playerManagers.put(dim, new PlayerManager(server, dim, viewDistance));
        }
        this.whitelistEnforced = server.propertyManager.getBooleanProperty("white-list", false);
        this.loadBannedPlayers();
        this.loadBannedList();
        this.loadOps();
        this.loadWhiteList();
        this.saveBannedPlayers();
        this.saveBannedList();
        this.saveOps();
        this.saveWhiteList();
        if (this.awaitedLoadThreads.get() > 0) {
            new Thread(() -> {
                long startTime = System.currentTimeMillis();
                while (this.awaitedLoadThreads.get() > 0) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        break;
                    }
                    if (System.currentTimeMillis() - startTime <= 600000L) continue;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                this.saveBannedPlayers();
                this.saveBannedList();
                this.saveOps();
                this.saveWhiteList();
            }).start();
        }
    }

    public void setPlayerManager(Map<Integer, WorldServer> worldServerMap) {
        this.playerIo = worldServerMap.get(0).getSaveHandler().getPlayerFileData();
    }

    public void syncPlayerDimension(ServerPlayer player) {
        for (PlayerManager playerManager : this.playerManagers.values()) {
            playerManager.removePlayer(player);
        }
        this.getPlayerManager(player.dimension).addPlayer(player);
        WorldServer world = this.server.getDimensionWorld(player.dimension);
        world.chunkProviderServer.prepareChunk((int)player.x >> 4, (int)player.z >> 4);
    }

    public int getMaxTrackingDistance() {
        return this.playerManagers.get(0).getMaxTrackingDistance();
    }

    public PlayerManager getPlayerManager(int dim) {
        return this.playerManagers.get(dim);
    }

    public void load(ServerPlayer player) {
        this.playerIo.load(player);
    }

    public void playerLoggedIn(ServerPlayer player) {
        this.playerEntities.add(player);
        player.playerNetServerHandler.handleSendInitialPlayerList();
        WorldServer world = this.server.getDimensionWorld(player.dimension);
        world.chunkProviderServer.prepareChunk((int)player.x >> 4, (int)player.z >> 4);
        if (!world.getWorldType().hasCeiling()) {
            while (world.getCollidingSolidBlockBoundingBoxes(player, player.bb).size() != 0) {
                player.setPos(player.x, player.y + 1.0, player.z);
            }
        }
        world.entityJoinedWorld(player);
        this.getPlayerManager(player.dimension).addPlayer(player);
    }

    public void onPlayerMoved(ServerPlayer player) {
        this.getPlayerManager(player.dimension).onPlayerMoved(player);
    }

    public void playerLoggedOut(ServerPlayer entityplayermp) {
        this.playerIo.save(entityplayermp);
        this.server.getDimensionWorld(entityplayermp.dimension).setEntityDead(entityplayermp);
        this.playerEntities.remove(entityplayermp);
        this.getPlayerManager(entityplayermp.dimension).removePlayer(entityplayermp);
    }

    public ServerPlayer getPlayerForLogin(LoginPacketHandler handler, String username, UUID uuid) {
        if (this.bans.contains(uuid)) {
            handler.kickUser("You are banned from this server!");
            return null;
        }
        if (!this.isAllowedToLogin(uuid)) {
            handler.kickUser("You are not white-listed on this server!");
            return null;
        }
        String ip = handler.netManager.getRemoteAddress().toString();
        ip = ip.substring(ip.indexOf("/") + 1);
        if (this.ipBans.contains(ip = ip.substring(0, ip.indexOf(":")))) {
            handler.kickUser("Your IP address is banned from this server!");
            return null;
        }
        if (this.playerEntities.size() >= MinecraftServer.getInstance().maxPlayers) {
            handler.kickUser("The server is full!");
            return null;
        }
        ArrayList<ServerPlayer> playerListCopy = new ArrayList<ServerPlayer>(this.playerEntities);
        for (ServerPlayer player : playerListCopy) {
            if (!player.username.equalsIgnoreCase(username) && !player.uuid.equals(uuid)) continue;
            player.playerNetServerHandler.kickPlayer("You are logged in from another location!");
        }
        return new ServerPlayer(this.server, this.server.getDimensionWorld(0), username, uuid, new ServerPlayerController(this.server.getDimensionWorld(0)));
    }

    public ServerPlayer recreatePlayerEntity(ServerPlayer previousPlayer, int i) {
        this.server.getEntityTracker(previousPlayer.dimension).removeTrackedPlayerSymmetric(previousPlayer);
        this.server.getEntityTracker(previousPlayer.dimension).untrackEntity(previousPlayer);
        this.getPlayerManager(previousPlayer.dimension).removePlayer(previousPlayer);
        this.playerEntities.remove(previousPlayer);
        this.server.getDimensionWorld(previousPlayer.dimension).removePlayer(previousPlayer);
        ChunkCoordinates chunkcoordinates = previousPlayer.getPlayerSpawnCoordinate();
        previousPlayer.dimension = i;
        ServerPlayer newPlayer = new ServerPlayer(this.server, this.server.getDimensionWorld(previousPlayer.dimension), previousPlayer.username, previousPlayer.uuid, new ServerPlayerController(this.server.getDimensionWorld(previousPlayer.dimension)));
        newPlayer.id = previousPlayer.id;
        newPlayer.chatColor = previousPlayer.chatColor;
        newPlayer.nickname = previousPlayer.nickname;
        newPlayer.gamemode = previousPlayer.gamemode;
        newPlayer.playerNetServerHandler = previousPlayer.playerNetServerHandler;
        newPlayer.inventory.transferAllContents(previousPlayer.inventory);
        WorldServer worldserver = this.server.getDimensionWorld(previousPlayer.dimension);
        if (chunkcoordinates != null) {
            ChunkCoordinates chunkcoordinates1 = Player.getValidBedSpawnCoordinates(this.server.getDimensionWorld(previousPlayer.dimension), chunkcoordinates);
            if (chunkcoordinates1 != null) {
                newPlayer.teleport((float)chunkcoordinates1.x + 0.5f, (float)chunkcoordinates1.y + 0.1f, (float)chunkcoordinates1.z + 0.5f, 0.0f, 0.0f);
                newPlayer.setPlayerSpawnCoordinate(chunkcoordinates);
            } else {
                newPlayer.playerNetServerHandler.sendPacket(new BedMessagePacket(0));
            }
        }
        worldserver.chunkProviderServer.prepareChunk((int)newPlayer.x >> 4, (int)newPlayer.z >> 4);
        while (worldserver.getCubes(newPlayer, newPlayer.bb).size() != 0) {
            newPlayer.setPos(newPlayer.x, newPlayer.y + 1.0, newPlayer.z);
        }
        newPlayer.playerNetServerHandler.sendPacket(new RespawnPacket((byte)newPlayer.dimension, (byte)Registries.WORLD_TYPES.getNumericIdOfItem(worldserver.worldType)));
        this.server.playerList.sendPacketToAllPlayers(new PlayerGamemodePacket(newPlayer.id, newPlayer.gamemode.getId()));
        newPlayer.playerNetServerHandler.teleportAndRotate(newPlayer.x, newPlayer.y, newPlayer.z, newPlayer.yRot, newPlayer.xRot);
        this.setTime(newPlayer, worldserver);
        this.getPlayerManager(newPlayer.dimension).addPlayer(newPlayer);
        worldserver.entityJoinedWorld(newPlayer);
        this.playerEntities.add(newPlayer);
        newPlayer.setupCraftingInventoryListener();
        newPlayer.func_22068_s();
        newPlayer.playerNetServerHandler.sendPacket(new GameRulePacket(this.server.getDimensionWorld(0).getLevelData().getGameRules()));
        return newPlayer;
    }

    public void sendPlayerToOtherDimension(ServerPlayer serverPlayer, int targetDim, boolean generatePortal) {
        double dz;
        double dy;
        double dx;
        double distSqr;
        WorldServer worldserver = this.server.getDimensionWorld(serverPlayer.dimension);
        Dimension lastDim = Dimension.getDimensionList().get(serverPlayer.dimension);
        Dimension newDim = Dimension.getDimensionList().get(targetDim);
        serverPlayer.dimension = targetDim;
        WorldServer worldserver1 = this.server.getDimensionWorld(serverPlayer.dimension);
        serverPlayer.playerNetServerHandler.sendPacket(new RespawnPacket((byte)serverPlayer.dimension, (byte)Registries.WORLD_TYPES.getNumericIdOfItem(worldserver1.worldType)));
        worldserver.removePlayer(serverPlayer);
        serverPlayer.removed = false;
        double x = serverPlayer.x;
        double y = serverPlayer.y;
        double z = serverPlayer.z;
        serverPlayer.teleport(x *= (double)Dimension.getCoordScale(lastDim, newDim), y, z *= (double)Dimension.getCoordScale(lastDim, newDim), serverPlayer.yRot, serverPlayer.xRot);
        ChunkCoordinates newCoordinates = new ChunkCoordinates(MathHelper.floor(x), MathHelper.floor(y), MathHelper.floor(z));
        if (serverPlayer.dimensionEnterCoordinate != null && (distSqr = (dx = (double)serverPlayer.dimensionEnterCoordinate.x - x) * dx + (dy = (double)serverPlayer.dimensionEnterCoordinate.y - y) * dy + (dz = (double)serverPlayer.dimensionEnterCoordinate.z - z) * dz) > 6.4E7) {
            serverPlayer.addStat(Achievements.FAST_TRAVEL, 1);
        }
        serverPlayer.dimensionEnterCoordinate = newCoordinates;
        if (serverPlayer.isAlive()) {
            worldserver.updateEntityWithOptionalForce(serverPlayer, false);
        }
        if (serverPlayer.isAlive()) {
            worldserver1.entityJoinedWorld(serverPlayer);
            serverPlayer.teleport(x, serverPlayer.y, z, serverPlayer.yRot, serverPlayer.xRot);
            worldserver1.updateEntityWithOptionalForce(serverPlayer, false);
            if (generatePortal) {
                worldserver1.chunkProviderServer.chunkLoadOverride = true;
                new PortalHandler().teleportEntity(worldserver1, serverPlayer, lastDim, newDim);
                worldserver1.chunkProviderServer.chunkLoadOverride = false;
            }
        }
        this.syncPlayerDimension(serverPlayer);
        serverPlayer.playerNetServerHandler.teleportAndRotate(serverPlayer.x, serverPlayer.y, serverPlayer.z, serverPlayer.yRot, serverPlayer.xRot);
        this.server.playerList.sendPacketToAllPlayers(new PlayerGamemodePacket(serverPlayer.id, serverPlayer.gamemode.getId()));
        serverPlayer.setWorld(worldserver1);
        this.setTime(serverPlayer, worldserver1);
        this.initializePlayerObject(serverPlayer);
        serverPlayer.playerNetServerHandler.sendPacket(new GameRulePacket(this.server.getDimensionWorld(0).getLevelData().getGameRules()));
    }

    public void onTick() {
        for (PlayerManager playerManager : this.playerManagers.values()) {
            playerManager.tick();
        }
    }

    public void markBlockNeedsUpdate(int x, int y, int z, int dimension) {
        this.getPlayerManager(dimension).markBlockNeedsUpdate(x, y, z);
    }

    public void sendPacketToAllPlayers(Packet packet) {
        for (ServerPlayer player : this.playerEntities) {
            player.playerNetServerHandler.sendPacket(packet);
        }
    }

    public void sendEncryptedChatToAllPlayers(String message) {
        for (ServerPlayer player : this.playerEntities) {
            player.playerNetServerHandler.sendPacket(new ChatPacket(message, 0, AES.keyChain.get(player.username)));
        }
    }

    public void sendPacketToAllPlayersInDimension(Packet packet, int i) {
        for (ServerPlayer player : this.playerEntities) {
            if (player.dimension != i) continue;
            player.playerNetServerHandler.sendPacket(packet);
        }
    }

    public String getPlayerList() {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < this.playerEntities.size(); ++i) {
            if (i > 0) {
                s.append(", ");
            }
            s.append(this.playerEntities.get(i).getDisplayName());
        }
        return s.toString();
    }

    public synchronized void banPlayer(UUID uuid) {
        this.bans.add(uuid);
        this.saveBannedPlayers();
    }

    public synchronized void pardonPlayer(UUID uuid) {
        this.bans.remove(uuid);
        this.saveBannedPlayers();
    }

    private synchronized void loadBannedPlayers() {
        try {
            String s;
            this.bans.clear();
            BufferedReader bufferedreader = new BufferedReader(new FileReader(this.bansFile));
            while ((s = bufferedreader.readLine()) != null) {
                if (!UUIDHelper.isUUID(s)) {
                    this.awaitedLoadThreads.addAndGet(1);
                    UUIDHelper.runConversionAction(s, uuid -> {
                        this.bans.add(uuid);
                        this.awaitedLoadThreads.addAndGet(-1);
                    }, username -> this.awaitedLoadThreads.addAndGet(-1));
                    continue;
                }
                this.bans.add(UUID.fromString(s));
            }
            bufferedreader.close();
        }
        catch (Exception exception) {
            logger.warn("Failed to load ban list: " + exception);
        }
    }

    private synchronized void saveBannedPlayers() {
        try {
            PrintWriter printwriter = new PrintWriter(new FileWriter(this.bansFile, false));
            for (UUID uuid : this.bans) {
                printwriter.println(uuid);
            }
            printwriter.close();
        }
        catch (Exception exception) {
            logger.warn("Failed to save ban list: " + exception);
        }
    }

    public synchronized void banIP(String s) {
        this.ipBans.add(s.toLowerCase());
        this.saveBannedList();
    }

    public synchronized void pardonIP(String s) {
        this.ipBans.remove(s.toLowerCase());
        this.saveBannedList();
    }

    private synchronized void loadBannedList() {
        try {
            String ip;
            this.ipBans.clear();
            BufferedReader bufferedreader = new BufferedReader(new FileReader(this.ipBansFile));
            while ((ip = bufferedreader.readLine()) != null) {
                this.ipBans.add(ip.trim().toLowerCase());
            }
            bufferedreader.close();
        }
        catch (Exception exception) {
            logger.warn("Failed to load ip ban list: " + exception);
        }
    }

    private synchronized void saveBannedList() {
        try {
            PrintWriter printwriter = new PrintWriter(new FileWriter(this.ipBansFile, false));
            for (String ip : this.ipBans) {
                printwriter.println(ip);
            }
            printwriter.close();
        }
        catch (Exception exception) {
            logger.warn("Failed to save ip ban list: " + exception);
        }
    }

    public synchronized void opPlayer(UUID uuid) {
        this.ops.add(uuid);
        this.saveOps();
    }

    public synchronized void deopPlayer(UUID uuid) {
        this.ops.remove(uuid);
        this.saveOps();
    }

    private synchronized void loadOps() {
        try {
            String entry;
            this.ops.clear();
            BufferedReader bufferedreader = new BufferedReader(new FileReader(this.opsFile));
            while ((entry = bufferedreader.readLine()) != null) {
                if (!UUIDHelper.isUUID(entry)) {
                    this.awaitedLoadThreads.addAndGet(1);
                    UUIDHelper.runConversionAction(entry, uuid -> {
                        this.ops.add(uuid);
                        this.awaitedLoadThreads.addAndGet(-1);
                    }, username -> this.awaitedLoadThreads.addAndGet(-1));
                    continue;
                }
                this.ops.add(UUID.fromString(entry));
            }
            bufferedreader.close();
        }
        catch (Exception exception) {
            logger.warn("Failed to load ip ban list: " + exception);
        }
    }

    private synchronized void saveOps() {
        try {
            PrintWriter printwriter = new PrintWriter(new FileWriter(this.opsFile, false));
            for (UUID uuid : this.ops) {
                printwriter.println(uuid.toString());
            }
            printwriter.close();
        }
        catch (Exception exception) {
            logger.warn("Failed to save ip ban list: " + exception);
        }
    }

    private synchronized void loadWhiteList() {
        try {
            String entry;
            this.whitelist.clear();
            BufferedReader bufferedreader = new BufferedReader(new FileReader(this.whitelistFile));
            while ((entry = bufferedreader.readLine()) != null) {
                if (!UUIDHelper.isUUID(entry)) {
                    this.awaitedLoadThreads.addAndGet(1);
                    UUIDHelper.runConversionAction(entry, uuid -> {
                        this.whitelist.add(uuid);
                        this.awaitedLoadThreads.addAndGet(-1);
                    }, username -> this.awaitedLoadThreads.addAndGet(-1));
                    continue;
                }
                this.whitelist.add(UUID.fromString(entry));
            }
            bufferedreader.close();
        }
        catch (Exception exception) {
            logger.warn("Failed to load white-list: " + exception);
        }
    }

    private synchronized void saveWhiteList() {
        try {
            PrintWriter printwriter = new PrintWriter(new FileWriter(this.whitelistFile, false));
            for (UUID uuid : this.whitelist) {
                printwriter.println(uuid.toString());
            }
            printwriter.close();
        }
        catch (Exception exception) {
            logger.warn("Failed to save white-list: " + exception);
        }
    }

    public boolean isAllowedToLogin(UUID uuid) {
        return !this.whitelistEnforced || this.ops.contains(uuid) || this.whitelist.contains(uuid);
    }

    public boolean isOp(UUID uuid) {
        return this.ops.contains(uuid);
    }

    @Nullable
    public ServerPlayer getPlayerEntity(String s) {
        for (ServerPlayer player : this.playerEntities) {
            if (!player.username.equalsIgnoreCase(s)) continue;
            return player;
        }
        return null;
    }

    public void sendChatMessageToPlayer(String s, String s1) {
        ServerPlayer player = this.getPlayerEntity(s);
        if (player != null) {
            player.playerNetServerHandler.sendPacket(new ChatPacket(s1));
        }
    }

    public void sendPacketToPlayersAroundPoint(double x, double y, double z, double radius, int dimension, Packet packet) {
        this.sendPacketToOtherPlayersAroundPoint(null, x, y, z, radius, dimension, packet);
    }

    public void sendPacketToOtherPlayersAroundPoint(Player player, double x, double y, double z, double radius, int dimension, Packet packet) {
        for (ServerPlayer otherPlayer : this.playerEntities) {
            double dz;
            double dy;
            double dx;
            if (otherPlayer == player || otherPlayer.dimension != dimension || !((dx = x - otherPlayer.x) * dx + (dy = y - otherPlayer.y) * dy + (dz = z - otherPlayer.z) * dz < radius * radius)) continue;
            otherPlayer.playerNetServerHandler.sendPacket(packet);
        }
    }

    public void sendChatMessageToAllOps(String s) {
        ChatPacket chatPacket = new ChatPacket(s);
        for (ServerPlayer player : this.playerEntities) {
            if (!this.isOp(player.uuid)) continue;
            player.playerNetServerHandler.sendPacket(chatPacket);
        }
    }

    public boolean sendPacketToPlayer(String s, Packet packet) {
        ServerPlayer player = this.getPlayerEntity(s);
        if (player != null) {
            player.playerNetServerHandler.sendPacket(packet);
            return true;
        }
        return false;
    }

    public void savePlayerStates() {
        for (ServerPlayer playerEntity : this.playerEntities) {
            this.playerIo.save(playerEntity);
        }
    }

    public void sendBlockEntityToPlayer(int x, int y, int z, BlockEntity blockEntity) {
    }

    public synchronized void addToWhiteList(UUID uuid) {
        this.whitelist.add(uuid);
        this.saveWhiteList();
    }

    public synchronized void removeFromWhiteList(UUID uuid) {
        this.whitelist.remove(uuid);
        this.saveWhiteList();
    }

    public Set<UUID> getWhitelist() {
        return this.whitelist;
    }

    public void reloadWhiteList() {
        this.loadWhiteList();
    }

    public void setTime(ServerPlayer player, WorldServer worldserver) {
        player.playerNetServerHandler.sendPacket(new SetTimePacket(worldserver.getWorldTime()));
    }

    public void initializePlayerObject(ServerPlayer player) {
        player.initializeCraftingInventory(player.inventorySlots);
        player.initializeLastFieldValues();
    }
}

