/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.net.command;

import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.net.command.CommandSource;
import net.minecraft.core.net.packet.ChatPacket;
import net.minecraft.core.util.helper.AES;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.phys.Vec3;
import net.minecraft.core.world.World;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.entity.player.ServerPlayer;
import net.minecraft.server.net.command.IServerCommandSource;
import org.jetbrains.annotations.NotNull;

public class ServerCommandSource
implements CommandSource,
IServerCommandSource {
    public final MinecraftServer server;
    public final ServerPlayer player;

    public ServerCommandSource(MinecraftServer server, ServerPlayer player) {
        this.server = server;
        this.player = player;
    }

    @Override
    public Collection<String> getPlayerNames() {
        ArrayList<String> list = new ArrayList<String>();
        for (Player player : this.server.playerList.playerEntities) {
            list.add(player.username);
        }
        return list;
    }

    @Override
    public Collection<String> getEntitySuggestions() {
        return this.getPlayerNames();
    }

    @Override
    public String toString() {
        return "ServerCommandSource{" + this.server + ", " + this.player + "}";
    }

    @Override
    @NotNull
    public Player getSender() {
        return this.player;
    }

    @Override
    public boolean hasAdmin() {
        return this.server.playerList.isOp(this.getSender().uuid);
    }

    @Override
    @NotNull
    public Vec3 getCoordinates(boolean offsetHeight) {
        Vec3 position = this.getSender().getPosition(1.0f, false);
        if (offsetHeight) {
            return position.add(0.0, -this.getSender().heightOffset, 0.0);
        }
        return position;
    }

    @Override
    @NotNull
    public Vec3 getBlockCoordinates() {
        Vec3 coordinates = this.getCoordinates(true);
        return Vec3.getTempVec3(MathHelper.floor(coordinates.x), MathHelper.floor(coordinates.y), MathHelper.floor(coordinates.z));
    }

    @Override
    public boolean messageMayBeMultiline() {
        return !this.getSender().username.equals("pr_ib");
    }

    @Override
    public void sendMessage(String message) {
        this.player.playerNetServerHandler.sendPacket(new ChatPacket(message, AES.keyChain.get(this.player.username)));
    }

    @Override
    public void sendMessage(Player player, String message) {
        this.server.playerList.sendPacketToPlayer(player.username, new ChatPacket(message, AES.keyChain.get(player.username)));
    }

    @Override
    public void sendMessageToAllPlayers(String message) {
        this.getServer().playerList.sendPacketToAllPlayers(new ChatPacket(message));
    }

    @Override
    public World getWorld() {
        return this.player == null ? this.server.getDimensionWorld(0) : this.player.world;
    }

    @Override
    public World getWorld(int dimension) {
        return this.server.getDimensionWorld(dimension);
    }

    @Override
    public void movePlayerToDimension(Player player, int dimension) {
        if (!(player instanceof ServerPlayer)) {
            throw new IllegalStateException("Player is not an instance of ServerPlayer");
        }
        this.server.playerList.sendPlayerToOtherDimension((ServerPlayer)player, dimension, false);
    }

    @Override
    public String getName() {
        return this.player.username;
    }

    @Override
    public MinecraftServer getServer() {
        return this.server;
    }
}

