/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.net.handler;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.block.entity.BlockEntity;
import net.minecraft.core.block.entity.FlagBlockEntity;
import net.minecraft.core.block.entity.MobSpawnerBlockEntity;
import net.minecraft.core.block.entity.SignBlockEntity;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.vehicle.BoatEntity;
import net.minecraft.core.enums.ArtType;
import net.minecraft.core.enums.EnumSignPicture;
import net.minecraft.core.enums.PlacementMode;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.net.ChatEmotes;
import net.minecraft.core.net.ICommandListener;
import net.minecraft.core.net.NetworkManager;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.net.handler.PacketHandler;
import net.minecraft.core.net.packet.AnimatePacket;
import net.minecraft.core.net.packet.BlockUpdatePacket;
import net.minecraft.core.net.packet.BoatControlPacket;
import net.minecraft.core.net.packet.ChatPacket;
import net.minecraft.core.net.packet.CommandManagerPacket;
import net.minecraft.core.net.packet.ContainerAckPacket;
import net.minecraft.core.net.packet.ContainerClickPacket;
import net.minecraft.core.net.packet.ContainerClosePacket;
import net.minecraft.core.net.packet.ContainerSetSlotPacket;
import net.minecraft.core.net.packet.CustomPayloadPacket;
import net.minecraft.core.net.packet.DisconnectPacket;
import net.minecraft.core.net.packet.GuidebookPacket;
import net.minecraft.core.net.packet.InteractPacket;
import net.minecraft.core.net.packet.KeepAlivePacket;
import net.minecraft.core.net.packet.MovePlayerPacket;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.core.net.packet.PlayerActionPacket;
import net.minecraft.core.net.packet.RequestCommandManagerPacket;
import net.minecraft.core.net.packet.RespawnPacket;
import net.minecraft.core.net.packet.SetCarriedItemPacket;
import net.minecraft.core.net.packet.SetHotbarOffsetPacket;
import net.minecraft.core.net.packet.SetItemNamePacket;
import net.minecraft.core.net.packet.SetMobSpawnerPacket;
import net.minecraft.core.net.packet.SetPaintingArtPacket;
import net.minecraft.core.net.packet.SignUpdatePacket;
import net.minecraft.core.net.packet.UpdateCreativeInventoryPacket;
import net.minecraft.core.net.packet.UpdatePlayerProfilePacket;
import net.minecraft.core.net.packet.UpdatePlayerStatePacket;
import net.minecraft.core.net.packet.UseItemPacket;
import net.minecraft.core.player.gamemode.Gamemode;
import net.minecraft.core.player.inventory.container.Inventory;
import net.minecraft.core.player.inventory.menu.CreativeInventoryMenu;
import net.minecraft.core.player.inventory.menu.FlagMenu;
import net.minecraft.core.player.inventory.slot.Slot;
import net.minecraft.core.util.helper.AES;
import net.minecraft.core.util.helper.ChatAllowedCharacters;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.RestHandler;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.util.phys.HitResult;
import net.minecraft.core.util.phys.Vec3;
import net.minecraft.core.world.chunk.ChunkCoordinates;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.entity.player.ServerPlayer;
import net.minecraft.server.net.command.ServerCommandSource;
import net.minecraft.server.util.helper.PlayerList;
import net.minecraft.server.world.WorldServer;
import org.slf4j.Logger;

public class ServerPacketHandler
extends PacketHandler
implements ICommandListener {
    public static Logger LOGGER = LogUtils.getLogger();
    public NetworkManager netManager;
    public boolean connectionClosed = false;
    private final MinecraftServer mcServer;
    private ServerPlayer playerEntity;
    private int field_15_f;
    private int field_22004_g;
    private int playerInAirTime;
    private double lastPosX;
    private double lastPosY;
    private double lastPosZ;
    private boolean hasMoved = true;
    private final Map<Integer, Short> guiIdMap = new HashMap<Integer, Short>();

    public ServerPacketHandler(MinecraftServer minecraftserver, NetworkManager networkManager, ServerPlayer player) {
        this.mcServer = minecraftserver;
        this.netManager = networkManager;
        networkManager.setNetHandler(this);
        this.playerEntity = player;
        player.playerNetServerHandler = this;
    }

    public void handlePackets() {
        this.netManager.processReadPackets();
        if (this.field_15_f - this.field_22004_g > 20) {
            this.sendPacket(new KeepAlivePacket());
        }
    }

    public boolean canInteract() {
        return this.playerEntity.getGamemode().canInteract() && this.playerEntity.isAlive();
    }

    public void kickPlayer(String s) {
        this.playerEntity.func_30002_A();
        this.sendPacket(new DisconnectPacket(s));
        this.netManager.serverShutdown();
        this.mcServer.playerList.sendPacketToAllPlayers(new ChatPacket(this.playerEntity.getDisplayName() + TextFormatting.YELLOW + " was kicked from the game."));
        this.mcServer.playerList.sendPacketToAllPlayers(new UpdatePlayerProfilePacket(this.playerEntity.username, this.playerEntity.nickname, this.playerEntity.uuid, this.playerEntity.score, this.playerEntity.chatColor, false, this.playerEntity.isOperator()));
        this.mcServer.playerList.playerLoggedOut(this.playerEntity);
        this.connectionClosed = true;
        if (MinecraftServer.statsStatus) {
            RestHandler.post("https://api.betterthanadventure.net/stats?serverToken=" + MinecraftServer.statsToken + "&count=" + this.mcServer.playerList.playerEntities.size());
        }
        PlayerList.updateList();
    }

    @Override
    public void handleSetMobSpawner(SetMobSpawnerPacket packet) {
        BlockEntity tileentity;
        WorldServer world = this.mcServer.getDimensionWorld(this.playerEntity.dimension);
        if (this.playerEntity.getGamemode() == Gamemode.creative && world.isBlockLoaded(packet.xPosition, packet.yPosition, packet.zPosition) && (tileentity = world.getBlockEntity(packet.xPosition, packet.yPosition, packet.zPosition)) instanceof MobSpawnerBlockEntity) {
            MobSpawnerBlockEntity tileEntityMobSpawner = (MobSpawnerBlockEntity)tileentity;
            tileEntityMobSpawner.setMobId(packet.spawnType);
            tileEntityMobSpawner.setChanged();
            world.markBlockNeedsUpdate(packet.xPosition, packet.yPosition, packet.zPosition);
        }
    }

    @Override
    public void handleFlying(MovePlayerPacket packet) {
        boolean sitting;
        if (!this.playerEntity.isAlive()) {
            return;
        }
        WorldServer worldserver = this.mcServer.getDimensionWorld(this.playerEntity.dimension);
        if (!this.hasMoved) {
            double d = packet.y - this.lastPosY;
            double dx = packet.x - this.lastPosX;
            double dy = packet.y - this.lastPosY;
            double dz = packet.z - this.lastPosZ;
            dx *= dx;
            dy *= dy;
            dz *= dz;
            if (dx * dx < 0.01 && dy * dy < 0.01 && dz * dz < 0.01) {
                this.hasMoved = true;
            }
        }
        if (!this.hasMoved) {
            return;
        }
        float yRot = this.playerEntity.yRot;
        float xRot = this.playerEntity.xRot;
        if (packet.hasRotation) {
            yRot = MathHelper.normalizeRotation(packet.yaw);
            xRot = MathHelper.normalizeRotation(packet.pitch);
        }
        boolean sleeping = this.playerEntity.isPlayerSleeping();
        boolean bl = sitting = this.playerEntity.vehicle != null && !(this.playerEntity.vehicle instanceof Entity);
        if (sleeping || sitting) {
            if (sitting) {
                this.playerEntity.vehicle.positionRider();
            }
            this.playerEntity.onUpdateEntity();
            this.playerEntity.absMoveTo(this.lastPosX, this.lastPosY, this.lastPosZ, this.playerEntity.yRot, this.playerEntity.xRot);
            worldserver.updateEntity(this.playerEntity);
            return;
        }
        if (this.playerEntity.vehicle instanceof Entity) {
            this.playerEntity.vehicle.positionRider();
            double xd = 0.0;
            double zd = 0.0;
            if (packet.hasPosition && packet.y == -999.0) {
                xd = packet.x;
                zd = packet.z;
            }
            this.playerEntity.onGround = packet.onGround;
            this.playerEntity.onUpdateEntity();
            this.playerEntity.move(xd, 0.0, zd);
            this.playerEntity.absMoveTo(this.playerEntity.x, this.playerEntity.y, this.playerEntity.z, yRot, xRot);
            this.playerEntity.xd = xd;
            this.playerEntity.zd = zd;
            this.playerEntity.vehicle.positionRider();
            return;
        }
        this.lastPosX = this.playerEntity.x;
        this.lastPosY = this.playerEntity.y;
        this.lastPosZ = this.playerEntity.z;
        double newPosX = this.playerEntity.x;
        double newPosY = this.playerEntity.y;
        double oldPosY = this.playerEntity.y;
        double newPosZ = this.playerEntity.z;
        if (packet.hasPosition && packet.y == -999.0) {
            packet.hasPosition = false;
        }
        if (packet.hasPosition) {
            newPosX = packet.x;
            newPosY = packet.y;
            newPosZ = packet.z;
            if (Math.abs(packet.x) > 3.2E7 || Math.abs(packet.z) > 3.2E7 || Double.isNaN(packet.x) || Double.isNaN(packet.y) || Double.isNaN(packet.z)) {
                LOGGER.warn("{} tried to move to an illegal position", (Object)this.playerEntity.username);
                this.teleportAndRotate(this.lastPosX, this.lastPosY, this.lastPosZ, yRot, xRot);
                return;
            }
        }
        this.playerEntity.onUpdateEntity();
        this.playerEntity.ySlideOffset = 0.0f;
        this.playerEntity.absMoveTo(this.lastPosX, this.lastPosY, this.lastPosZ, yRot, xRot);
        if (!this.hasMoved) {
            return;
        }
        double dx = newPosX - this.playerEntity.x;
        double dy = newPosY - this.playerEntity.y;
        double dz = newPosZ - this.playerEntity.z;
        double velSquared = dx * dx + dy * dy + dz * dz;
        if (velSquared > 100.0) {
            LOGGER.warn("{} moved too quickly!", (Object)this.playerEntity.username);
            this.teleportAndRotate(this.lastPosX, this.lastPosY, this.lastPosZ, yRot, xRot);
            return;
        }
        float bb_expand = 0.0625f;
        boolean insideBlockOld = worldserver.getCubes(this.playerEntity, this.playerEntity.bb.copy().getInsetBoundingBox(bb_expand, bb_expand, bb_expand)).isEmpty();
        this.playerEntity.move(dx, dy, dz);
        dx = newPosX - this.playerEntity.x;
        double ndy = newPosY - this.playerEntity.y;
        dz = newPosZ - this.playerEntity.z;
        velSquared = dx * dx + ndy * ndy + dz * dz;
        boolean movedWrong = false;
        if (!this.playerEntity.getGamemode().canPlayerFly() && velSquared > 0.0625 && !this.playerEntity.isPlayerSleeping()) {
            movedWrong = true;
            LOGGER.warn("{} moved wrongly!", (Object)this.playerEntity.username);
            LOGGER.warn("Got position {}, {}, {}", newPosX, newPosY, newPosZ);
            LOGGER.warn("Expected {}, {}, {}", this.playerEntity.x, this.playerEntity.y, this.playerEntity.z);
        }
        this.playerEntity.absMoveTo(newPosX, newPosY, newPosZ, yRot, xRot);
        boolean insideBlockNew = worldserver.getCubes(this.playerEntity, this.playerEntity.bb.copy().getInsetBoundingBox(bb_expand, bb_expand, bb_expand)).isEmpty();
        if (!(this.playerEntity.getGamemode().canPlayerFly() || !insideBlockOld || !movedWrong && insideBlockNew || this.playerEntity.isPlayerSleeping())) {
            this.teleportAndRotate(this.lastPosX, this.lastPosY, this.lastPosZ, yRot, xRot);
            return;
        }
        AABB aabb = this.playerEntity.bb.copy().grow(bb_expand, bb_expand, bb_expand).expand(0.0, -0.55, 0.0);
        if (!(this.playerEntity.getGamemode().canPlayerFly() || this.mcServer.allowFlight || worldserver.getIsAnySolidGround(aabb))) {
            if (dy > -0.03125) {
                ++this.playerInAirTime;
                if (this.playerInAirTime > 100) {
                    LOGGER.warn(this.playerEntity.username + " was kicked for floating too long!");
                    this.kickPlayer("Flying is not enabled on this server");
                    return;
                }
            }
        } else {
            this.playerInAirTime = 0;
        }
        this.playerEntity.onGround = packet.onGround;
        this.mcServer.playerList.onPlayerMoved(this.playerEntity);
        this.playerEntity.handleFalling(this.playerEntity.y - oldPosY, packet.onGround);
    }

    public void teleport(double x, double y, double z) {
        this.hasMoved = false;
        this.lastPosX = x;
        this.lastPosY = y;
        this.lastPosZ = z;
        this.playerEntity.absMoveTo(x, y, z, this.playerEntity.yRot, this.playerEntity.xRot);
        this.playerEntity.playerNetServerHandler.sendPacket(new MovePlayerPacket.Pos(x, y + 1.625, z, false));
    }

    public void teleportAndRotate(double x, double y, double z, float yaw, float pitch) {
        this.hasMoved = false;
        this.lastPosX = x;
        this.lastPosY = y;
        this.lastPosZ = z;
        this.playerEntity.absMoveTo(x, y, z, yaw, pitch);
        this.playerEntity.playerNetServerHandler.sendPacket(new MovePlayerPacket.PosRot(x, y + 1.625, z, yaw, pitch, false));
    }

    @Override
    public void handleBlockDig(PlayerActionPacket playerActionPacket) {
        int spawnDistZ;
        int x = playerActionPacket.xPosition;
        int y = playerActionPacket.yPosition;
        int z = playerActionPacket.zPosition;
        if (!this.canInteract() || this.playerEntity.getHeldObject() != null) {
            return;
        }
        WorldServer world = this.mcServer.getDimensionWorld(this.playerEntity.dimension);
        if (playerActionPacket.action == 4) {
            this.playerEntity.dropCurrentItem(false);
            return;
        }
        if (playerActionPacket.action == 5) {
            this.playerEntity.dropCurrentItem(true);
            return;
        }
        if (playerActionPacket.action == 6) {
            this.playerEntity.pickBlock(x, y, z);
            return;
        }
        double playerDistX = this.playerEntity.x - ((double)x + 0.5);
        double playerDistY = this.playerEntity.y - ((double)y + 0.5);
        double playerDistZ = this.playerEntity.z - ((double)z + 0.5);
        double playerDist = playerDistX * playerDistX + playerDistY * playerDistY + playerDistZ * playerDistZ;
        if (playerDist > 44.0) {
            return;
        }
        boolean ignoreSpawnProtection = this.mcServer.spawnProtectionRange <= 0 || world.dimension.id != 0 || this.mcServer.playerList.isOp(this.playerEntity.uuid);
        ChunkCoordinates spawnPos = world.getSpawnPoint();
        int spawnDistX = (int)MathHelper.abs(x - spawnPos.x);
        int distanceFromSpawn = Math.max(spawnDistX, spawnDistZ = (int)MathHelper.abs(z - spawnPos.z));
        if (distanceFromSpawn <= this.mcServer.spawnProtectionRange && !ignoreSpawnProtection) {
            this.playerEntity.playerNetServerHandler.sendPacket(new BlockUpdatePacket(x, y, z, world));
            return;
        }
        if (playerActionPacket.action == 0) {
            this.playerEntity.playerController.startMining(x, y, z, playerActionPacket.side);
        } else if (playerActionPacket.action == 1) {
            this.playerEntity.playerController.hitBlock(x, y, z, playerActionPacket.side, playerActionPacket.xHit, playerActionPacket.yHit);
        } else if (playerActionPacket.action == 2 && !this.playerEntity.playerController.destroyBlock(x, y, z, playerActionPacket.side)) {
            this.playerEntity.playerNetServerHandler.sendPacket(new BlockUpdatePacket(x, y, z, world));
        }
    }

    public void handleSendInitialPlayerList() {
        for (ServerPlayer serverPlayer : this.mcServer.playerList.playerEntities) {
            this.sendPacket(new UpdatePlayerProfilePacket(serverPlayer.username, serverPlayer.nickname, serverPlayer.uuid, serverPlayer.score, serverPlayer.chatColor, true, serverPlayer.isOperator()));
        }
    }

    @Override
    public void handlePlace(UseItemPacket packet) {
        boolean ignoreSpawnProtection;
        if (!this.canInteract()) {
            return;
        }
        WorldServer worldserver = this.mcServer.getDimensionWorld(this.playerEntity.dimension);
        ItemStack itemstack = this.playerEntity.inventory.getCurrentItem();
        boolean bl = ignoreSpawnProtection = this.mcServer.spawnProtectionRange <= 0 || worldserver.dimension.id != 0 || this.mcServer.playerList.isOp(this.playerEntity.uuid);
        if (packet.direction == Direction.NONE) {
            if (itemstack == null) {
                return;
            }
            this.playerEntity.playerController.useItemOnNothing(this.playerEntity, worldserver, itemstack);
        } else {
            int j1;
            int x = packet.xPosition;
            int y = packet.yPosition;
            int z = packet.zPosition;
            Direction direction = packet.direction;
            double xPlaced = packet.xPlaced;
            double yPlaced = packet.yPlaced;
            ChunkCoordinates chunkcoordinates = worldserver.getSpawnPoint();
            int i1 = (int)MathHelper.abs(x - chunkcoordinates.x);
            if (i1 > (j1 = (int)MathHelper.abs(z - chunkcoordinates.z))) {
                j1 = i1;
            }
            if (this.hasMoved && this.playerEntity.distanceToSqr((double)x + 0.5, (double)y + 0.5, (double)z + 0.5) < 64.0 && (j1 > this.mcServer.spawnProtectionRange || ignoreSpawnProtection)) {
                this.playerEntity.playerController.activateBlockOrUseItem(this.playerEntity, worldserver, itemstack, x, y, z, direction.getSide(), xPlaced, yPlaced);
            }
            this.playerEntity.playerNetServerHandler.sendPacket(new BlockUpdatePacket(x, y, z, worldserver));
            this.playerEntity.playerNetServerHandler.sendPacket(new BlockUpdatePacket(x += direction.getOffsetX(), y += direction.getOffsetY(), z += direction.getOffsetZ(), worldserver));
        }
        itemstack = this.playerEntity.inventory.getCurrentItem();
        if (itemstack != null && itemstack.stackSize <= 0) {
            this.playerEntity.inventory.mainInventory[this.playerEntity.inventory.getCurrentItemIndex()] = null;
        }
        this.playerEntity.isChangingQuantityOnly = true;
        this.playerEntity.inventory.mainInventory[this.playerEntity.inventory.getCurrentItemIndex()] = ItemStack.copyItemStack(this.playerEntity.inventory.mainInventory[this.playerEntity.inventory.getCurrentItemIndex()]);
        Slot slot = this.playerEntity.craftingInventory.getSlotFor(this.playerEntity.inventory, this.playerEntity.inventory.getCurrentItemIndex());
        this.playerEntity.craftingInventory.broadcastChanges();
        this.playerEntity.isChangingQuantityOnly = false;
        if (slot == null) {
            LOGGER.warn("Couldn't find slot for index '{}' in {}'s inventory while they were in the {} container!", this.playerEntity.inventory.getCurrentItemIndex(), this.playerEntity.username, this.playerEntity.craftingInventory.getClass().getSimpleName());
            return;
        }
        if (!ItemStack.areItemStacksEqual(this.playerEntity.inventory.getCurrentItem(), packet.itemStack)) {
            this.sendPacket(new ContainerSetSlotPacket(this.playerEntity.craftingInventory.containerId, slot.index, this.playerEntity.inventory.getCurrentItem()));
        }
    }

    @Override
    public void handleErrorMessage(String message, Object[] objects) {
        LOGGER.info(this.playerEntity.username + " lost connection: " + message);
        this.mcServer.playerList.sendPacketToAllPlayers(new ChatPacket(this.playerEntity.getDisplayName() + TextFormatting.YELLOW + " left the game."));
        this.mcServer.playerList.sendPacketToAllPlayers(new UpdatePlayerProfilePacket(this.playerEntity.username, this.playerEntity.nickname, this.playerEntity.uuid, this.playerEntity.score, this.playerEntity.chatColor, false, this.playerEntity.isOperator()));
        this.mcServer.playerList.playerLoggedOut(this.playerEntity);
        this.connectionClosed = true;
        if (MinecraftServer.statsStatus) {
            RestHandler.post("https://api.betterthanadventure.net/stats?serverToken=" + MinecraftServer.statsToken + "&count=" + this.mcServer.playerList.playerEntities.size());
        }
        PlayerList.updateList();
    }

    @Override
    public void handleInvalidPacket(Packet packet) {
        LOGGER.warn("{} wasn't prepared to deal with a {}", (Object)this.getClass(), (Object)packet.getClass());
        this.kickPlayer("Protocol error, unexpected packet");
    }

    public void sendPacket(Packet packet) {
        this.netManager.addToSendQueue(packet);
        this.field_22004_g = this.field_15_f;
    }

    @Override
    public void handleBlockItemSwitch(SetCarriedItemPacket setCarriedItemPacket) {
        if (setCarriedItemPacket.id < 0 || setCarriedItemPacket.id > Inventory.playerMainInventorySize()) {
            LOGGER.warn("{} tried to set an invalid carried item", (Object)this.playerEntity.username);
        } else {
            this.playerEntity.inventory.setCurrentItemIndex(setCarriedItemPacket.id, false);
            if (setCarriedItemPacket.id != this.playerEntity.inventory.getCurrentItemIndex()) {
                this.sendPacket(new SetCarriedItemPacket(setCarriedItemPacket.id));
            }
        }
    }

    @Override
    public void handleChat(ChatPacket packet) {
        String message;
        if (packet.encrypted) {
            try {
                message = AES.decrypt(packet.message, AES.keyChain.get(this.playerEntity.username));
            }
            catch (Exception e) {
                throw new RuntimeException("This crash is caused by outdated Java, please update to 8u161 or newer! If your Java version is out of date due to a technical requirement, please add the JCE Unlimited Strength Jurisdiction Policy Files to your installation. https://www.oracle.com/java/technologies/javase-jce-all-downloads.html", e);
            }
        } else {
            message = packet.message;
        }
        if (message.length() > 256) {
            message = message.substring(0, 255);
        }
        message = message.trim();
        for (int i = 0; i < message.length(); ++i) {
            char c = message.charAt(i);
            if (ChatAllowedCharacters.ALLOWED_CHARACTERS.indexOf(c) >= 0) continue;
            this.sendPacket(new ChatPacket(String.valueOf(TextFormatting.GRAY) + TextFormatting.ITALIC + "[SERVER] Illegal characters in chat message."));
            return;
        }
        if (message.startsWith("/")) {
            this.handleSlashCommand(message);
        } else {
            message = ChatEmotes.process(message);
            message = "<" + this.playerEntity.getDisplayName() + TextFormatting.RESET + "> " + TextFormatting.WHITE + message;
            LOGGER.info(message);
            this.mcServer.playerList.sendEncryptedChatToAllPlayers(message);
        }
    }

    private void handleSlashCommand(String s) {
        ServerCommandSource serverCommandSource = new ServerCommandSource(this.mcServer, this.playerEntity);
        try {
            this.playerEntity.world.getCommandManager().execute(s.substring(1), serverCommandSource);
        }
        catch (CommandSyntaxException e) {
            this.playerEntity.playerNetServerHandler.sendPacket(new ChatPacket(TextFormatting.RED + e.getMessage(), AES.keyChain.get(this.playerEntity.username)));
        }
    }

    @Override
    public void handleAnimation(AnimatePacket packet) {
        if (!this.playerEntity.isAlive()) {
            return;
        }
        if (packet.animate == 1) {
            this.playerEntity.swingItem();
        }
    }

    @Override
    public void handlePlayerState(UpdatePlayerStatePacket updatePlayerStatePacket) {
        if (!this.playerEntity.isAlive()) {
            return;
        }
        if (updatePlayerStatePacket.state == 1) {
            this.playerEntity.setSneaking(true);
        } else if (updatePlayerStatePacket.state == 2) {
            this.playerEntity.setSneaking(false);
        } else if (updatePlayerStatePacket.state == 3) {
            this.playerEntity.wakeUpPlayer(false, true);
            this.hasMoved = false;
        }
    }

    @Override
    public void handleBoatControl(BoatControlPacket boatControlPacket) {
        if (!this.canInteract()) {
            return;
        }
        if (this.playerEntity.vehicle != null && this.playerEntity.vehicle instanceof BoatEntity && !Double.isNaN(boatControlPacket.targetXD) && !Double.isNaN(boatControlPacket.targetZD)) {
            BoatEntity boat = (BoatEntity)this.playerEntity.vehicle;
            boat.handleControlDirect(boatControlPacket.targetXD, boatControlPacket.targetZD, boatControlPacket.targetYRot);
            boatControlPacket.entityId = boat.id;
            this.mcServer.playerList.sendPacketToOtherPlayersAroundPoint(this.playerEntity, boat.x, boat.y, boat.z, 128.0, boat.world.dimension.id, boatControlPacket);
        }
    }

    @Override
    public void handleKickDisconnect(DisconnectPacket packet) {
        this.netManager.networkShutdown("disconnect.quitting", new Object[0]);
    }

    public int getNumChunkDataPackets() {
        return this.netManager.getNumChunkDataPackets();
    }

    @Override
    public void logInfo(String s) {
        this.sendPacket(new ChatPacket("\u00a77" + s));
    }

    @Override
    public String getUsername() {
        return this.playerEntity.username;
    }

    @Override
    public void handleUseEntity(InteractPacket interactPacket) {
        if (!this.playerEntity.getGamemode().canInteract() || !this.playerEntity.isAlive() || this.playerEntity.getHeldObject() != null) {
            return;
        }
        WorldServer worldserver = this.mcServer.getDimensionWorld(this.playerEntity.dimension);
        Entity targetEntity = worldserver.getEntityFromId(interactPacket.targetEntityID);
        if (targetEntity != null && this.playerEntity.distanceToSqr(targetEntity) < 36.0) {
            boolean canAttack = this.playerEntity.canEntityBeSeen(targetEntity);
            if (!canAttack) {
                float f1 = MathHelper.cos(-this.playerEntity.yRot * 0.01745329f - (float)Math.PI);
                float f2 = MathHelper.sin(-this.playerEntity.yRot * 0.01745329f - (float)Math.PI);
                float f3 = -MathHelper.cos(-this.playerEntity.xRot * 0.01745329f);
                float f4 = MathHelper.sin(-this.playerEntity.xRot * 0.01745329f);
                Vec3 viewVector = Vec3.getTempVec3(f2 * f3, f4, f1 * f3);
                viewVector.x *= 8.0;
                viewVector.y *= 8.0;
                viewVector.z *= 8.0;
                viewVector.x += this.playerEntity.x;
                viewVector.y += this.playerEntity.y;
                viewVector.z += this.playerEntity.z;
                Vec3 playerViewPos = Vec3.getTempVec3(this.playerEntity.x, this.playerEntity.y + (double)this.playerEntity.getHeadHeight(), this.playerEntity.z);
                HitResult movingObjectPosition = targetEntity.bb.clip(playerViewPos, viewVector);
                boolean bl = canAttack = movingObjectPosition != null && worldserver.checkBlockCollisionBetweenPoints(playerViewPos, movingObjectPosition.location) == null;
            }
            if (canAttack) {
                if (interactPacket.action == 0) {
                    this.playerEntity.useCurrentItemOnEntity(targetEntity);
                } else if (interactPacket.action == 1) {
                    this.playerEntity.attackTargetEntityWithCurrentItem(targetEntity);
                }
            }
        }
    }

    @Override
    public void handleOpenGuidebook(GuidebookPacket packet) {
        this.playerEntity.displayGUIGuidebook();
    }

    @Override
    public void handleRespawn(RespawnPacket packet) {
        if (this.playerEntity.getHealth() <= 0) {
            this.playerEntity = this.mcServer.playerList.recreatePlayerEntity(this.playerEntity, 0);
        }
    }

    @Override
    public void handleCloseWindow(ContainerClosePacket containerClosePacket) {
        this.playerEntity.closeCraftingGui();
    }

    @Override
    public void handleWindowClick(ContainerClickPacket containerClickPacket) {
        if (this.playerEntity.craftingInventory.containerId == containerClickPacket.window_Id && this.playerEntity.craftingInventory.isSynched(this.playerEntity)) {
            ItemStack itemstack = this.playerEntity.craftingInventory.clicked(containerClickPacket.action, containerClickPacket.args, this.playerEntity);
            if (ItemStack.areItemStacksEqual(containerClickPacket.itemStack, itemstack)) {
                this.playerEntity.playerNetServerHandler.sendPacket(new ContainerAckPacket(containerClickPacket.window_Id, containerClickPacket.actionId, true));
                this.playerEntity.isChangingQuantityOnly = true;
                this.playerEntity.craftingInventory.broadcastChanges();
                this.playerEntity.updateHeldItem();
                this.playerEntity.isChangingQuantityOnly = false;
            } else {
                this.guiIdMap.put(this.playerEntity.craftingInventory.containerId, containerClickPacket.actionId);
                this.playerEntity.playerNetServerHandler.sendPacket(new ContainerAckPacket(containerClickPacket.window_Id, containerClickPacket.actionId, false));
                this.playerEntity.craftingInventory.setSynched(this.playerEntity, false);
                ArrayList<ItemStack> arraylist = new ArrayList<ItemStack>();
                for (int i = 0; i < this.playerEntity.craftingInventory.slots.size(); ++i) {
                    arraylist.add(this.playerEntity.craftingInventory.slots.get(i).getItem());
                }
                this.playerEntity.updateCraftingInventory(this.playerEntity.craftingInventory, arraylist);
            }
        }
    }

    @Override
    public void handleTransaction(ContainerAckPacket packet) {
        Short short1 = this.guiIdMap.get(this.playerEntity.craftingInventory.containerId);
        if (short1 != null && packet.shortWindowId == short1 && this.playerEntity.craftingInventory.containerId == packet.windowId && !this.playerEntity.craftingInventory.isSynched(this.playerEntity)) {
            this.playerEntity.craftingInventory.setSynched(this.playerEntity, true);
        }
    }

    @Override
    public void handleUpdateSign(SignUpdatePacket signUpdatePacket) {
        if (!this.playerEntity.getGamemode().canInteract() || !this.playerEntity.isAlive()) {
            return;
        }
        WorldServer worldserver = this.mcServer.getDimensionWorld(this.playerEntity.dimension);
        if (worldserver.isBlockLoaded(signUpdatePacket.xPosition, signUpdatePacket.yPosition, signUpdatePacket.zPosition)) {
            SignBlockEntity sign;
            BlockEntity blockEntity = worldserver.getBlockEntity(signUpdatePacket.xPosition, signUpdatePacket.yPosition, signUpdatePacket.zPosition);
            if (blockEntity instanceof SignBlockEntity && !(sign = (SignBlockEntity)blockEntity).isEditableBy(this.playerEntity)) {
                LOGGER.warn("Player {} just tried to change non-editable sign", (Object)this.playerEntity.username);
                return;
            }
            for (int i = 0; i < 4; ++i) {
                boolean isLineValid = true;
                if (signUpdatePacket.signLines[i].length() > 15) {
                    isLineValid = false;
                } else {
                    signUpdatePacket.signLines[i] = signUpdatePacket.signLines[i].replaceAll("\u00a7", "$");
                    for (int l = 0; l < signUpdatePacket.signLines[i].length(); ++l) {
                        if (ChatAllowedCharacters.ALLOWED_CHARACTERS.indexOf(signUpdatePacket.signLines[i].charAt(l)) >= 0) continue;
                        isLineValid = false;
                        break;
                    }
                }
                if (isLineValid) continue;
                signUpdatePacket.signLines[i] = "!?";
            }
            if (blockEntity instanceof SignBlockEntity) {
                int x = signUpdatePacket.xPosition;
                int y = signUpdatePacket.yPosition;
                int z = signUpdatePacket.zPosition;
                SignBlockEntity tileEntity = (SignBlockEntity)blockEntity;
                System.arraycopy(signUpdatePacket.signLines, 0, tileEntity.signText, 0, 4);
                tileEntity.setColor(TextFormatting.FORMATTINGS[signUpdatePacket.color]);
                tileEntity.setPicture(EnumSignPicture.values()[signUpdatePacket.picture]);
                tileEntity.setChanged();
                worldserver.markBlockNeedsUpdate(x, y, z);
            }
        }
    }

    @Override
    public void handleUpdateCreativeInventory(UpdateCreativeInventoryPacket packet) {
        if (this.playerEntity.craftingInventory.containerId == packet.windowId && this.playerEntity.craftingInventory instanceof CreativeInventoryMenu) {
            ((CreativeInventoryMenu)this.playerEntity.craftingInventory).setInventoryStatus(packet.page, packet.searchText);
        }
    }

    @Override
    public void handleSetHotbarOffset(SetHotbarOffsetPacket packet) {
        this.playerEntity.inventory.setHotbarOffset(packet.hotbarOffset, false);
        if (packet.hotbarOffset != this.playerEntity.inventory.getHotbarOffset()) {
            this.sendPacket(new SetHotbarOffsetPacket(packet.hotbarOffset));
        }
    }

    @Override
    public void handleItemName(SetItemNamePacket packet) {
        String name = packet.name;
        if (name.length() > 16) {
            name = packet.name.substring(0, 16);
        }
        this.playerEntity.inventory.getItem(packet.slot).setCustomName(name);
    }

    @Override
    public void handleSetPaintingMotive(SetPaintingArtPacket setPaintingArtPacket) {
        this.playerEntity.setSelectedArt(ArtType.values.get(setPaintingArtPacket.motive));
    }

    @Override
    public void handleCustomPayload(CustomPayloadPacket customPayloadPacket) {
        if ("BTA|RotationLock".equals(customPayloadPacket.channel)) {
            if (customPayloadPacket.data.length == 4) {
                this.playerEntity.rotationLock = Direction.getDirectionById(customPayloadPacket.data[0]);
                this.playerEntity.rotationLockHorizontal = Direction.getDirectionById(customPayloadPacket.data[1]);
                this.playerEntity.rotationLockVertical = Direction.getDirectionById(customPayloadPacket.data[2]);
                this.playerEntity.placementModeOverride = PlacementMode.get(customPayloadPacket.data[3]);
            }
        } else if ("BTA|Flag".equals(customPayloadPacket.channel)) {
            if (customPayloadPacket.data.length == 384 && this.playerEntity.craftingInventory instanceof FlagMenu) {
                FlagMenu flagMenu = (FlagMenu)this.playerEntity.craftingInventory;
                FlagBlockEntity flag = flagMenu.flag;
                if (flag.owner == null || flag.owner.equals(this.playerEntity.uuid)) {
                    flag.owner = this.playerEntity.uuid;
                    System.arraycopy(customPayloadPacket.data, 0, flag.flagColors, 0, 384);
                    this.playerEntity.world.markBlockNeedsUpdate(flag.x, flag.y, flag.z);
                } else {
                    LOGGER.warn("Player '{}' tried editing a flag that belongs to '{}'!", (Object)this.playerEntity.username, (Object)flag.owner);
                    this.playerEntity.world.markBlockNeedsUpdate(flag.x, flag.y, flag.z);
                }
            }
        } else if ("BTA|WandMonster".equals(customPayloadPacket.channel) && this.playerEntity.getHeldItem() != null && this.playerEntity.getHeldItem().getItem() == Items.WAND_MONSTER_SPAWNER) {
            String id = new String(customPayloadPacket.data, StandardCharsets.UTF_8);
            this.playerEntity.getHeldItem().getData().putString("monster", id);
        }
    }

    @Override
    public void handleRequestCommandManagerPacket(RequestCommandManagerPacket packet) {
        this.sendPacket(new CommandManagerPacket(this.mcServer.getDimensionWorld(this.playerEntity.dimension).getCommandManager().getDispatcher(), new ServerCommandSource(this.mcServer, this.playerEntity), packet.text, packet.cursor));
    }

    @Override
    public boolean isServerHandler() {
        return true;
    }
}

