/*
 * Decompiled with CFR 0.152.
 */
package org.useless.seedviewer.bta;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.material.MaterialColor;
import org.jetbrains.annotations.NotNull;
import org.useless.seedviewer.bta.BTABiome;
import org.useless.seedviewer.collections.ChunkPos2D;
import org.useless.seedviewer.collections.ChunkPos3D;
import org.useless.seedviewer.data.Biome;
import org.useless.seedviewer.data.Chunk;

public class BTAComplexChunk
implements Chunk {
    private final net.minecraft.core.world.chunk.Chunk chunk;

    public BTAComplexChunk(@NotNull net.minecraft.core.world.chunk.Chunk chunk) {
        this.chunk = chunk;
    }

    @Override
    public Biome getBiome(ChunkPos3D pos) {
        return new BTABiome(this.chunk.getBlockBiome(pos.x, pos.y, pos.z));
    }

    @Override
    public int getBlockColor(ChunkPos3D pos) {
        Block b = Block.getBlock(this.chunk.getBlockID(pos.x, pos.y, pos.z));
        if (b == null) {
            return 0;
        }
        int meta = this.chunk.getBlockMetadata(pos.x, pos.y, pos.z);
        return MaterialColor.getColorFromIndex(MaterialColor.getColorIndexFromBlock(b, meta)) | 0xFF000000;
    }

    @Override
    public int getHeight(ChunkPos2D pos) {
        return this.chunk.getHeightValue(pos.x, pos.z);
    }

    @Override
    public int getWaterDepth(ChunkPos2D pos) {
        Block b;
        int y;
        int start = this.getHeight(pos) - 1;
        int depth = 0;
        while ((y = start - depth) >= 0 && (b = Block.getBlock(this.chunk.getBlockID(pos.x, y, pos.z))) != null && b.blockMaterial == Material.water) {
            ++depth;
        }
        return depth;
    }
}

